/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional.xml;

import com.tripwire.common.util.xml.AbstractXmlElementParser;
import com.tripwire.common.util.xml.XmlElementName;
import com.tripwire.common.util.xml.XmlElementParser;
import com.tripwire.common.util.xml.XmlException;
import com.tripwire.common.util.xml.XmlInputContext;
import com.tripwire.space.core.conditional.Conditional;
import com.tripwire.space.core.conditional.listener.ElementEventConditions;
import com.tripwire.space.core.xml.GlobalXmlInputFormat;
import java.io.IOException;

public class ConditionXmlParser
extends AbstractXmlElementParser {
    public ConditionXmlParser(XmlElementName element, Class targetClass) {
        super(element, targetClass);
    }

    protected Object createInstance(XmlInputContext in) throws XmlException {
        return new Proxy(this.getTargetClass());
    }

    protected void readBody(XmlInputContext in, Object obj) throws XmlException, IOException {
        if (in.detectElementStart(NAME_ELEMENT)) {
            in.skipNextElement();
        }
        if (in.detectElementStart(DESCRIPTION_ELEMENT)) {
            in.skipNextElement();
        }
        XmlElementName condTag = in.getNameForNextElement();
        XmlElementParser conditionParser = GlobalXmlInputFormat.getInstance().getParserForElement(condTag);
        Proxy proxy = (Proxy)obj;
        proxy.setConditional((Conditional)conditionParser.read(in));
    }

    public static class Proxy {
        ElementEventConditions m_conditions;
        final Class m_conditionsClass;
        Conditional m_conditional;

        protected Proxy(Class conditionsClass) {
            this.m_conditionsClass = conditionsClass;
        }

        void setConditional(Conditional conditional) {
            this.m_conditional = conditional;
        }

        public Conditional getConditional() {
            return this.m_conditional;
        }

        public void setConditions(ElementEventConditions conditions) {
            this.m_conditions = conditions;
        }

        public ElementEventConditions getConditions() throws XmlException {
            if (this.m_conditions == null) {
                try {
                    this.m_conditions = (ElementEventConditions)this.m_conditionsClass.newInstance();
                    this.m_conditions.setCondition(this.m_conditional);
                }
                catch (Exception e) {
                    throw new XmlException(this.m_conditionsClass.getName(), e);
                }
            }
            return this.m_conditions;
        }
    }
}

