/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.honeybee.ui.view.main;

import com.tripwire.checker.app.TestResultType;
import com.tripwire.honeybee.ui.view.main.MainWindow;
import com.tripwire.honeybee.ui.view.main.ResultsCellData;
import com.tripwire.honeybee.ui.view.main.ResultsTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ResultsTable
extends JTable {
    private MainWindow m_mainWindow;

    public ResultsTable(ResultsTableModel model, MainWindow parentWindow) {
        this.m_mainWindow = parentWindow;
        this.setModel(model);
        this.setTableHeader(null);
        this.setAutoResizeMode(0);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        this.setFocusTraversalKeys(0, null);
        this.setFocusTraversalKeys(1, null);
        this.getInputMap().remove(KeyStroke.getKeyStroke("ENTER"));
        this.setFocusable(false);
        this.getSelectionModel().setSelectionMode(0);
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                Point p = new Point(e.getX(), e.getY());
                ResultsTable.this.m_mainWindow.onCellClick(ResultsTable.this.columnAtPoint(p), ResultsTable.this.rowAtPoint(p));
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        final Cursor handCursor = new Cursor(12);
        final Cursor defaultCursor = new Cursor(0);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                Point p = new Point(e.getX(), e.getY());
                String testId = ((ResultsTable)ResultsTable.this).m_mainWindow.m_rowToTestMap.get(ResultsTable.this.rowAtPoint(p));
                ResultsTable.this.setCursor(ResultsTable.this.isTestActionable(testId) && ResultsTable.this.columnAtPoint(p) == 1 ? handCursor : defaultCursor);
            }
        });
    }

    protected boolean isTestActionable(String testId) {
        if (testId == null) {
            return false;
        }
        TestResultType result = this.m_mainWindow.m_testToResultMap.get(testId);
        if (result == null) {
            return false;
        }
        if (this.m_mainWindow.m_marketingModel.getTopBanner().isSupplyingRemediationUrls()) {
            return true;
        }
        return result == TestResultType.ERROR || result == TestResultType.UNAVAILABLE;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof ResultsCellData) {
                    ResultsCellData cellData = (ResultsCellData)value;
                    switch (cellData.getStyle()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            rendererComponent.setFont(this.getFont().deriveFont(1));
                            break;
                        }
                        case 2: {
                            rendererComponent.setFont(this.getFont().deriveFont(1));
                            rendererComponent.setForeground(Color.GREEN.darker());
                            break;
                        }
                        case 3: {
                            rendererComponent.setFont(this.getFont().deriveFont(1));
                            rendererComponent.setForeground(Color.RED.darker());
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Invalid style value");
                        }
                    }
                }
                return rendererComponent;
            }
        };
        renderer.setFocusable(true);
        return renderer;
    }

    public void adjustColumnWidthsToFitData() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (int i = 0; i < ResultsTable.this.getModel().getColumnCount(); ++i) {
                    ResultsTable.this.doAdjustColumnWidthToFitData(i);
                }
            }
        });
    }

    public void adjustColumnWidthToFitData(final int columnIndex) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ResultsTable.this.doAdjustColumnWidthToFitData(columnIndex);
            }
        });
    }

    private void doAdjustColumnWidthToFitData(int columnIndex) {
        int calcWidth = 0;
        int padding = 10;
        TableColumn column = this.getColumnModel().getColumn(columnIndex);
        try {
            for (int rowIndex = 0; rowIndex < this.getModel().getRowCount(); ++rowIndex) {
                TableCellRenderer renderer = this.getCellRenderer(rowIndex, columnIndex);
                Component component = renderer.getTableCellRendererComponent(this, this.getValueAt(rowIndex, columnIndex), false, false, rowIndex, columnIndex);
                calcWidth = Math.max(calcWidth, component.getPreferredSize().width);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        column.setPreferredWidth(calcWidth += padding);
    }
}

