/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.honeybee.ui.view.eula;

import com.tripwire.common.util.ResourceManager;
import com.tripwire.honeybee.ui.controller.HoneybeeController;
import com.tripwire.honeybee.ui.controller.requests.RespondToEulaRequest;
import com.tripwire.honeybee.ui.model.eula.EulaModel;
import com.tripwire.honeybee.ui.util.ComponentFactory;
import com.tripwire.honeybee.ui.util.JOutputPane;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class EulaWindow {
    protected final HoneybeeController m_controller;
    protected final EulaModel m_model;
    protected boolean acceptedEula = false;
    private ResourceManager mainResources = ResourceManager.getInstance();
    protected JFrame frame;

    public EulaWindow(HoneybeeController controller, EulaModel model) {
        this.m_controller = controller;
        this.m_model = model;
        this.createWindow();
    }

    private void createWindow() {
        this.frame = ComponentFactory.createTopLevelFrame(this.mainResources.getString("window.title"), this.m_model.getWindowIcon());
        this.frame.addWindowListener(new WindowListener(){

            public void windowOpened(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
                try {
                    EulaWindow.this.m_controller.handleRequest(new RespondToEulaRequest(EulaWindow.this.acceptedEula));
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }
        });
        GridBagLayout layout = new GridBagLayout();
        this.frame.setLayout(layout);
        JOutputPane outputWindow = ComponentFactory.createTextPane();
        outputWindow.setMinimumSize(new Dimension(400, 400));
        outputWindow.setPreferredSize(new Dimension(400, 400));
        outputWindow.setText(this.m_model.getEULAText());
        JPanel outputPanel = new JPanel();
        JScrollPane scrollPane = new JScrollPane(outputWindow);
        scrollPane.setMinimumSize(new Dimension(400, 400));
        scrollPane.setPreferredSize(new Dimension(400, 400));
        outputPanel.add(scrollPane);
        layout.setConstraints(outputPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.frame.add(outputPanel);
        JPanel buttonPanel = new JPanel();
        JButton declineButton = ComponentFactory.createButton(this.mainResources.getString("declineButton.text"), new Runnable(){

            public void run() {
                EulaWindow.this.acceptedEula = false;
                EulaWindow.this.frame.dispose();
            }
        });
        JButton acceptButton = ComponentFactory.createButton(this.mainResources.getString("acceptButton.text"), new Runnable(){

            public void run() {
                EulaWindow.this.acceptedEula = true;
                EulaWindow.this.frame.dispose();
            }
        });
        buttonPanel.add(declineButton);
        buttonPanel.add(acceptButton);
        layout.setConstraints(buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.frame.add(buttonPanel);
        ComponentFactory.packFrame(this.frame);
    }

    public void Open() {
        this.frame.setVisible(true);
    }

    public void init() {
    }
}

