/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util;

import com.tripwire.common.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.regex.Pattern;

public class FileUtil {
    public static void copyFile(File source, File destination) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(destination);
            StreamUtil.copy(in, (OutputStream)out);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                StreamUtil.close(in, true);
                StreamUtil.close(out, true);
                throw throwable;
            }
        }
        StreamUtil.close(in, true);
        StreamUtil.close(out, true);
    }

    public static void copyFile(String source, String destination) throws IOException {
        File fin = new File(source);
        File fout = new File(destination);
        FileUtil.copyFile(fin, fout);
    }

    public static Reader getUnicodeReader(File file, boolean forceutf8) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        return FileUtil.getUnicodeReader(in, forceutf8);
    }

    public static Reader getUnicodeReader(InputStream in, boolean forceutf8) throws IOException {
        in.mark(4);
        int bombyte = in.read();
        if (bombyte == 239) {
            bombyte = in.read();
            if (bombyte == 187) {
                bombyte = in.read();
                if (bombyte == 191) {
                    forceutf8 = true;
                } else {
                    in.reset();
                }
            } else {
                in.reset();
            }
        } else {
            in.reset();
        }
        InputStreamReader reader = forceutf8 ? new InputStreamReader(in, "UTF-8") : new InputStreamReader(in);
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isXML(File importFile) throws IOException {
        boolean bl;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(FileUtil.getUnicodeReader(importFile, true));
            Pattern whiteSpacePattern = Pattern.compile("^\\s*");
            Pattern xmlStartPattern = Pattern.compile("^\\s*<.*");
            while ((line = reader.readLine()) != null) {
                if (whiteSpacePattern.matcher(line).matches()) continue;
                bl = xmlStartPattern.matcher(line).matches();
            }
        }
        catch (Throwable throwable) {
            StreamUtil.close(reader, true);
            throw throwable;
        }
        {
            StreamUtil.close(reader, true);
            return bl;
        }
        StreamUtil.close(reader, true);
        return false;
    }

    public static String getLeafName(String filepath) {
        if (filepath.endsWith("//") || filepath.endsWith("\\")) {
            filepath = filepath.substring(0, filepath.length() - 1);
        }
        for (int i = filepath.length() - 1; i >= 0; --i) {
            char c = filepath.charAt(i);
            if (c != '/' && c != '\\') continue;
            return filepath.substring(i + 1, filepath.length());
        }
        return filepath;
    }

    public static void deleteDescendents(File file) throws IOException {
        FileUtil.deleteRecursively(file, false, null, true);
    }

    public static boolean deleteDescendents(File file, FileFilter filter, boolean throwOnError) throws IOException {
        return FileUtil.deleteRecursively(file, false, filter, throwOnError);
    }

    public static void deleteRecursively(File file) throws IOException {
        FileUtil.deleteRecursively(file, true);
    }

    public static boolean deleteRecursively(File file, boolean throwOnError) throws IOException {
        return FileUtil.deleteRecursively(file, true, null, throwOnError);
    }

    private static boolean deleteRecursively(File file, boolean deleteObject, FileFilter filter, boolean throwOnError) throws IOException {
        boolean success = true;
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int count = children == null ? 0 : children.length;
            for (int i = 0; i < count; ++i) {
                File child = children[i];
                if (child.isDirectory()) {
                    if (FileUtil.deleteRecursively(child, true, filter, throwOnError)) continue;
                    success = false;
                    continue;
                }
                if (!FileUtil.passes(child, filter) || FileUtil.delete(child, throwOnError)) continue;
                success = false;
            }
        }
        if (deleteObject && FileUtil.passes(file, filter) && !FileUtil.delete(file, throwOnError)) {
            success = false;
        }
        return success;
    }

    private static boolean passes(File file, FileFilter filter) {
        if (filter == null) {
            return true;
        }
        return filter.accept(file);
    }

    public static void delete(File file) throws IOException {
        FileUtil.delete(file, true);
    }

    public static boolean delete(File file, boolean throwOnError) throws IOException {
        if (!file.exists()) {
            return true;
        }
        if (!file.delete()) {
            String message = "Could not delete: " + file.getAbsolutePath();
            if (throwOnError) {
                throw new IOException(message);
            }
            System.out.println(message);
            return false;
        }
        return true;
    }

    public static void createDirectory(File file) throws IOException {
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IOException("Cannot create directory " + file.getAbsolutePath() + ": file already exists and is not a directory");
            }
        } else if (!file.mkdirs()) {
            throw new IOException("Unable to create directory " + file.getAbsolutePath());
        }
    }

    public static String getTemporaryDirName() {
        return System.getProperty("java.io.tmpdir");
    }
}

