/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor.soap;

import com.tripwire.checker.accessor.soap.AbstractVmwareCollector;
import com.vmware.vim25.HostService;

public class HostServiceCollector
extends AbstractVmwareCollector {
    public HostServiceCollector() {
        super(HostService.class);
    }

    public void collect(Object o, String parentKey) {
        String curKey = parentKey + ".HostService";
        if (o instanceof HostService) {
            HostService hostService = (HostService)o;
            String key = hostService.getKey();
            if (null != key) {
                curKey = curKey + "." + key;
            }
            String label = hostService.getLabel();
            this.doPut(curKey + ".Label", "" + label);
            String policy = hostService.getPolicy();
            this.doPut(curKey + ".Policy", "" + policy);
            String[] rulesets = hostService.getRuleset();
            if (null != rulesets) {
                for (int ii = 0; ii < rulesets.length; ++ii) {
                    if (null == rulesets[ii]) continue;
                    this.doPut(curKey + ".Ruleset" + ii, rulesets[ii]);
                }
            }
            boolean required = hostService.isRequired();
            this.doPut(curKey + ".Required", "" + required);
            boolean running = hostService.isRunning();
            this.doPut(curKey + ".Running", "" + running);
            boolean uninstallable = hostService.isUninstallable();
            this.doPut(curKey + ".Uninstallable", "" + uninstallable);
        }
    }
}

