/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh2;

import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2TCPChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SSH2SocksChannel
implements Runnable {
    private Thread myThread;
    private Socket s;
    private SSH2Connection connection;
    private String localAddr;
    private int localPort;
    private String originAddr;
    private int originPort;
    private boolean terminated = false;
    private InputStream is = null;
    private OutputStream os = null;

    public SSH2SocksChannel(Socket socket, SSH2Connection sSH2Connection) {
        this.s = socket;
        this.connection = sSH2Connection;
        this.localAddr = socket.getLocalAddress().getHostAddress();
        this.localPort = socket.getLocalPort();
        this.originAddr = socket.getInetAddress().getHostAddress();
        this.originPort = socket.getPort();
        this.myThread = new Thread((Runnable)this, "SSH2SocksChannel_" + this.localAddr + ":" + this.localPort);
        this.myThread.setDaemon(true);
        this.myThread.start();
    }

    public void terminate() {
        this.terminated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.connection.getLog().debug("SSH2SocksChannel", "starting");
        try {
            int n;
            int n2;
            byte[] byArray = new byte[256];
            String string = null;
            this.is = this.s.getInputStream();
            this.os = this.s.getOutputStream();
            this.doRead(this.is, byArray, 2);
            if (byArray[0] != 5) {
                this.Debug("Unsupported SOCKS protocol version: " + byArray[0]);
                this.s.close();
                return;
            }
            int n3 = byArray[1];
            if (n3 != 0) {
                this.doRead(this.is, byArray, n3);
            }
            boolean bl = false;
            for (n2 = 0; n2 < n3; ++n2) {
                if (byArray[n2] != 0) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.Debug("SOCKS client do not support 'no authentication' method");
                this.s.close();
                return;
            }
            byArray[0] = 5;
            byArray[1] = 0;
            this.os.write(byArray, 0, 2);
            this.doRead(this.is, byArray, 4);
            if (byArray[0] != 5) {
                this.Debug("Unsupported SOCKS protocol version: " + byArray[0]);
                this.s.close();
                return;
            }
            byte by = byArray[1];
            switch (byArray[3]) {
                case 1: {
                    this.doRead(this.is, byArray, 6);
                    n = this.toUInt(byArray[4], byArray[5]);
                    string = (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
                    break;
                }
                case 3: {
                    this.doRead(this.is, byArray, 1);
                    n3 = byArray[0];
                    this.doRead(this.is, byArray, n3 + 2);
                    n = this.toUInt(byArray[n3], byArray[n3 + 1]);
                    string = "";
                    for (n2 = 0; n2 < n3; ++n2) {
                        string = string + (char)byArray[n2];
                    }
                    break;
                }
                default: {
                    this.Debug("Unsupported SOCKS address type: " + byArray[3]);
                    this.s.close();
                    return;
                }
            }
            switch (by) {
                case 1: {
                    byArray[0] = 5;
                    byArray[1] = 0;
                    byArray[2] = 0;
                    byArray[3] = 1;
                    byArray[4] = 127;
                    byArray[5] = 0;
                    byArray[6] = 0;
                    byArray[7] = 1;
                    byArray[8] = -1;
                    byArray[9] = -1;
                    this.os.write(byArray, 0, 10);
                    SSH2TCPChannel sSH2TCPChannel = new SSH2TCPChannel(1, this.connection, this, this.s, string, n, this.originAddr, this.originPort);
                    this.connection.getLog().notice("SSH2SocksChannel", "connect from: " + this.originAddr + ":" + this.originPort + " on " + this.localAddr + ":" + this.localPort + " --> " + string + ":" + n + ", new ch. #" + sSH2TCPChannel.getChannelId());
                    this.connection.setSocketOptions("local." + this.localAddr + "." + this.localPort, this.s);
                    this.connection.getEventHandler().channelConnect(this, sSH2TCPChannel, this.s);
                    this.connection.connectLocalChannel(sSH2TCPChannel, string, n, this.originAddr, this.originPort);
                    break;
                }
                default: {
                    this.Debug("Unsupported SOCKS command: " + by);
                    this.s.close();
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                this.s.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                this.is.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            try {
                this.os.close();
            }
            catch (Exception exception4) {}
        }
        this.connection.getLog().debug("SSH2SocksChannel", "stopping");
    }

    private int toUInt(byte by, byte by2) {
        return (by & 0xFF) << 8 | by2 & 0xFF;
    }

    private void doRead(InputStream inputStream, byte[] byArray, int n) throws IOException {
        int n2;
        for (int i = 0; i < n; i += n2) {
            n2 = inputStream.read(byArray, i, n - i);
            if (n2 >= 0) continue;
            throw new IOException();
        }
    }

    private void Debug(String string) {
        this.connection.getLog().debug("SSH2SocksChannel", "Debug:: " + string);
    }
}

