/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.jcraft.jzlib.ZStream;
import com.mindbright.ssh.SSHCompressionException;
import com.mindbright.ssh.SSHCompressor;
import com.mindbright.ssh.SSHPduInputStream;
import com.mindbright.ssh.SSHPduOutputStream;

public final class SSHCompressorZLib
extends SSHCompressor {
    private static final int DEFLATE_BUF_SIZE = 49152;
    private static final int INFLATE_BUF_SIZE = 65536;
    private ZStream dStream;
    private ZStream iStream;
    private byte[] dBuf;
    private byte[] iBuf;

    public void init(int n, int n2) {
        switch (n) {
            case 1: {
                this.dStream = new ZStream();
                this.dStream.deflateInit(n2);
                this.dBuf = new byte[49152];
                this.dStream.next_out = this.dBuf;
                break;
            }
            case 2: {
                this.iStream = new ZStream();
                this.iStream.inflateInit();
                this.iBuf = new byte[65536];
                this.iStream.next_out = this.iBuf;
                break;
            }
            default: {
                throw new Error("Unknown mode sent to SSHCompressorZLib");
            }
        }
    }

    public void compress(SSHPduOutputStream sSHPduOutputStream) throws SSHCompressionException {
        SSHPduOutputStream.PduByteArrayOutputStream pduByteArrayOutputStream = sSHPduOutputStream.getOut();
        this.dStream.next_in = pduByteArrayOutputStream.getBuf();
        this.dStream.next_in_index = 8;
        this.dStream.avail_in = pduByteArrayOutputStream.size() - 8;
        this.dStream.next_out_index = 0;
        this.dStream.avail_out = 49152;
        int n = this.dStream.deflate(1);
        if (n != 0) {
            throw new SSHCompressionException("Error in zlib deflate: " + n);
        }
        int n2 = 49152 - this.dStream.avail_out;
        if (this.dStream.next_in.length - 128 < n2) {
            pduByteArrayOutputStream.setBuf(new byte[n2 + (this.dStream.next_in.length >>> 1)]);
        }
        System.arraycopy(this.dBuf, 0, pduByteArrayOutputStream.getBuf(), 8, n2);
        pduByteArrayOutputStream.setCount(8 + n2);
    }

    public void uncompress(SSHPduInputStream sSHPduInputStream) throws SSHCompressionException {
        SSHPduInputStream.PduByteArrayInputStream pduByteArrayInputStream = sSHPduInputStream.getIn();
        this.iStream.next_in = pduByteArrayInputStream.getBuf();
        this.iStream.next_in_index = pduByteArrayInputStream.getPos();
        this.iStream.avail_in = sSHPduInputStream.length - 4;
        this.iStream.next_out_index = 0;
        this.iStream.avail_out = 65536;
        int n = this.iStream.inflate(1);
        if (n != 0) {
            throw new SSHCompressionException("Error in zlib inflate: " + n);
        }
        int n2 = 65536 - this.iStream.avail_out;
        if (this.iStream.next_in.length < n2) {
            sSHPduInputStream.bytes = new byte[n2];
            pduByteArrayInputStream.setBuf(sSHPduInputStream.bytes);
        }
        System.arraycopy(this.iBuf, 0, pduByteArrayInputStream.getBuf(), 0, n2);
        pduByteArrayInputStream.setPos(0);
        sSHPduInputStream.length = n2;
    }

    public long numOfCompressedBytes() {
        if (this.iStream != null) {
            return this.iStream.total_in;
        }
        return this.dStream.total_out;
    }

    public long numOfUncompressedBytes() {
        if (this.iStream != null) {
            return this.iStream.total_out;
        }
        return this.dStream.total_in;
    }
}

