/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.net.telnet;

import com.mindbright.net.telnet.TelnetEventHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TelnetNVT
implements Runnable {
    private static final int STATE_DATA = 0;
    private static final int STATE_IAC = 1;
    private static final int STATE_OPTNEG = 2;
    private static final int STATE_OPTTYP = 3;
    private static final int STATE_SUBNEG = 4;
    private static final int STATE_SUBEND = 5;
    private static final int STATE_CR = 6;
    private static final int STATE_SKIP = 7;
    private static final int STATE_ILLEGAL = 8;
    public static final int CODE_LF = 10;
    public static final int CODE_CR = 13;
    public static final int CODE_EOR = 239;
    public static final int CODE_SE = 240;
    public static final int CODE_NOP = 241;
    public static final int CODE_DM = 242;
    public static final int CODE_BREAK = 243;
    public static final int CODE_IP = 244;
    public static final int CODE_ABORT = 245;
    public static final int CODE_AYT = 246;
    public static final int CODE_EC = 247;
    public static final int CODE_EL = 248;
    public static final int CODE_GA = 249;
    public static final int CODE_SB = 250;
    public static final int CODE_WILL = 251;
    public static final int CODE_WONT = 252;
    public static final int CODE_DO = 253;
    public static final int CODE_DONT = 254;
    public static final int CODE_IAC = 255;
    public static final int OPT_ECHO = 1;
    public static final int OPT_SGA = 3;
    public static final int OPT_STATUS = 5;
    public static final int OPT_TTYPE = 24;
    public static final int OPT_EOR = 25;
    public static final int OPT_NAWS = 31;
    public static final int OPT_SPEED = 32;
    public static final int OPT_REMFCTL = 33;
    public static final int OPT_XDISP = 35;
    public static final int OPT_NEWENV = 39;
    public static final int SB_CMD_IS = 0;
    public static final int SB_CMD_SEND = 1;
    public static final int SB_CMD_REPLY = 2;
    public static final int SB_CMD_NAME = 3;
    private TelnetEventHandler eventHandler;
    private InputStream in;
    private OutputStream out;
    private Thread myThread;
    private int reqCode;
    private boolean sentCR;
    private StringBuffer sendBuffer;

    public TelnetNVT(TelnetEventHandler telnetEventHandler, InputStream inputStream, OutputStream outputStream) {
        this.eventHandler = telnetEventHandler;
        this.in = inputStream;
        this.out = outputStream;
        this.myThread = new Thread((Runnable)this, "TelnetNVT");
        this.sentCR = false;
        this.sendBuffer = new StringBuffer();
    }

    public void start() {
        this.myThread.start();
    }

    public void run() {
        int n = 0;
        byte[] byArray = new byte[256];
        int n2 = 0;
        try {
            int n3;
            while ((n3 = this.in.read()) != -1) {
                switch (n) {
                    case 0: {
                        if (n3 == 13) {
                            n = 6;
                            break;
                        }
                        if (n3 != 255) break;
                        n = 1;
                        break;
                    }
                    case 1: {
                        n = this.interpretAsCommand(n3);
                        break;
                    }
                    case 2: {
                        this.optionNegotiation(n3, this.reqCode);
                        n = 7;
                        break;
                    }
                    case 5: {
                        if (n3 == 240) {
                            byte[] byArray2 = new byte[n2 - 1];
                            System.arraycopy(byArray, 1, byArray2, 0, n2 - 1);
                            n2 = 0;
                            this.eventHandler.optionSubNegotiation(byArray[0] & 0xFF, byArray2);
                            n = 7;
                            break;
                        }
                    }
                    case 4: {
                        if (n3 == 255 && n == 4) {
                            n = 5;
                            break;
                        }
                        if (n2 == 256) {
                            n = 8;
                            break;
                        }
                        byArray[n2++] = (byte)n3;
                        break;
                    }
                    case 6: {
                        n = n3 == 0 ? 7 : 0;
                    }
                }
                if (n == 0 || n == 6) {
                    this.eventHandler.receiveData((byte)n3);
                    continue;
                }
                if (n == 7) {
                    n = 0;
                    continue;
                }
                if (n != 8) continue;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Thread getThread() {
        return this.myThread;
    }

    public synchronized void sendData(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        int n4 = -1;
        while (n < n3) {
            n4 = byArray[n++];
            if (this.sentCR) {
                if (n4 != 10) {
                    this.sendBuffer.append('\u0000');
                }
                this.sentCR = false;
            }
            if (n4 == 255) {
                this.sendBuffer.append((char)n4);
            } else if (n4 == 13) {
                this.sentCR = true;
            }
            this.sendBuffer.append((char)n4);
        }
        this.out.write(this.sendBuffer.toString().getBytes());
        this.sendBuffer.setLength(0);
    }

    public synchronized void sendData(int n) throws IOException {
        if (this.sentCR) {
            if (n != 10) {
                this.out.write(0);
            }
            this.sentCR = false;
        }
        if (n == 255) {
            this.out.write(n);
        } else if (n == 13) {
            this.sentCR = true;
        }
        this.out.write(n);
    }

    private void sendBuffer() throws IOException {
    }

    public synchronized void sendCR() throws IOException {
        this.out.write(new byte[]{13, 0}, 0, 2);
    }

    public synchronized void sendBreak() throws IOException {
        String string = String.valueOf('\u00ff') + '\u00f3';
        this.out.write(string.getBytes());
    }

    public synchronized void doOption(int n) throws IOException {
        this.out.write(255);
        this.out.write(253);
        this.out.write(n);
    }

    public synchronized void dontOption(int n) throws IOException {
        this.out.write(255);
        this.out.write(254);
        this.out.write(n);
    }

    public synchronized void willOption(int n) throws IOException {
        this.out.write(255);
        this.out.write(251);
        this.out.write(n);
    }

    public synchronized void wontOption(int n) throws IOException {
        this.out.write(255);
        this.out.write(252);
        this.out.write(n);
    }

    public synchronized void sendOptionSubNegotiation(int n, byte[] byArray) throws IOException {
        this.out.write(255);
        this.out.write(250);
        this.out.write(n);
        this.sendData(byArray, 0, byArray.length);
        this.out.write(255);
        this.out.write(240);
    }

    protected void optionNegotiation(int n, int n2) throws IOException {
        if (!this.eventHandler.optionNegotiation(n, n2)) {
            int n3 = -1;
            switch (n2) {
                case 251: {
                    n3 = 254;
                    break;
                }
                case 253: {
                    n3 = 252;
                    break;
                }
            }
            if (n3 > 0) {
                this.out.write(255);
                this.out.write(n3);
                this.out.write(n);
            }
        }
    }

    protected int interpretAsCommand(int n) {
        int n2 = 7;
        switch (n) {
            case 250: {
                n2 = 4;
                break;
            }
            case 251: 
            case 252: 
            case 253: 
            case 254: {
                this.reqCode = n;
                n2 = 2;
                break;
            }
            case 255: {
                n2 = 0;
                break;
            }
            case 239: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: {
                this.eventHandler.interpretAsCommand(n);
                break;
            }
            default: {
                n2 = 8;
            }
        }
        return n2;
    }
}

