/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.asn1;

import com.mindbright.asn1.ASN1OID;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ASN1OIDRegistry
extends Properties {
    private static ASN1OIDRegistry registry = new ASN1OIDRegistry();
    private static Hashtable modules = new Hashtable();

    public void putName(String string, String string2, String string3) {
        this.putName(string, string2);
        this.putShortName(string, string3);
    }

    public void putShortName(String string, String string2) {
        ((Hashtable)this).put("shortname." + string, string2);
        ((Hashtable)this).put("shortname." + string2, string);
    }

    public void putName(String string, String string2) {
        ((Hashtable)this).put("name." + string, string2);
        ((Hashtable)this).put("name." + string2, string);
    }

    public static synchronized Class lookupType(ASN1OID aSN1OID) {
        String string = aSN1OID.getString();
        String string2 = registry.getProperty(string);
        Class<?> clazz = null;
        if (string2 != null) {
            if (string2.indexOf(46) == -1) {
                string2 = "com.mindbright.asn1." + string2;
            }
            try {
                clazz = Class.forName(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Error("Can't find class '" + string2 + "' registered in ASN1OIDRegistry with '" + string + "'");
            }
        }
        return clazz;
    }

    public static synchronized String lookupName(String string) {
        string = "name." + string;
        return registry.getProperty(string);
    }

    public static synchronized String lookupShortName(String string) {
        string = "shortname." + string;
        return registry.getProperty(string);
    }

    public static void register(ASN1OID aSN1OID, String string) {
        ASN1OIDRegistry.register(aSN1OID.getString(), string);
    }

    public static synchronized void register(String string, String string2) {
        ((Hashtable)registry).put(string, string2);
    }

    public static void addModule(String string) {
        try {
            ASN1OIDRegistry aSN1OIDRegistry = (ASN1OIDRegistry)Class.forName(string + ".RegisteredTypes").newInstance();
            ASN1OIDRegistry.addModule(string, aSN1OIDRegistry);
        }
        catch (Exception exception) {
            throw new Error("In ASN1OIDRegistry: " + exception.getMessage());
        }
    }

    public static void addModule(String string, Properties properties) {
        if (modules.get(string) != null) {
            return;
        }
        modules.put(string, properties);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            ASN1OIDRegistry.register(string2, properties.getProperty(string2));
        }
    }
}

