/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.benchmark;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TLinkableAdaptor;
import gnu.trove.TLinkedList;
import gnu.trove.TObjectProcedure;
import gnu.trove.benchmark.Operation;
import gnu.trove.benchmark.Repeater;
import gnu.trove.benchmark.TextReporter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class Main {
    static final int SET_SIZE = 100000;
    static final List dataset = new ArrayList(100000);

    public static Operation getSetOperation() {
        return new Operation(){

            public void theirs() {
                HashSet hashSet = new HashSet(100000);
                Iterator iterator = dataset.iterator();
                while (iterator.hasNext()) {
                    hashSet.add(iterator.next());
                }
            }

            public void ours() {
                THashSet tHashSet = new THashSet(100000);
                Iterator iterator = dataset.iterator();
                while (iterator.hasNext()) {
                    tHashSet.add(iterator.next());
                }
            }

            public String toString() {
                return "compares " + dataset.size() + " Set.add() operations";
            }

            public int getIterationCount() {
                return 10;
            }
        };
    }

    public static Operation getLinkedListAddOp() {
        final ArrayList<TLinkableAdaptor> arrayList = new ArrayList<TLinkableAdaptor>(100000);
        for (int i = 0; i < 100000; ++i) {
            arrayList.add(new TLinkableAdaptor());
        }
        return new Operation(){

            public void theirs() {
                LinkedList linkedList = new LinkedList();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    linkedList.add(iterator.next());
                }
            }

            public void ours() {
                TLinkedList tLinkedList = new TLinkedList();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    tLinkedList.add(iterator.next());
                }
            }

            public String toString() {
                return "compares " + dataset.size() + " LinkedList.add() operations";
            }

            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getContainsOp() {
        final HashSet hashSet = new HashSet(dataset.size());
        hashSet.addAll(dataset);
        final THashSet tHashSet = new THashSet(dataset.size());
        tHashSet.addAll(dataset);
        return new Operation(){

            public void theirs() {
                for (int i = 0; i < dataset.size(); i += 5) {
                    hashSet.contains(dataset.get(i));
                }
            }

            public void ours() {
                for (int i = 0; i < dataset.size(); i += 5) {
                    tHashSet.contains(dataset.get(i));
                }
            }

            public String toString() {
                return "compares " + dataset.size() / 5 + " Set.contains() operations";
            }

            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getRandomSetContainsOp() {
        int n;
        Serializable serializable;
        HashSet<Integer> hashSet = new HashSet<Integer>(100000);
        THashSet tHashSet = new THashSet(100000);
        Random random = new Random(9999L);
        for (int i = 0; i < 100000; ++i) {
            serializable = new Integer(random.nextInt());
            hashSet.add((Integer)serializable);
            tHashSet.add(serializable);
        }
        Random random2 = new Random(9998L);
        serializable = new ArrayList(100000);
        int n2 = 0;
        for (n = 0; n < 100000; ++n) {
            Integer n3 = new Integer(random.nextInt());
            serializable.add(n3);
            if (!hashSet.contains(n3)) continue;
            ++n2;
        }
        n = n2;
        return new Operation((List)((Object)serializable), hashSet, tHashSet, n){
            private final /* synthetic */ List val$query;
            private final /* synthetic */ Set val$theirs;
            private final /* synthetic */ Set val$ours;
            private final /* synthetic */ int val$success;
            {
                this.val$query = list;
                this.val$theirs = set;
                this.val$ours = set2;
                this.val$success = n;
            }

            public void theirs() {
                Iterator iterator = this.val$query.iterator();
                while (iterator.hasNext()) {
                    this.val$theirs.contains(iterator.next());
                }
            }

            public void ours() {
                Iterator iterator = this.val$query.iterator();
                while (iterator.hasNext()) {
                    this.val$ours.contains(iterator.next());
                }
            }

            public String toString() {
                return "compares 100000 Set.contains() operations. " + this.val$success + " are actually present in set";
            }

            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getMapPutOp() {
        return new Operation(){

            public void theirs() {
                HashMap hashMap = new HashMap(dataset.size());
                Iterator iterator = dataset.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    hashMap.put(e, e);
                }
            }

            public void ours() {
                THashMap tHashMap = new THashMap(dataset.size());
                Iterator iterator = dataset.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    tHashMap.put(e, e);
                }
            }

            public String toString() {
                return "compares " + dataset.size() + " Map.put() operations";
            }

            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getIterationOp() {
        final HashMap hashMap = new HashMap(dataset.size());
        final THashMap tHashMap = new THashMap(dataset.size());
        Iterator iterator = dataset.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            hashMap.put(e, e);
            tHashMap.put(e, e);
        }
        return new Operation(){

            public void theirs() {
                Map map = hashMap;
                Iterator iterator = map.keySet().iterator();
                int n = map.size();
                while (n-- > 0) {
                    Object k = iterator.next();
                }
            }

            public void ours() {
                Map map = tHashMap;
                Iterator iterator = map.keySet().iterator();
                int n = map.size();
                while (n-- > 0) {
                    Object k = iterator.next();
                }
            }

            public String toString() {
                return "compares Iterator.next() over " + dataset.size() + " map keys";
            }

            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getIterationWithHasNextOp() {
        final HashMap hashMap = new HashMap(dataset.size());
        final THashMap tHashMap = new THashMap(dataset.size());
        Iterator iterator = dataset.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            hashMap.put(e, e);
            tHashMap.put(e, e);
        }
        return new Operation(){

            public void theirs() {
                Map map = hashMap;
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                }
            }

            public void ours() {
                Map map = tHashMap;
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                }
            }

            public String toString() {
                return "compares Iterator.hasNext()/ Iterator.next() over " + hashMap.size() + " keys";
            }

            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getIntMapPut() {
        return new Operation(){

            public void theirs() {
            }

            public void ours() {
                TIntIntHashMap tIntIntHashMap = new TIntIntHashMap(100000);
                int n = dataset.size();
                while (n-- > 0) {
                    tIntIntHashMap.put(n, n);
                }
            }

            public String toString() {
                return dataset.size() + " entry primitive int map.put timing run; no basis for comparison";
            }

            public int getIterationCount() {
                return 10;
            }
        };
    }

    static Operation getSumSetOperation() {
        final HashSet hashSet = new HashSet(dataset.size());
        final THashSet tHashSet = new THashSet(dataset.size());
        hashSet.addAll(dataset);
        tHashSet.addAll((Collection)dataset);
        final TObjectProcedure tObjectProcedure = new TObjectProcedure(){
            int sum = 0;

            public boolean execute(Object object) {
                this.sum += ((Integer)object).intValue();
                return true;
            }
        };
        return new Operation(){

            public void theirs() {
                int n = 0;
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    n += ((Integer)iterator.next()).intValue();
                }
            }

            public void ours() {
                tHashSet.forEach(tObjectProcedure);
            }

            public String toString() {
                return "sums a " + hashSet.size() + " element Set of Integer objects.  Their approach uses Iterator.hasNext()/next(); ours uses THashSet.forEach(TObjectProcedure)";
            }

            public int getIterationCount() {
                return 10;
            }
        };
    }

    public static void main(String[] stringArray) {
        TextReporter textReporter = new TextReporter();
        textReporter.start();
        Operation operation = Main.getRandomSetContainsOp();
        Repeater repeater = new Repeater(operation);
        textReporter.report(repeater.run());
        operation = Main.getSumSetOperation();
        repeater = new Repeater(operation);
        textReporter.report(repeater.run());
        operation = Main.getIterationWithHasNextOp();
        repeater = new Repeater(operation);
        textReporter.report(repeater.run());
        operation = Main.getIterationOp();
        repeater = new Repeater(operation);
        textReporter.report(repeater.run());
        operation = Main.getLinkedListAddOp();
        repeater = new Repeater(operation);
        textReporter.report(repeater.run());
        operation = Main.getIntMapPut();
        repeater = new Repeater(operation);
        textReporter.report(repeater.run());
        operation = Main.getMapPutOp();
        repeater = new Repeater(operation);
        textReporter.report(repeater.run());
        operation = Main.getContainsOp();
        repeater = new Repeater(operation);
        textReporter.report(repeater.run());
        operation = Main.getSetOperation();
        repeater = new Repeater(operation);
        textReporter.report(repeater.run());
        textReporter.finish();
    }

    static {
        for (int i = 0; i < 100000; ++i) {
            dataset.add(new Integer(i));
        }
    }
}

