/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TIntFunction;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntIterator;
import gnu.trove.TObjectIntProcedure;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TObjectIntHashMap
extends TObjectHash
implements Serializable {
    protected transient int[] _values;

    public TObjectIntHashMap() {
    }

    public TObjectIntHashMap(int n) {
        super(n);
    }

    public TObjectIntHashMap(int n, float f) {
        super(n, f);
    }

    public TObjectIntHashMap(TObjectHashingStrategy tObjectHashingStrategy) {
        super(tObjectHashingStrategy);
    }

    public TObjectIntHashMap(int n, TObjectHashingStrategy tObjectHashingStrategy) {
        super(n, tObjectHashingStrategy);
    }

    public TObjectIntHashMap(int n, float f, TObjectHashingStrategy tObjectHashingStrategy) {
        super(n, f, tObjectHashingStrategy);
    }

    public TObjectIntIterator iterator() {
        return new TObjectIntIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new int[n2];
        return n2;
    }

    public int put(Object object, int n) {
        int n2 = 0;
        int n3 = this.insertionIndex(object);
        boolean bl = true;
        if (n3 < 0) {
            n3 = -n3 - 1;
            n2 = this._values[n3];
            bl = false;
        }
        Object object2 = this._set[n3];
        this._set[n3] = object;
        this._values[n3] = n;
        if (bl) {
            this.postInsertHook(object2 == null);
        }
        return n2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        Object[] objectArray = this._set;
        int[] nArray = this._values;
        this._set = new Object[n];
        this._values = new int[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (objectArray[n3] == null || objectArray[n3] == REMOVED) continue;
            Object object = objectArray[n3];
            int n4 = this.insertionIndex(object);
            if (n4 < 0) {
                this.throwObjectContractViolation(this._set[-n4 - 1], object);
            }
            this._set[n4] = object;
            this._values[n4] = nArray[n3];
        }
    }

    public int get(Object object) {
        int n = this.index(object);
        return n < 0 ? 0 : this._values[n];
    }

    public void clear() {
        super.clear();
        Object[] objectArray = this._set;
        int[] nArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            objectArray[n] = null;
            nArray[n] = 0;
        }
    }

    public int remove(Object object) {
        int n = 0;
        int n2 = this.index(object);
        if (n2 >= 0) {
            n = this._values[n2];
            this.removeAt(n2);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TObjectIntHashMap)) {
            return false;
        }
        TObjectIntHashMap tObjectIntHashMap = (TObjectIntHashMap)object;
        if (tObjectIntHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tObjectIntHashMap));
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0;
    }

    public int[] getValues() {
        int[] nArray = new int[this.size()];
        int[] nArray2 = this._values;
        Object[] objectArray = this._set;
        int n = nArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED) continue;
            nArray[n2++] = nArray2[n];
        }
        return nArray;
    }

    public Object[] keys() {
        Object[] objectArray = new Object[this.size()];
        Object[] objectArray2 = this._set;
        int n = objectArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (objectArray2[n] == null || objectArray2[n] == REMOVED) continue;
            objectArray[n2++] = objectArray2[n];
        }
        return objectArray;
    }

    public boolean containsValue(int n) {
        Object[] objectArray = this._set;
        int[] nArray = this._values;
        int n2 = nArray.length;
        while (n2-- > 0) {
            if (objectArray[n2] == null || objectArray[n2] == REMOVED || n != nArray[n2]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object object) {
        return this.contains(object);
    }

    public boolean forEachKey(TObjectProcedure tObjectProcedure) {
        return this.forEach(tObjectProcedure);
    }

    public boolean forEachValue(TIntProcedure tIntProcedure) {
        Object[] objectArray = this._set;
        int[] nArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED || tIntProcedure.execute(nArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectIntProcedure tObjectIntProcedure) {
        Object[] objectArray = this._set;
        int[] nArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED || tObjectIntProcedure.execute(objectArray[n], nArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TObjectIntProcedure tObjectIntProcedure) {
        boolean bl = false;
        Object[] objectArray = this._set;
        int[] nArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED || tObjectIntProcedure.execute(objectArray[n], nArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TIntFunction tIntFunction) {
        Object[] objectArray = this._set;
        int[] nArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED) continue;
            nArray[n] = tIntFunction.execute(nArray[n]);
        }
    }

    public boolean increment(Object object) {
        return this.adjustValue(object, 1);
    }

    public boolean adjustValue(Object object, int n) {
        int n2 = this.index(object);
        if (n2 < 0) {
            return false;
        }
        int n3 = n2;
        this._values[n3] = this._values[n3] + n;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            Object object = objectInputStream.readObject();
            int n2 = objectInputStream.readInt();
            this.put(object, n2);
        }
    }

    private static final class EqProcedure
    implements TObjectIntProcedure {
        private final TObjectIntHashMap _otherMap;

        EqProcedure(TObjectIntHashMap tObjectIntHashMap) {
            this._otherMap = tObjectIntHashMap;
        }

        public final boolean execute(Object object, int n) {
            int n2 = this._otherMap.index(object);
            return n2 >= 0 && this.eq(n, this._otherMap.get(object));
        }

        private final boolean eq(int n, int n2) {
            return n == n2;
        }
    }
}

