/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TLinkable;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class TLinkedList
extends AbstractSequentialList
implements Serializable {
    protected TLinkable _head;
    protected TLinkable _tail;
    protected int _size = 0;

    public ListIterator listIterator(int n) {
        return new IteratorImpl(n);
    }

    public int size() {
        return this._size;
    }

    public void add(int n, Object object) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("index:" + n);
        }
        this.insert(n, object);
    }

    public boolean add(Object object) {
        this.insert(this._size, object);
        return true;
    }

    public void addFirst(Object object) {
        this.insert(0, object);
    }

    public void addLast(Object object) {
        this.insert(this.size(), object);
    }

    public void clear() {
        if (null != this._head) {
            for (TLinkable tLinkable = this._head.getNext(); tLinkable != null; tLinkable = tLinkable.getNext()) {
                TLinkable tLinkable2 = tLinkable.getPrevious();
                tLinkable2.setNext(null);
                tLinkable.setPrevious(null);
            }
            this._tail = null;
            this._head = null;
        }
        this._size = 0;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this._size];
        int n = 0;
        for (TLinkable tLinkable = this._head; tLinkable != null; tLinkable = tLinkable.getNext()) {
            objectArray[n++] = tLinkable;
        }
        return objectArray;
    }

    public Object[] toUnlinkedArray() {
        Object[] objectArray = new Object[this._size];
        int n = 0;
        TLinkable tLinkable = this._head;
        TLinkable tLinkable2 = null;
        while (tLinkable != null) {
            objectArray[n] = tLinkable;
            tLinkable2 = tLinkable;
            tLinkable = tLinkable.getNext();
            tLinkable2.setNext(null);
            tLinkable2.setPrevious(null);
            ++n;
        }
        this._size = 0;
        this._tail = null;
        this._head = null;
        return objectArray;
    }

    public boolean contains(Object object) {
        for (TLinkable tLinkable = this._head; tLinkable != null; tLinkable = tLinkable.getNext()) {
            if (!object.equals(tLinkable)) continue;
            return true;
        }
        return false;
    }

    public Object getFirst() {
        return this._head;
    }

    public Object getLast() {
        return this._tail;
    }

    public Object removeFirst() {
        TLinkable tLinkable = this._head;
        TLinkable tLinkable2 = tLinkable.getNext();
        tLinkable.setNext(null);
        if (null != tLinkable2) {
            tLinkable2.setPrevious(null);
        }
        this._head = tLinkable2;
        if (--this._size == 0) {
            this._tail = null;
        }
        return tLinkable;
    }

    public Object removeLast() {
        TLinkable tLinkable = this._tail;
        TLinkable tLinkable2 = tLinkable.getPrevious();
        tLinkable.setPrevious(null);
        if (null != tLinkable2) {
            tLinkable2.setNext(null);
        }
        this._tail = tLinkable2;
        if (--this._size == 0) {
            this._head = null;
        }
        return tLinkable;
    }

    protected void insert(int n, Object object) {
        TLinkable tLinkable = (TLinkable)object;
        if (this._size == 0) {
            this._head = this._tail = tLinkable;
        } else if (n == 0) {
            tLinkable.setNext(this._head);
            this._head.setPrevious(tLinkable);
            this._head = tLinkable;
        } else if (n == this._size) {
            this._tail.setNext(tLinkable);
            tLinkable.setPrevious(this._tail);
            this._tail = tLinkable;
        } else {
            TLinkable tLinkable2 = null;
            TLinkable tLinkable3 = null;
            if (n > this._size >> 1) {
                tLinkable2 = this._tail;
                for (int i = this._size - 1; i > n; --i) {
                    tLinkable2 = tLinkable2.getPrevious();
                }
            } else {
                tLinkable2 = this._head;
                for (int i = 0; i < n; ++i) {
                    tLinkable2 = tLinkable2.getNext();
                }
            }
            tLinkable3 = tLinkable2.getNext();
            tLinkable.setNext(tLinkable3);
            tLinkable.setPrevious(tLinkable2);
            tLinkable3.setPrevious(tLinkable);
            tLinkable2.setNext(tLinkable);
        }
        ++this._size;
    }

    public boolean remove(Object object) {
        if (object instanceof TLinkable) {
            TLinkable tLinkable = (TLinkable)object;
            TLinkable tLinkable2 = tLinkable.getPrevious();
            TLinkable tLinkable3 = tLinkable.getNext();
            if (tLinkable3 == null && tLinkable2 == null) {
                this._tail = null;
                this._head = null;
            } else if (tLinkable3 == null) {
                tLinkable.setPrevious(null);
                tLinkable2.setNext(null);
                this._tail = tLinkable2;
            } else if (tLinkable2 == null) {
                tLinkable.setNext(null);
                tLinkable3.setPrevious(null);
                this._head = tLinkable3;
            } else {
                tLinkable2.setNext(tLinkable3);
                tLinkable3.setPrevious(tLinkable2);
                tLinkable.setNext(null);
                tLinkable.setPrevious(null);
            }
            --this._size;
            return true;
        }
        return false;
    }

    public void addBefore(TLinkable tLinkable, TLinkable tLinkable2) {
        if (tLinkable == this._head) {
            this.addFirst(tLinkable2);
        } else if (tLinkable == null) {
            this.addLast(tLinkable2);
        } else {
            TLinkable tLinkable3 = tLinkable.getPrevious();
            tLinkable2.setNext(tLinkable);
            tLinkable3.setNext(tLinkable2);
            tLinkable2.setPrevious(tLinkable3);
            tLinkable.setPrevious(tLinkable2);
            ++this._size;
        }
    }

    protected final class IteratorImpl
    implements ListIterator {
        private int _nextIndex = 0;
        private TLinkable _next;
        private TLinkable _lastReturned;

        IteratorImpl(int n) {
            if (n < 0 || n > TLinkedList.this._size) {
                throw new IndexOutOfBoundsException();
            }
            this._nextIndex = n;
            if (n == 0) {
                this._next = TLinkedList.this._head;
            } else if (n == TLinkedList.this._size) {
                this._next = null;
            } else if (n < TLinkedList.this._size >> 1) {
                this._next = TLinkedList.this._head;
                for (int i = 0; i < n; ++i) {
                    this._next = this._next.getNext();
                }
            } else {
                this._next = TLinkedList.this._tail;
                for (int i = TLinkedList.this._size - 1; i > n; --i) {
                    this._next = this._next.getPrevious();
                }
            }
        }

        public final void add(Object object) {
            this._lastReturned = null;
            ++this._nextIndex;
            if (TLinkedList.this._size == 0) {
                TLinkedList.this.add(object);
            } else {
                TLinkedList.this.addBefore(this._next, (TLinkable)object);
            }
        }

        public final boolean hasNext() {
            return this._nextIndex != TLinkedList.this._size;
        }

        public final boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        public final Object next() {
            if (this._nextIndex == TLinkedList.this._size) {
                throw new NoSuchElementException();
            }
            this._lastReturned = this._next;
            this._next = this._next.getNext();
            ++this._nextIndex;
            return this._lastReturned;
        }

        public final int nextIndex() {
            return this._nextIndex;
        }

        public final Object previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            this._lastReturned = this._nextIndex == TLinkedList.this._size ? (this._next = TLinkedList.this._tail) : (this._next = this._next.getPrevious());
            --this._nextIndex;
            return this._lastReturned;
        }

        public final int previousIndex() {
            return this._nextIndex - 1;
        }

        public final void remove() {
            if (this._lastReturned == null) {
                throw new IllegalStateException("must invoke next or previous before invoking remove");
            }
            if (this._lastReturned != this._next) {
                --this._nextIndex;
            }
            this._next = this._lastReturned.getNext();
            TLinkedList.this.remove(this._lastReturned);
            this._lastReturned = null;
        }

        public final void set(Object object) {
            if (this._lastReturned == null) {
                throw new IllegalStateException();
            }
            TLinkable tLinkable = (TLinkable)object;
            if (this._lastReturned == TLinkedList.this._head) {
                TLinkedList.this._head = tLinkable;
            }
            if (this._lastReturned == TLinkedList.this._tail) {
                TLinkedList.this._tail = tLinkable;
            }
            this.swap(this._lastReturned, tLinkable);
            this._lastReturned = tLinkable;
        }

        private void swap(TLinkable tLinkable, TLinkable tLinkable2) {
            TLinkable tLinkable3 = tLinkable.getPrevious();
            TLinkable tLinkable4 = tLinkable.getNext();
            if (null != tLinkable3) {
                tLinkable2.setPrevious(tLinkable3);
                tLinkable3.setNext(tLinkable2);
            }
            if (null != tLinkable4) {
                tLinkable2.setNext(tLinkable4);
                tLinkable4.setPrevious(tLinkable2);
            }
            tLinkable.setNext(null);
            tLinkable.setPrevious(null);
        }
    }
}

