/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional.xml;

import com.tripwire.common.util.ResourceManager;
import com.tripwire.common.util.xml.XmlException;
import com.tripwire.common.util.xml.XmlInputContext;
import com.tripwire.space.core.SpaceException;
import com.tripwire.space.core.conditional.ContentConditions;
import com.tripwire.space.core.conditional.PropertyContentConditions;
import com.tripwire.space.core.conditional.TextContentConditions;
import com.tripwire.space.core.conditional.Types;
import com.tripwire.space.core.conditional.XmlContentConditions;
import com.tripwire.space.core.conditional.xml.ConditionXmlParser;
import com.tripwire.space.core.conditional.xml.ContentConditionalXmlConstants;
import java.io.IOException;
import java.util.regex.Pattern;

public class ContentConditionalXmlElementParser
extends ConditionXmlParser
implements ContentConditionalXmlConstants {
    public ContentConditionalXmlElementParser() {
        super(CONTENT_COND_ELEMENT, TextContentConditions.class);
    }

    protected void readBody(XmlInputContext in, Object obj) throws XmlException, IOException {
        super.readBody(in, obj);
        try {
            ContentConditions conditions;
            ConditionXmlParser.Proxy proxy = (ConditionXmlParser.Proxy)obj;
            int type = Types.getTypeForName(in.parseStringElement(TYPE_ELEMENT));
            if (type == 2) {
                if (!in.detectElementStart(REGEX_ELEMENT)) {
                    throw new XmlException(ResourceManager.getInstance().getSafeString("com.tripwire.space.core.conditional.xml.ContentConditionalXmlElementParser.requiredRegexTag"));
                }
                in.skipElementStart(REGEX_ELEMENT);
                String regex = in.parseStringElement(REGEX_PATTERN_ELEMENT);
                if (null != regex) {
                    regex = regex.replaceAll("\n", "").trim();
                }
                int flags = in.parseIntegerElement(REGEX_FLAGS_ELEMENT);
                in.skipElementEnd(REGEX_ELEMENT);
                conditions = new TextContentConditions(proxy.getConditional(), Pattern.compile(regex, flags));
            } else {
                conditions = type == 1 ? new XmlContentConditions(proxy.getConditional()) : new PropertyContentConditions(proxy.getConditional(), type);
            }
            if (in.detectElementStart(NO_CONTENT_ACTION)) {
                in.skipElementStart(NO_CONTENT_ACTION);
                conditions.setActionIfMissingContent(in.parseIntegerElement(ACTION_IF_NO_CONTENT_ELEMENT));
                in.skipElementEnd(NO_CONTENT_ACTION);
            }
            proxy.setConditions(conditions);
        }
        catch (SpaceException e) {
            throw new XmlException(e.getMessage(), e);
        }
    }
}

