/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.ipdevice;

import com.tripwire.common.util.Dbg;
import com.tripwire.ipdevice.NetworkDeviceException;
import com.tripwire.ipdevice.SSHVersion;
import com.tripwire.space.core.SpaceException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Properties;

public class SSHUtil {
    public static boolean DEBUG_ON = Boolean.getBoolean("com.tripwire.ipdevice.debug");
    static final int NDI_SO_TIMEOUT = Integer.parseInt(System.getProperty("tw.tripwire.ipdevice.ssh.socket.timeout", "300000"));

    public static void interpretError(int failureCode, String failureMessage, Properties props) throws SpaceException {
        if (failureCode != 0) {
            Dbg.trace("SSH Error: " + failureMessage);
        }
        switch (failureCode) {
            case 0: {
                break;
            }
            case 1: {
                int port;
                try {
                    port = Integer.parseInt(props.getProperty("port"));
                }
                catch (NumberFormatException e) {
                    port = 22;
                }
                throw new NetworkDeviceException("ssh.error.connectionRefused", new Object[]{props.getProperty("server"), new Integer(port)});
            }
            case 2: {
                throw new NetworkDeviceException("ssh.error.loginFailed", new Object[]{props.getProperty("server"), props.getProperty("username")});
            }
            case 3: {
                throw new NetworkDeviceException("ssh.error.UnsupportedVersion", new Object[]{props.getProperty("server"), SSHVersion.SSH1.toString()});
            }
            case 4: {
                throw new NetworkDeviceException("ssh.error.UnsupportedCipher", new Object[]{props.getProperty("server"), props.getProperty("ssh1-cipher")});
            }
            case 5: {
                if (failureMessage.indexOf("keyboard-interactive") != -1) {
                    throw new NetworkDeviceException("ssh.error.loginFailed", new Object[]{props.getProperty("server"), props.getProperty("username")});
                }
                throw new NetworkDeviceException("ssh.error.connectionError", new Object[]{props.getProperty("server"), failureMessage});
            }
            default: {
                Dbg.trace("Unknown SSHFailureReporter value " + failureCode + " " + failureMessage);
            }
        }
    }

    public static void setUpSocketParams(Socket sock) throws SocketException {
        sock.setSoTimeout(NDI_SO_TIMEOUT);
    }
}

