/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor;

import com.tripwire.checker.accessor.Accessor;
import com.tripwire.checker.app.AccessorResultType;
import com.tripwire.checker.common.CheckerException;
import com.tripwire.checker.common.ConfigCheckerListener;
import com.tripwire.common.time.Time;
import com.tripwire.common.util.StringUtil;
import com.tripwire.vmware.api.EsxServer;
import com.tripwire.vmware.api.HostCredentials;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.tools.tar.TarEntry;

public abstract class BaseAccessor
implements Runnable,
Accessor {
    private HostCredentials m_hostCredentials;
    private AccessorResultType m_result;
    private long m_startTime;
    private long m_endTime;
    private ConfigCheckerListener m_listener;

    public BaseAccessor() {
        this.setResult(AccessorResultType.NOT_STARTED);
        this.m_startTime = Time.now();
        this.m_endTime = 0L;
    }

    public void run() {
        CheckerException resultException = null;
        try {
            this.setResult(AccessorResultType.IN_PROCESS);
            this.access();
            if (this.getResult() == AccessorResultType.IN_PROCESS) {
                this.setResult(AccessorResultType.FINISHED_SUCCESSFULLY);
            }
        }
        catch (CheckerException e) {
            resultException = e;
            this.setResult(AccessorResultType.FINISHED_WITH_ERROR);
            this.getListener().onFatalError(e);
        }
        catch (Exception e) {
            resultException = new CheckerException(e, "tw.checker.app.errorRetrievingElements", null);
            this.setResult(AccessorResultType.FINISHED_WITH_ERROR);
        }
        this.m_endTime = Time.now();
        this.getListener().onAccessorEnd(this.getName(), this.computeDuration(), this.getResult(), resultException);
    }

    public HostCredentials getHostCredentials() {
        return this.m_hostCredentials;
    }

    public void setHostCredentials(HostCredentials hostCredentials) {
        this.m_hostCredentials = hostCredentials;
    }

    public long computeDuration() {
        long end = this.m_endTime > 0L ? this.m_endTime : Time.now();
        return end - this.m_startTime;
    }

    public AccessorResultType getResult() {
        return this.m_result;
    }

    public void setResult(AccessorResultType result) {
        ConfigCheckerListener listener = this.getListener();
        if (null != listener) {
            listener.onAccessorChange(this.getName(), result, this.m_result);
        }
        this.m_result = result;
    }

    public ConfigCheckerListener getListener() {
        return this.m_listener;
    }

    public void setListener(ConfigCheckerListener listener) {
        if (null == this.m_listener) {
            listener.onAccessorStart(this.getName());
        }
        this.m_listener = listener;
    }

    public GZIPInputStream getZip(EsxServer server, String strUrl) throws Exception {
        InputStream inputStream = this.getFile(server, strUrl);
        return new GZIPInputStream(inputStream);
    }

    public InputStream getFile(EsxServer server, String strUrl) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        TrustManager[] trustAllCerts = new TrustManager[1];
        miTM tm = new miTM();
        trustAllCerts[0] = tm;
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier hv = new HostnameVerifier(){

            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
        String cookieString = server.getCookie();
        URL url = new URL(strUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
        conn.setRequestProperty("Cookie", cookieString);
        conn.connect();
        return conn.getInputStream();
    }

    public String convertMode(TarEntry tarEntry) {
        int mode = tarEntry.getMode();
        StringBuffer buf = new StringBuffer();
        if (tarEntry.isDirectory()) {
            buf.append("d");
        } else {
            buf.append("-");
        }
        String octMode = "0000" + Integer.toOctalString(mode);
        int stickyIndex = octMode.length() - 4;
        int stickyValue = Integer.parseInt(octMode.charAt(stickyIndex) + "");
        int[] execute = new int[]{4, 2, 1};
        String[] stickyTrue = new String[]{"S", "S", "T"};
        String[] stickyFalse = new String[]{"s", "s", "t"};
        int ii = 0;
        for (int index = octMode.length() - 3; index < octMode.length(); ++index) {
            int value = Integer.parseInt(octMode.charAt(index) + "");
            if ((value & 4) > 0) {
                buf.append("r");
            } else {
                buf.append("-");
            }
            if ((value & 2) > 0) {
                buf.append("w");
            } else {
                buf.append("-");
            }
            if ((value & 1) > 0) {
                if ((stickyValue & execute[ii]) > 0) {
                    buf.append(stickyTrue[ii]);
                    continue;
                }
                buf.append("x");
                continue;
            }
            if ((stickyValue & execute[ii]) > 0) {
                buf.append(stickyFalse[ii]);
                continue;
            }
            buf.append("-");
        }
        return buf.toString();
    }

    protected StringBuffer buildFilePermissions(TarEntry tarEntry, String elementName, String attribs) {
        StringBuffer buf = new StringBuffer();
        buf.append(StringUtil.padString(attribs, 12));
        buf.append(StringUtil.padString(tarEntry.getUserName(), 8));
        buf.append(StringUtil.padString(tarEntry.getGroupName(), 8));
        buf.append(StringUtil.alignString(tarEntry.getSize() + "", 8, 1));
        buf.append("  ");
        buf.append(tarEntry.getModTime());
        buf.append("  ");
        buf.append(elementName);
        return buf;
    }

    public static class miTM
    implements TrustManager,
    X509TrustManager {
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] certs) {
            return true;
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

