/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.gui.AWTConvenience;
import com.mindbright.gui.AWTGridBagContainer;
import com.mindbright.gui.BorderDialog;
import com.mindbright.gui.GUI;
import com.mindbright.gui.ProgressBar;
import com.mindbright.jca.security.KeyPair;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.ssh.SSHInteractiveClient;
import com.mindbright.ssh.SSHKeyGenerationDialog;
import com.mindbright.ssh.SSHMiscDialogs;
import com.mindbright.ssh2.SSH2AccessDeniedException;
import com.mindbright.ssh2.SSH2Exception;
import com.mindbright.ssh2.SSH2KeyPairFile;
import com.mindbright.ssh2.SSH2PublicKeyFile;
import com.mindbright.util.RandomSeed;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;

public final class SSHKeyGenerationDialogAWT
extends SSHKeyGenerationDialog {
    private static Choice choiceBits;
    private static Choice choiceType;
    private static TextField fileText;
    private static TextField pwdText;
    private static TextField pwdText2;
    private static TextField commText;
    private static TextArea descText;
    private static ProgressBar progBar;
    private static Button okBut;
    private static Checkbox cbOpenSSH;
    private static Panel cardPanel;
    private static CardLayout cardLayout;
    private static boolean generatedAndSaved;
    private static FileDialog editKeyLoad;
    private static TextField fileTextEd;
    private static TextField pwdTextEd;
    private static TextField pwdText2Ed;
    private static TextField subjTextEd;
    private static TextField commTextEd;
    private static Label typeLbl;
    private static Label bitLbl;
    private static Checkbox cbOpenSSHEd;
    private static Checkbox cbSSHComEd;
    private static Button okButEd;
    private static Button cancButEd;
    private static SSH2KeyPairFile kpf;
    private static SSH2PublicKeyFile pkf;

    public static void show(String string, Frame frame, SSHInteractiveClient sSHInteractiveClient) {
        SSHKeyGenerationDialog.client = sSHInteractiveClient;
        SSHKeyGenerationDialog.parent = frame;
        final BorderDialog borderDialog = new BorderDialog(SSHKeyGenerationDialog.parent, string, true);
        SSHKeyGenerationDialogAWT.createCardPanel();
        borderDialog.add((Component)cardPanel, "Center");
        okBut = new Button("Generate");
        okBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (generatedAndSaved) {
                    SSHKeyGenerationDialogAWT.resetValues();
                    descText.setCaretPosition(0);
                } else if (SSHKeyGenerationDialog.checkValues(pwdText.getText(), pwdText2.getText(), fileText.getText())) {
                    cardLayout.show(cardPanel, "second");
                    okBut.setEnabled(false);
                }
            }
        });
        Button button = new Button("Close");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                borderDialog.dispose();
                SSHKeyGenerationDialogAWT.resetValues();
            }
        });
        borderDialog.add((Component)AWTConvenience.newButtonPanel(new Button[]{okBut, button}), "South");
        borderDialog.addWindowListener(new AWTConvenience.CloseAdapter(button));
        AWTConvenience.setBackgroundOfChildren(borderDialog);
        borderDialog.setResizable(true);
        borderDialog.pack();
        SSHKeyGenerationDialogAWT.resetValues();
        descText.setCaretPosition(0);
        RandomSeed randomSeed = SSHKeyGenerationDialog.client.randomSeed();
        randomSeed.addEntropyGenerator(descText);
        AWTConvenience.placeDialog(borderDialog);
        choiceBits.requestFocus();
        ((Component)borderDialog).setVisible(true);
    }

    private static void createCardPanel() {
        cardPanel = new Panel();
        cardLayout = new CardLayout();
        cardPanel.setLayout(cardLayout);
        Panel panel = new Panel();
        AWTGridBagContainer aWTGridBagContainer = new AWTGridBagContainer(panel);
        GridBagConstraints gridBagConstraints = aWTGridBagContainer.getConstraints();
        gridBagConstraints.fill = 1;
        descText = new TextArea("The key is generated using a random number generator, which is seeded by mouse movement in the field containing this text. Please move the mouse around in here until the progress bar below registers 100%.\n\nThis will create a publickey identity which can be used with the publickey authentication method. Your identity will consist of two parts: public and private keys. Your private key will be saved in the location which you specify; the corresponding public key is saved in a file with an identical name but with an extension of '.pub' added to it.\n\nYour private key is protected by encryption, if you entered a password. If you left the password field blank, the key will not be encrypted. This should only be used in protected environments where unattended logins are desired. The contents of the 'comment' field are stored with your key, and displayed each time you are prompted for the key's password.", 12, 34, 1);
        descText.setEditable(false);
        aWTGridBagContainer.add(descText, 2, 8);
        descText.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (progBar.isFinished()) {
                    try {
                        SSHKeyGenerationDialog.client.randomSeed().removeProgress();
                        progBar.setValue(0L);
                        int n = Integer.valueOf(choiceBits.getSelectedItem());
                        String string = choiceType.getSelectedItem().substring(0, 3);
                        descText.setText("Generating keypair, please wait...");
                        descText.setCaretPosition(0);
                        Thread.yield();
                        KeyPair keyPair = SSHKeyGenerationDialog.generateKeyPair(string, n);
                        SSHKeyGenerationDialogAWT.saveKeyPair(keyPair);
                        okBut.setEnabled(true);
                        okBut.setLabel("Back");
                        descText.setText("Key Generation Complete\n\nTo use the key, you must transfer the '.pub' public key file to an SSH server and add it to the set of authorized keys. See your server documentation for details on this.\n\nFor convenience, your public key has been copied to the clipboard.\n\nExamples:\nIn ssh2 the '.pub' file should be pointed out in the file 'authorization' in the config directory (e.g. ~/.ssh2)\n\nIn OpenSSH's ssh2 the contents of the '.pub' file should be added to the file 'authorized_keys2' in your config directory (e.g. ~/.ssh) on the server.\n\nIn ssh1 the contents of the '.pub' file should be added to the file 'authorized_keys' in your ssh directory (e.g. ~/.ssh).\n\nPress 'Back' to generate a new keypair.");
                        descText.setCaretPosition(0);
                        generatedAndSaved = true;
                    }
                    catch (Throwable throwable) {
                        SSHKeyGenerationDialog.alert("Error while generating/saving key pair: " + throwable.getMessage());
                        cardLayout.show(cardPanel, "first");
                    }
                }
            }
        });
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        progBar = new ProgressBar(512L, 150, 20);
        aWTGridBagContainer.add(progBar, 3, 8);
        cardPanel.add((Component)panel, "second");
        panel = new Panel();
        aWTGridBagContainer = new AWTGridBagContainer(panel);
        gridBagConstraints = aWTGridBagContainer.getConstraints();
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new Label("Key type/format", 2), 0, 2);
        choiceType = AWTConvenience.newChoice(SSHKeyGenerationDialog.KEY_TYPES);
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(choiceType, 0, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new Label("Key length (bits)", 2), 1, 2);
        choiceBits = AWTConvenience.newChoice(SSHKeyGenerationDialog.KEY_LENGTHS);
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(choiceBits, 1, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new Label("Identity file", 2), 2, 2);
        fileText = new TextField("", 18);
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(fileText, 2, 2);
        Button button = new Button("...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = SSHKeyGenerationDialog.getSaveFile();
                if (file != null) {
                    fileText.setText(file.getAbsolutePath());
                }
            }
        });
        gridBagConstraints.fill = 0;
        aWTGridBagContainer.add(button, 2, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new Label("Password", 2), 3, 2);
        pwdText = new TextField("", 18);
        pwdText.setEchoChar('*');
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(pwdText, 3, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new Label("Password again", 2), 4, 2);
        pwdText2 = new TextField("", 18);
        pwdText2.setEchoChar('*');
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(pwdText2, 4, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new Label("Comment", 2), 5, 2);
        commText = new TextField("", 18);
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(commText, 5, 2);
        cbOpenSSH = new Checkbox("OpenSSH .pub format");
        gridBagConstraints.fill = 0;
        aWTGridBagContainer.add(cbOpenSSH, 6, 4);
        cardPanel.add((Component)panel, "first");
    }

    private static void saveKeyPair(KeyPair keyPair) throws IOException, SSH2Exception, NoSuchAlgorithmException {
        SSHKeyGenerationDialog.saveKeyPair(keyPair, pwdText.getText(), fileText.getText(), commText.getText(), choiceType.getSelectedItem(), cbOpenSSH.getState());
        okBut.setEnabled(true);
        pwdText.setText("");
        pwdText2.setText("");
        progBar.setValue(0L);
        fileText.setText(SSHKeyGenerationDialog.getDefaultFileName());
    }

    private static void resetValues() {
        okBut.setEnabled(true);
        choiceBits.select(SSHKeyGenerationDialog.KEY_LENGTHS[1]);
        fileText.setText(SSHKeyGenerationDialog.getDefaultFileName());
        generatedAndSaved = false;
        pwdText.setText("");
        pwdText2.setText("");
        descText.setText("The key is generated using a random number generator, which is seeded by mouse movement in the field containing this text. Please move the mouse around in here until the progress bar below registers 100%.\n\nThis will create a publickey identity which can be used with the publickey authentication method. Your identity will consist of two parts: public and private keys. Your private key will be saved in the location which you specify; the corresponding public key is saved in a file with an identical name but with an extension of '.pub' added to it.\n\nYour private key is protected by encryption, if you entered a password. If you left the password field blank, the key will not be encrypted. This should only be used in protected environments where unattended logins are desired. The contents of the 'comment' field are stored with your key, and displayed each time you are prompted for the key's password.");
        okBut.setLabel("Generate");
        cardLayout.show(cardPanel, "first");
        RandomSeed randomSeed = SSHKeyGenerationDialog.client.randomSeed();
        randomSeed.resetEntropyCount();
        progBar.setValue(0L);
        randomSeed.addProgress(progBar);
    }

    public static void editKeyDialog(String string, Frame frame, SSHInteractiveClient sSHInteractiveClient) {
        SSHKeyGenerationDialog.parent = frame;
        SSHKeyGenerationDialog.client = sSHInteractiveClient;
        File file = GUI.selectFile(SSHKeyGenerationDialog.parent, "MindTerm - Select key file to edit", SSHKeyGenerationDialog.client.propsHandler.getSSHHomeDir(), null, false);
        String string2 = null;
        String string3 = null;
        kpf = new SSH2KeyPairFile();
        if (file != null) {
            string3 = file.getAbsolutePath();
            try {
                pkf = new SSH2PublicKeyFile();
                pkf.load(string3 + ".pub");
            }
            catch (Exception exception) {
                pkf = null;
            }
            boolean bl = false;
            do {
                try {
                    kpf.load(string3, string2);
                    break;
                }
                catch (SSH2AccessDeniedException sSH2AccessDeniedException) {
                    bl = true;
                }
                catch (Exception exception) {
                    SSHKeyGenerationDialog.alert("Error loading key file: " + exception.getMessage());
                }
            } while ((string2 = SSHMiscDialogs.password("MindTerm - File Password", "Please give password for " + string3, SSHKeyGenerationDialog.parent)) != null);
            if (bl && string2 == null) {
                return;
            }
        } else {
            return;
        }
        if (pkf == null) {
            pkf = new SSH2PublicKeyFile(kpf.getKeyPair().getPublic(), kpf.getSubject(), kpf.getComment());
        }
        final Dialog dialog = new Dialog(SSHKeyGenerationDialog.parent, string, true);
        AWTGridBagContainer aWTGridBagContainer = new AWTGridBagContainer(dialog);
        GridBagConstraints gridBagConstraints = aWTGridBagContainer.getConstraints();
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new Label("Key type/format", 2), 0, 2);
        typeLbl = new Label("DSA");
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(typeLbl, 0, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new Label("Key length (bits)", 2), 1, 2);
        bitLbl = new Label("1024");
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(bitLbl, 1, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new Label("Identity file", 2), 2, 2);
        fileTextEd = new TextField("", 18);
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(fileTextEd, 2, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new Label("Password", 2), 3, 2);
        pwdTextEd = new TextField("", 18);
        pwdTextEd.setEchoChar('*');
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(pwdTextEd, 3, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new Label("Password again", 2), 4, 2);
        pwdText2Ed = new TextField("", 18);
        pwdText2Ed.setEchoChar('*');
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(pwdText2Ed, 4, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new Label("Subject", 2), 5, 2);
        subjTextEd = new TextField("", 18);
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(subjTextEd, 5, 2);
        gridBagConstraints.anchor = 13;
        aWTGridBagContainer.add(new Label("Comment", 2), 6, 2);
        commTextEd = new TextField("", 18);
        gridBagConstraints.anchor = 17;
        aWTGridBagContainer.add(commTextEd, 6, 2);
        cbSSHComEd = new Checkbox("SSH Comm. private file format");
        gridBagConstraints.fill = 0;
        aWTGridBagContainer.add(cbSSHComEd, 7, 4);
        cbOpenSSHEd = new Checkbox("OpenSSH .pub format");
        aWTGridBagContainer.add(cbOpenSSHEd, 8, 4);
        okButEd = new Button("Save");
        okButEd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = fileTextEd.getText();
                String string2 = pwdTextEd.getText();
                if (SSHKeyGenerationDialog.checkValues(string2, pwdText2Ed.getText(), string)) {
                    string = SSHKeyGenerationDialog.expandFileName(string);
                    try {
                        String string3 = subjTextEd.getText();
                        String string4 = commTextEd.getText();
                        pkf.setSubject(string3);
                        pkf.setComment(string4);
                        pkf.store(string + ".pub", !cbOpenSSHEd.getState());
                        if (!(cbSSHComEd.getState() || string2 != null && string2.length() != 0)) {
                            string3 = null;
                            string4 = null;
                        }
                        kpf.setSubject(string3);
                        kpf.setComment(string4);
                        kpf.store(string, SSHKeyGenerationDialog.client.secureRandom(), string2, cbSSHComEd.getState());
                        dialog.dispose();
                    }
                    catch (Exception exception) {
                        SSHKeyGenerationDialog.alert("Error saving files: " + exception.getMessage());
                    }
                }
            }
        });
        cancButEd = new Button("Cancel");
        cancButEd.addActionListener(new AWTConvenience.CloseAction(dialog));
        Panel panel = AWTConvenience.newButtonPanel(new Button[]{okButEd, cancButEd});
        aWTGridBagContainer.add(panel, 9, 0);
        dialog.addWindowListener(new AWTConvenience.CloseAdapter(cancButEd));
        AWTConvenience.setBackgroundOfChildren(dialog);
        AWTConvenience.setKeyListenerOfChildren(dialog, new AWTConvenience.OKCancelAdapter(okButEd, cancButEd), null);
        dialog.pack();
        fileTextEd.setText(string3);
        pwdTextEd.setText(string2);
        pwdText2Ed.setText(string2);
        typeLbl.setText(kpf.getAlgorithmName());
        bitLbl.setText(String.valueOf(kpf.getBitLength()));
        subjTextEd.setText(kpf.getSubject());
        commTextEd.setText(kpf.getComment());
        cbSSHComEd.setState(kpf.isSSHComFormat());
        cbOpenSSHEd.setState(!pkf.isSSHComFormat());
        AWTConvenience.placeDialog(dialog);
        ((Component)dialog).setVisible(true);
    }
}

