/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.jca.security;

import com.mindbright.jca.security.InvalidAlgorithmParameterException;
import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.InvalidParameterException;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.NoSuchProviderException;
import com.mindbright.jca.security.PrivateKey;
import com.mindbright.jca.security.Provider;
import com.mindbright.jca.security.ProviderLookup;
import com.mindbright.jca.security.PublicKey;
import com.mindbright.jca.security.SecureRandom;
import com.mindbright.jca.security.SignatureException;
import com.mindbright.jca.security.SignatureSpi;
import com.mindbright.jca.security.spec.AlgorithmParameterSpec;

public class Signature
extends SignatureSpi {
    protected static final int UNINITIALIZED = 0;
    protected static final int SIGN = 1;
    protected static final int VERIFY = 2;
    private final String[] states = new String[]{"<uninitialized>", "<sign>", "<verify>"};
    protected int state;
    private SignatureSpi signatureSpi;
    private Provider provider;
    private String algorithm;

    protected Signature(String string) {
        this.algorithm = string;
    }

    public static Signature getInstance(String string) throws NoSuchAlgorithmException {
        try {
            String string2 = ProviderLookup.findImplementingProvider("Signature", string);
            return Signature.getInstance(string, string2);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new Error("Error in Signature: " + noSuchProviderException);
        }
    }

    public static Signature getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        ProviderLookup providerLookup = ProviderLookup.getImplementation("Signature", string, string2);
        SignatureSpi signatureSpi = (SignatureSpi)providerLookup.getImpl();
        Signature signature = new Signature(string);
        signature.provider = providerLookup.getProvider();
        signature.signatureSpi = signatureSpi;
        return signature;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.signatureSpi.engineInitVerify(publicKey);
        this.state = 2;
    }

    public void initSign(PrivateKey privateKey) throws InvalidKeyException {
        this.signatureSpi.engineInitSign(privateKey);
        this.state = 1;
    }

    public void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.signatureSpi.engineInitSign(privateKey, secureRandom);
        this.state = 1;
    }

    public byte[] sign() throws SignatureException {
        if (this.state != 1) {
            throw new SignatureException("Signature not initialized for signing");
        }
        return this.signatureSpi.engineSign();
    }

    public int sign(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.state != 1) {
            throw new SignatureException("Signature not initialized for signing");
        }
        return this.signatureSpi.engineSign(byArray, n, n2);
    }

    public boolean verify(byte[] byArray) throws SignatureException {
        if (this.state != 2) {
            throw new SignatureException("Signature not initialized for verification");
        }
        return this.signatureSpi.engineVerify(byArray);
    }

    public void update(byte by) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException("Signature not initialized");
        }
        this.signatureSpi.engineUpdate(by);
    }

    public final void update(byte[] byArray) throws SignatureException {
        this.update(byArray, 0, byArray.length);
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException("Signature not initialized");
        }
        this.signatureSpi.engineUpdate(byArray, n, n2);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final String toString() {
        return "Signature " + this.getAlgorithm() + " " + this.states[this.state] + " (" + this.provider.getName() + ")";
    }

    public void setParameter(String string, Object object) throws InvalidParameterException {
        this.signatureSpi.engineSetParameter(string, object);
    }

    public void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.signatureSpi.engineSetParameter(algorithmParameterSpec);
    }

    public Object getParameter(String string) throws InvalidParameterException {
        return this.signatureSpi.engineGetParameter(string);
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.notImplemented();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.notImplemented();
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.notImplemented();
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.notImplemented();
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.notImplemented();
    }

    protected byte[] engineSign() throws SignatureException {
        this.notImplemented();
        return null;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        this.notImplemented();
        return false;
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        this.notImplemented();
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        this.notImplemented();
        return null;
    }

    private final void notImplemented() {
        throw new Error("Abstract method in SignatureSpi implementation missing");
    }
}

