/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.gui;

import java.applet.Applet;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;

public class TabPanel
extends Panel {
    public int margin = 3;
    private Font tabFont;
    private FontMetrics metric;
    private int nCards = 0;
    private Vector names = new Vector(10, 10);
    private int[] pos;
    private int[] width;
    private int selected = 0;
    private int offset = 0;
    private int tabH;
    private int tabN = 12;
    private int[][] tabLeft = new int[2][this.tabN];
    private int[][] tabRight = new int[2][this.tabN];
    private Image offscreen = null;
    private Applet applet = null;

    public TabPanel() {
        this.setLayout(new CardLayout());
        this.setTabFont(new Font("Helvetica", 1, 12));
        this.enableEvents(48L);
    }

    private int findComponent(Component component) {
        for (int i = 0; i < this.nCards; ++i) {
            if (this.getComponent(i) != component) continue;
            return i;
        }
        return -1;
    }

    public Component add(String string, Component component) {
        string = string.intern();
        super.add(string, component);
        if (!this.names.contains(string)) {
            this.names.addElement(string);
            ++this.nCards;
            if (this.isShowing()) {
                this.computeTabs();
                this.repaint();
            }
        }
        return component;
    }

    public void remove(Component component) {
        int n = this.findComponent(component);
        super.remove(component);
        this.names.removeElementAt(n);
        --this.nCards;
        if (n < this.selected) {
            this.setSelected(this.selected - 1, true);
        } else if (n == this.selected && this.nCards > 0) {
            this.setSelected(this.selected % this.nCards, true);
        }
        if (this.isShowing()) {
            this.computeTabs();
            this.repaint();
        }
    }

    public void remove(String string) {
        int n = this.names.indexOf(string.intern());
        if (n != -1) {
            this.remove(this.getComponent(n));
        }
    }

    public void removeAll() {
        super.removeAll();
        this.names.removeAllElements();
        this.repaint();
    }

    private void setSelected(int n, boolean bl) {
        if (bl || n != this.selected && n >= 0 && n < this.nCards) {
            if (this.nCards > 0) {
                this.selected = n % this.nCards;
            }
            ((CardLayout)this.getLayout()).show(this, (String)this.names.elementAt(n));
            this.repaint();
        }
    }

    public void first() {
        this.setSelected(0, false);
    }

    public void last() {
        this.setSelected(this.nCards - 1, false);
    }

    public void next() {
        this.setSelected((this.selected + 1) % this.nCards, false);
    }

    public void previous() {
        this.setSelected((this.selected - 1 + this.nCards) % this.nCards, false);
    }

    public void show(String string) {
        this.setSelected(this.names.indexOf(string.intern()), false);
    }

    public void show(Component component) {
        this.setSelected(this.findComponent(component), false);
    }

    private int cardAt(int n, int n2) {
        if (n2 <= this.tabH) {
            n += this.offset;
            for (int i = 0; i < this.nCards; ++i) {
                if (this.pos[i] > n || n >= this.pos[i + 1]) continue;
                return i;
            }
        }
        return -1;
    }

    public String documentCard(String string) {
        return "Select tab card " + string;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            Point point = mouseEvent.getPoint();
            int n = this.cardAt(point.x, point.y);
            if (n != -1) {
                this.setSelected(n, false);
                return;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 503) {
            Serializable serializable;
            if (this.applet == null) {
                for (serializable = this.getParent(); serializable != null; serializable = ((Component)serializable).getParent()) {
                    if (!(serializable instanceof Applet)) continue;
                    this.applet = (Applet)serializable;
                }
            }
            if (this.applet != null) {
                serializable = mouseEvent.getPoint();
                int n = this.cardAt(((Point)serializable).x, ((Point)serializable).y);
                if (n != -1) {
                    this.applet.showStatus(this.documentCard((String)this.names.elementAt(n)));
                }
            }
        } else if (mouseEvent.getID() == 505 && this.applet != null) {
            this.applet.showStatus("");
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public Insets getInsets() {
        return new Insets(this.tabH + this.margin, this.margin, this.margin, this.margin);
    }

    public void setTabFont(Font font) {
        int n;
        this.tabFont = font;
        this.metric = this.getFontMetrics(font);
        int n2 = (this.metric.getHeight() + 1) / 2;
        this.tabH = 2 * n2;
        int n3 = (this.tabN - 2) / 2;
        for (n = 0; n <= n3; ++n) {
            int n4;
            double d = Math.PI * (double)n / 2.0 / (double)n3;
            int n5 = (int)((double)n2 * Math.cos(d));
            this.tabLeft[0][n] = n4 = (int)((double)n2 * Math.sin(d));
            this.tabLeft[1][n] = n2 + n5;
            this.tabLeft[0][n + n3] = this.tabH - n5;
            this.tabLeft[1][n + n3] = n2 - n4;
        }
        this.tabLeft[0][2 * n3 + 1] = this.tabH;
        this.tabLeft[1][2 * n3 + 1] = this.tabH;
        for (n = 0; n < this.tabN; ++n) {
            this.tabRight[0][n] = -this.tabLeft[0][n];
            this.tabRight[1][n] = this.tabLeft[1][n];
        }
    }

    private void computeTabs() {
        int n;
        if (this.pos == null || this.pos.length <= this.nCards) {
            this.width = new int[this.nCards + 1];
            this.pos = new int[this.nCards + 1];
        }
        int n2 = this.tabH / 2;
        for (n = 0; n < this.nCards; ++n) {
            this.pos[n] = n2;
            this.width[n] = this.tabH + this.metric.stringWidth((String)this.names.elementAt(n));
            n2 += this.width[n];
        }
        this.pos[this.nCards] = n2;
        n = this.getSize().width;
        if (this.offscreen == null || this.offscreen.getHeight(this) < this.tabH || this.offscreen.getWidth(this) < n) {
            this.offscreen = this.createImage(n, this.tabH);
        }
    }

    public void doLayout() {
        super.doLayout();
        this.computeTabs();
    }

    private void paintTabEdge(Graphics graphics, int n, int[][] nArray) {
        graphics.translate(n, 0);
        graphics.setColor(this.getBackground());
        graphics.fillPolygon(nArray[0], nArray[1], this.tabN);
        graphics.setColor(this.getForeground());
        for (int i = 0; i < this.tabN - 2; ++i) {
            graphics.drawLine(nArray[0][i], nArray[1][i], nArray[0][i + 1], nArray[1][i + 1]);
        }
        graphics.translate(-n, 0);
    }

    private void paintTab(Graphics graphics, int n, int n2) {
        int n3 = this.tabH / 2;
        int n4 = this.width[n2];
        this.paintTabEdge(graphics, n - n3, this.tabLeft);
        this.paintTabEdge(graphics, n + n4 + n3, this.tabRight);
        graphics.setColor(this.getBackground());
        graphics.fillRect(n + n3, 0, n4 - this.tabH, this.tabH);
        graphics.setColor(this.getForeground());
        graphics.drawLine(n + n3, 0, n + n4 - n3, 0);
        graphics.setFont(this.tabFont);
        graphics.drawString((String)this.names.elementAt(n2), n + n3, this.tabH - this.metric.getDescent());
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Graphics graphics2 = this.offscreen.getGraphics();
        int n = dimension.width - 1;
        int n2 = dimension.height - 1;
        int n3 = this.tabH / 2;
        int n4 = this.selected;
        int n5 = 4;
        int n6 = 3;
        Color color = this.getParent().getBackground();
        graphics2.setColor(this.getParent().getBackground());
        graphics2.fillRect(0, 0, n + 1, this.tabH);
        graphics2.setColor(this.getForeground());
        if (this.nCards == 0) {
            graphics2.drawLine(0, this.tabH, n, this.tabH);
        } else {
            int n7;
            int n8;
            int n9 = this.pos[n4] - n3 - Math.min(n6, n4) * n5;
            int n10 = this.pos[n4 + 1] - n + n3 + Math.min(this.nCards - n4, n6) * n5;
            if (this.offset < n10 || this.offset > n9) {
                this.offset = Math.min(Math.max(0, (n10 + n9) / 2), this.pos[this.nCards] + n3 - n);
            }
            int n11 = this.offset + n3;
            for (n8 = 0; n8 < n4 && this.pos[n8] <= n11; ++n8) {
            }
            if (n8 > 0) {
                n11 = 0;
                n7 = Math.max(0, n8 - n6);
                while (n7 < n8 - 1) {
                    this.paintTabEdge(graphics2, n11, this.tabLeft);
                    ++n7;
                    n11 += n5;
                }
                this.paintTab(graphics2, n11 + n3, n8 - 1);
            }
            for (n7 = n8; n7 < n4; ++n7) {
                this.paintTab(graphics2, this.pos[n7] - this.offset, n7);
            }
            n11 = this.offset + n - n3;
            for (n8 = this.nCards - 1; n8 > n4 && this.pos[n8 + 1] >= n11; --n8) {
            }
            if (n8 < this.nCards - 1) {
                n11 = n;
                n7 = Math.min(this.nCards - 1, n8 + n6);
                while (n7 > n8 + 1) {
                    this.paintTabEdge(graphics2, n11, this.tabRight);
                    --n7;
                    n11 -= n5;
                }
                this.paintTab(graphics2, n11 - n3 - this.width[n8 + 1], n8 + 1);
            }
            for (n7 = n8; n7 > n4; --n7) {
                this.paintTab(graphics2, this.pos[n7] - this.offset, n7);
            }
            graphics2.clearRect(this.pos[n4] - n3 - this.offset + 2, this.tabH - 1, this.width[n4] + this.tabH - 1, 1);
            this.paintTab(graphics2, this.pos[n4] - this.offset, n4);
            graphics2.drawLine(0, this.tabH - 1, this.pos[n4] - n3 - this.offset + 1, this.tabH - 1);
            graphics2.drawLine(this.pos[n4 + 1] + n3 - this.offset - 1, this.tabH - 1, n, this.tabH - 1);
        }
        graphics.drawImage(this.offscreen, 0, 0, this);
        graphics.drawLine(n, this.tabH, n, n2);
        graphics.drawLine(n, n2, 0, n2);
        graphics.drawLine(0, n2, 0, this.tabH);
    }
}

