/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TIntHash;
import gnu.trove.TIntHashingStrategy;
import gnu.trove.TIntObjectIterator;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TIntObjectHashMap
extends TIntHash
implements Serializable {
    protected transient Object[] _values;

    public TIntObjectHashMap() {
    }

    public TIntObjectHashMap(int n) {
        super(n);
    }

    public TIntObjectHashMap(int n, float f) {
        super(n, f);
    }

    public TIntObjectHashMap(TIntHashingStrategy tIntHashingStrategy) {
        super(tIntHashingStrategy);
    }

    public TIntObjectHashMap(int n, TIntHashingStrategy tIntHashingStrategy) {
        super(n, tIntHashingStrategy);
    }

    public TIntObjectHashMap(int n, float f, TIntHashingStrategy tIntHashingStrategy) {
        super(n, f, tIntHashingStrategy);
    }

    public Object clone() {
        TIntObjectHashMap tIntObjectHashMap = (TIntObjectHashMap)super.clone();
        tIntObjectHashMap._values = (Object[])this._values.clone();
        return tIntObjectHashMap;
    }

    public TIntObjectIterator iterator() {
        return new TIntObjectIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new Object[n2];
        return n2;
    }

    public Object put(int n, Object object) {
        Object object2 = null;
        int n2 = this.insertionIndex(n);
        boolean bl = true;
        if (n2 < 0) {
            n2 = -n2 - 1;
            object2 = this._values[n2];
            bl = false;
        }
        byte by = this._states[n2];
        this._set[n2] = n;
        this._states[n2] = 1;
        this._values[n2] = object;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return object2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        int[] nArray = this._set;
        Object[] objectArray = this._values;
        byte[] byArray = this._states;
        this._set = new int[n];
        this._values = new Object[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            int n4 = nArray[n3];
            int n5 = this.insertionIndex(n4);
            this._set[n5] = n4;
            this._values[n5] = objectArray[n3];
            this._states[n5] = 1;
        }
    }

    public Object get(int n) {
        int n2 = this.index(n);
        return n2 < 0 ? null : this._values[n2];
    }

    public void clear() {
        super.clear();
        int[] nArray = this._set;
        Object[] objectArray = this._values;
        byte[] byArray = this._states;
        int n = nArray.length;
        while (n-- > 0) {
            nArray[n] = 0;
            objectArray[n] = null;
            byArray[n] = 0;
        }
    }

    public Object remove(int n) {
        Object object = null;
        int n2 = this.index(n);
        if (n2 >= 0) {
            object = this._values[n2];
            this.removeAt(n2);
        }
        return object;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TIntObjectHashMap)) {
            return false;
        }
        TIntObjectHashMap tIntObjectHashMap = (TIntObjectHashMap)object;
        if (tIntObjectHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tIntObjectHashMap));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = null;
    }

    public Object[] getValues() {
        Object[] objectArray = new Object[this.size()];
        Object[] objectArray2 = this._values;
        byte[] byArray = this._states;
        int n = objectArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            objectArray[n2++] = objectArray2[n];
        }
        return objectArray;
    }

    public int[] keys() {
        int[] nArray = new int[this.size()];
        int[] nArray2 = this._set;
        byte[] byArray = this._states;
        int n = nArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n2++] = nArray2[n];
        }
        return nArray;
    }

    public boolean containsValue(Object object) {
        byte[] byArray = this._states;
        Object[] objectArray = this._values;
        if (null == object) {
            int n = objectArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || object != objectArray[n]) continue;
                return true;
            }
        } else {
            int n = objectArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || object != objectArray[n] && !object.equals(objectArray[n])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(int n) {
        return this.contains(n);
    }

    public boolean forEachKey(TIntProcedure tIntProcedure) {
        return this.forEach(tIntProcedure);
    }

    public boolean forEachValue(TObjectProcedure tObjectProcedure) {
        byte[] byArray = this._states;
        Object[] objectArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tObjectProcedure.execute(objectArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TIntObjectProcedure tIntObjectProcedure) {
        byte[] byArray = this._states;
        int[] nArray = this._set;
        Object[] objectArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tIntObjectProcedure.execute(nArray[n], objectArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TIntObjectProcedure tIntObjectProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        int[] nArray = this._set;
        Object[] objectArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tIntObjectProcedure.execute(nArray[n], objectArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TObjectFunction tObjectFunction) {
        byte[] byArray = this._states;
        Object[] objectArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            objectArray[n] = tObjectFunction.execute(objectArray[n]);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            int n2 = objectInputStream.readInt();
            Object object = objectInputStream.readObject();
            this.put(n2, object);
        }
    }

    private static final class EqProcedure
    implements TIntObjectProcedure {
        private final TIntObjectHashMap _otherMap;

        EqProcedure(TIntObjectHashMap tIntObjectHashMap) {
            this._otherMap = tIntObjectHashMap;
        }

        public final boolean execute(int n, Object object) {
            int n2 = this._otherMap.index(n);
            return n2 >= 0 && this.eq(object, this._otherMap.get(n));
        }

        private final boolean eq(Object object, Object object2) {
            return object == object2 || object != null && object.equals(object2);
        }
    }

    private final class HashProcedure
    implements TIntObjectProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(int n, Object object) {
            this.h += TIntObjectHashMap.this._hashingStrategy.computeHashCode(n) ^ HashFunctions.hash(object);
            return true;
        }
    }
}

