/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.app;

import com.tripwire.checker.accessor.ElementCache;
import com.tripwire.checker.app.TestResultType;
import com.tripwire.checker.app.xml.ContentTest;
import com.tripwire.checker.app.xml.PolicyTest;
import com.tripwire.checker.app.xml.PolicyTests;
import com.tripwire.checker.app.xml.parser.ChildParser;
import com.tripwire.checker.app.xml.parser.ChildrenParser;
import com.tripwire.checker.app.xml.parser.ContentTestParser;
import com.tripwire.checker.app.xml.parser.ElementNameConditionalXmlElementParser;
import com.tripwire.checker.app.xml.parser.ParamParser;
import com.tripwire.checker.app.xml.parser.ParametersParser;
import com.tripwire.checker.app.xml.parser.PathParser;
import com.tripwire.checker.app.xml.parser.PolicyParser;
import com.tripwire.checker.app.xml.parser.PolicyTestsParser;
import com.tripwire.checker.app.xml.parser.RuleGroupParser;
import com.tripwire.checker.app.xml.parser.RuleParser;
import com.tripwire.checker.app.xml.parser.RuleRefParser;
import com.tripwire.checker.app.xml.parser.RulesParser;
import com.tripwire.checker.app.xml.parser.RulesRefParser;
import com.tripwire.checker.app.xml.parser.SshRuleParser;
import com.tripwire.checker.app.xml.parser.SshRulesParser;
import com.tripwire.checker.app.xml.parser.TestGroupParser;
import com.tripwire.checker.common.CheckerException;
import com.tripwire.checker.common.ConfigCheckerListener;
import com.tripwire.common.util.ArrayUtil;
import com.tripwire.common.util.FileUtil;
import com.tripwire.common.util.StreamUtil;
import com.tripwire.common.util.xml.AbstractXmlInputFormat;
import com.tripwire.common.util.xml.XmlDuplicateIdException;
import com.tripwire.common.util.xml.XmlException;
import com.tripwire.common.util.xml.XmlInputContext;
import com.tripwire.common.util.xml.XmlMissingTagException;
import com.tripwire.space.core.conditional.ContentConditions;
import com.tripwire.space.core.conditional.TextContentConditions;
import com.tripwire.space.core.conditional.xml.ElementNameExtractorXmlElementParser;
import com.tripwire.space.core.xml.GlobalXmlInputFormat;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyTester {
    private int m_verbosity;
    private Map<ContentTest, TestResultType> m_results;
    private ConfigCheckerListener m_listener;
    private List<ContentTest> m_contentTests;
    private int m_present = 0;
    private int m_absent = 0;
    private int m_pass = 0;
    private int m_fail = 0;
    private int m_broke = 0;
    private int m_unavailable = 0;
    private int m_passOnAbsent = 0;
    private int m_failOnAbsent = 0;
    private int m_ignoreOnAbsent = 0;
    private int m_unknownOnAbsent = 0;

    public PolicyTester(ConfigCheckerListener listener) {
        this.setVerbosity(Integer.getInteger("tw.honeybee.verbosity", 0));
        this.m_results = new HashMap<ContentTest, TestResultType>();
        this.m_contentTests = null;
        this.setListener(listener);
        this.resetCounts();
    }

    public void loadContentTests(String policyFilename) throws CheckerException {
        this.m_contentTests = null;
        PolicyTests policyTests = null;
        if (null == policyFilename) {
            return;
        }
        GlobalXmlInputFormat formats = GlobalXmlInputFormat.getInstance();
        Reader input = this.getReader(policyFilename);
        try {
            Object o;
            XmlInputContext context = new XmlInputContext(input, formats);
            while (context.detectElementStart() && (o = context.maybeParseObjectElement()) instanceof PolicyTests) {
                policyTests = (PolicyTests)o;
            }
            if (null == policyTests) {
                throw new CheckerException("tw.checker.app.emptyPolicyFile", ArrayUtil.EMPTY_OBJECTS);
            }
            this.m_contentTests = policyTests.getContentTests();
            HashMap<String, PolicyTest> tests = policyTests.getTests();
            this.getListener().onTestsLoaded(tests);
        }
        catch (XmlMissingTagException e) {
            throw new CheckerException(e, "tw.checker.app.missingElementInPolicyFile", null);
        }
        catch (XmlDuplicateIdException e) {
            throw new CheckerException(e, "tw.checker.app.duplicateElementInPolicyFile", null);
        }
        catch (XmlException e) {
            throw new CheckerException(e, "tw.checker.app.parsePolicyFile", null);
        }
        catch (IOException e) {
            throw new CheckerException(e, "tw.checker.app.readPolicyFile", null);
        }
        finally {
            StreamUtil.close(input);
        }
    }

    public static void install(AbstractXmlInputFormat mgr) {
        mgr.addParser(new PolicyTestsParser());
        mgr.addParser(new TestGroupParser());
        mgr.addParser(new ChildrenParser());
        mgr.addParser(new ChildParser());
        mgr.addParser(new ContentTestParser());
        mgr.addParser(new ElementNameConditionalXmlElementParser());
        mgr.addParser(new ElementNameExtractorXmlElementParser());
        mgr.addParser(new RulesRefParser());
        mgr.addParser(new RuleRefParser());
        mgr.addParser(new PathParser());
        mgr.addParser(new RulesParser());
        mgr.addParser(new RuleGroupParser());
        mgr.addParser(new RuleParser());
        mgr.addParser(new ParametersParser());
        mgr.addParser(new ParamParser());
        mgr.addParser(new SshRulesParser());
        mgr.addParser(new SshRuleParser());
        mgr.addParser(new PolicyParser());
    }

    public void verifyTests() {
        if (null == this.m_contentTests) {
            return;
        }
        ElementCache elementCache = ElementCache.getInstance();
        this.resetCounts();
        for (ContentTest contentTest : this.m_contentTests) {
            if (this.isTestComplete(contentTest)) continue;
            String elementName = contentTest.getElementName();
            String content = elementCache.get(elementName);
            contentTest.setElementContent(content);
            if (null == content && elementName.contains("*")) {
                this.evaluateTestForRegExElement(elementCache, contentTest, elementName);
                continue;
            }
            this.evaluateTestForRegularElement(contentTest, elementName, content);
        }
    }

    private void resetCounts() {
        this.m_present = 0;
        this.m_absent = 0;
        this.m_pass = 0;
        this.m_fail = 0;
        this.m_broke = 0;
        this.m_passOnAbsent = 0;
        this.m_failOnAbsent = 0;
        this.m_ignoreOnAbsent = 0;
        this.m_unknownOnAbsent = 0;
        this.m_unavailable = 0;
    }

    public void printSummaryResults() {
        if (this.getVerbosity() > 0) {
            System.out.println("present=" + this.m_present + ", absent=" + this.m_absent + ", pass=" + this.m_pass + ", fail=" + this.m_fail + ", unavail=" + this.m_unavailable + ", broke=" + this.m_broke + " Absent(pass=" + this.m_passOnAbsent + ", fail=" + this.m_failOnAbsent + ", ignore=" + this.m_ignoreOnAbsent + ", unknown=" + this.m_unknownOnAbsent + ")");
        }
    }

    public void finalizeTestResults() {
        Map<ContentTest, TestResultType> results = this.getResults();
        block5: for (ContentTest contentTest : results.keySet()) {
            TestResultType testResultType = this.getResults().get(contentTest);
            switch (testResultType) {
                case FAIL_ON_ABSENT: 
                case FAIL_SO_FAR: {
                    results.put(contentTest, TestResultType.FAIL);
                    this.getListener().onChangeTest(contentTest, TestResultType.FAIL, testResultType);
                    continue block5;
                }
                case PASS_ON_ABSENT: 
                case PASS_SO_FAR: {
                    results.put(contentTest, TestResultType.PASS);
                    this.getListener().onChangeTest(contentTest, TestResultType.PASS, testResultType);
                    continue block5;
                }
                case PASS: 
                case FAIL: 
                case UNAVAILABLE: {
                    continue block5;
                }
            }
            System.out.println("Unexpected result " + contentTest.getAttribName() + " - " + testResultType.getName());
        }
    }

    private void evaluateTestForRegExElement(ElementCache elementCache, ContentTest contentTest, String elementName) {
        TestResultType curType;
        Pattern pattern = Pattern.compile(elementName);
        Set<String> keys = elementCache.keySet();
        StringBuffer buf = new StringBuffer();
        StringBuffer contentBuf = new StringBuffer();
        boolean totalResult = true;
        int matchCount = 0;
        ContentConditions contentConditions = contentTest.getContentConditional();
        for (String key : keys) {
            boolean oneResult;
            Matcher matcher = pattern.matcher(key);
            if (!matcher.matches()) continue;
            ++matchCount;
            String content = elementCache.get(key);
            try {
                oneResult = contentConditions.evaluateString(content);
            }
            catch (Exception e) {
                this.getListener().onFatalError(new CheckerException(e, "errorEvalRegExElement", null));
                oneResult = false;
            }
            if (oneResult) continue;
            totalResult = false;
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(key);
            contentBuf.append(content);
            contentBuf.append("\n");
        }
        if (this.getVerbosity() > 1) {
            System.out.println((totalResult ? "PASS" : "FAIL") + " " + elementName + "(" + keys.size() + ") - " + contentTest.getDescription().trim());
        }
        if (contentConditions instanceof TextContentConditions) {
            TextContentConditions tcc = (TextContentConditions)contentConditions;
            if (this.getVerbosity() > 2) {
                System.out.println("RegEx:\n" + tcc.getRegularExpression());
            }
        } else if (this.getVerbosity() > 2) {
            System.out.println("Cond: " + contentConditions.getClass().getName());
        }
        if (0 == matchCount) {
            curType = this.getActionIfMissingContent(contentConditions);
        } else if (totalResult) {
            ++this.m_pass;
            curType = TestResultType.PASS_SO_FAR;
            if (this.getVerbosity() > 1) {
                System.out.println();
            }
        } else {
            ++this.m_fail;
            curType = TestResultType.FAIL;
            if (this.getVerbosity() > 0) {
                System.out.println("Failed Elements:\n" + buf.toString());
                System.out.println("\n");
            }
        }
        this.recordTestResults(contentTest, curType);
    }

    private boolean isTestComplete(ContentTest contentTest) {
        boolean testComplete;
        TestResultType prevType = !this.getResults().containsKey(contentTest) ? TestResultType.UNKNOWN : this.getResults().get(contentTest);
        switch (prevType) {
            case PASS: {
                ++this.m_pass;
                ++this.m_present;
                testComplete = true;
                break;
            }
            case FAIL: {
                ++this.m_fail;
                ++this.m_present;
                testComplete = true;
                break;
            }
            case UNAVAILABLE: {
                ++this.m_unavailable;
                ++this.m_present;
                testComplete = true;
                break;
            }
            default: {
                testComplete = false;
            }
        }
        return testComplete;
    }

    private void recordTestResults(ContentTest contentTest, TestResultType curType) {
        boolean firstTime;
        TestResultType prevType;
        if (!this.getResults().containsKey(contentTest)) {
            prevType = TestResultType.UNKNOWN;
            firstTime = true;
        } else {
            prevType = this.getResults().get(contentTest);
            firstTime = false;
        }
        if (prevType != curType || firstTime) {
            this.getResults().put(contentTest, curType);
            this.getListener().onChangeTest(contentTest, curType, prevType);
        }
    }

    private void evaluateTestForRegularElement(ContentTest contentTest, String elementName, String content) {
        TestResultType curType;
        ContentConditions contentConditions = contentTest.getContentConditional();
        if (null != content) {
            ++this.m_present;
            curType = content.contains(": Permission denied") ? TestResultType.UNAVAILABLE : this.evaluateString(contentTest, elementName, content, contentConditions);
        } else {
            curType = this.getActionIfMissingContent(contentConditions);
            ++this.m_absent;
            if (this.getVerbosity() > 2) {
                System.out.println("MISSING " + curType.getName() + " " + contentTest.getElementName() + " - " + contentTest.getDescription());
            }
            if (contentConditions instanceof TextContentConditions) {
                TextContentConditions tcc = (TextContentConditions)contentConditions;
                if (this.getVerbosity() > 2) {
                    System.out.println("RegEx:\n" + tcc.getRegularExpression() + "\n");
                }
            } else if (this.getVerbosity() > 2) {
                System.out.println("Cond: " + contentConditions.getClass().getName() + "\n");
            }
        }
        this.recordTestResults(contentTest, curType);
    }

    private TestResultType evaluateString(ContentTest contentTest, String elementName, String content, ContentConditions contentConditions) {
        TestResultType curType;
        try {
            boolean result = contentConditions.evaluateString(content);
            if (this.getVerbosity() > 2) {
                System.out.println((result ? "PASS" : "FAIL") + " " + elementName + " - " + contentTest.getDescription().trim());
            }
            if (contentConditions instanceof TextContentConditions) {
                TextContentConditions tcc = (TextContentConditions)contentConditions;
                if (this.getVerbosity() > 2) {
                    System.out.println("RegEx:\n" + tcc.getRegularExpression() + "\n");
                }
            } else if (this.getVerbosity() > 2) {
                System.out.println("Cond: " + contentConditions.getClass().getName() + "\n");
            }
            if (this.getVerbosity() > 2) {
                System.out.print("Content (len=");
                System.out.print(null == content ? -1 : content.length());
                System.out.println("):");
            }
            if (null != content && this.getVerbosity() > 3) {
                System.out.println(content.substring(0, content.length() < 2000 ? content.length() : 2000));
            }
            if (this.getVerbosity() > 2) {
                System.out.println();
            }
            if (result) {
                ++this.m_pass;
                curType = TestResultType.PASS;
            } else {
                ++this.m_fail;
                curType = TestResultType.FAIL;
            }
        }
        catch (Exception e) {
            if (this.getVerbosity() > 0) {
                System.out.println("Error evaluating test elemName=" + elementName + ";testId=" + contentTest.getAttribId() + ";testName=" + contentTest.getAttribName() + ";e=" + e + ";content=" + content);
            }
            ++this.m_fail;
            curType = TestResultType.ERROR;
        }
        return curType;
    }

    private TestResultType getActionIfMissingContent(ContentConditions contentConditions) {
        TestResultType curType;
        switch (contentConditions.getActionIfMissingContent()) {
            case 0: {
                ++this.m_passOnAbsent;
                curType = TestResultType.PASS_ON_ABSENT;
                break;
            }
            case 1: {
                ++this.m_failOnAbsent;
                curType = TestResultType.FAIL_ON_ABSENT;
                break;
            }
            case 2: {
                ++this.m_ignoreOnAbsent;
                curType = TestResultType.IGNORE_ON_ABSENT;
                break;
            }
            default: {
                ++this.m_unknownOnAbsent;
                curType = TestResultType.UNKNOWN;
            }
        }
        return curType;
    }

    private Reader getReader(String filename) throws CheckerException {
        try {
            Reader reader;
            ClassLoader loader = this.getClass().getClassLoader();
            InputStream in = loader.getResourceAsStream(filename);
            if (null == in) {
                File file = new File(filename);
                reader = FileUtil.getUnicodeReader(file, true);
            } else {
                reader = FileUtil.getUnicodeReader(in, true);
            }
            return reader;
        }
        catch (IOException e) {
            throw new CheckerException(e, "tw.checker.app.loadPolicyFile", ArrayUtil.EMPTY_OBJECTS);
        }
    }

    protected ConfigCheckerListener getListener() {
        return this.m_listener;
    }

    protected void setListener(ConfigCheckerListener listener) {
        this.m_listener = listener;
    }

    protected Map<ContentTest, TestResultType> getResults() {
        return this.m_results;
    }

    protected void setResults(Map<ContentTest, TestResultType> results) {
        this.m_results = results;
    }

    public int getVerbosity() {
        return this.m_verbosity;
    }

    public void setVerbosity(int verbosity) {
        this.m_verbosity = verbosity;
    }
}

