/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.tandem6530;

public class ColorMap {
    protected byte[] defaultSource = new byte[]{112, 97, 82, 67, 52, 37, 22, 7, 120, 105, 90, 75, 60, 45, 30, 15, 112, 97, 82, 67, 52, 37, 22, 7, 120, 105, 90, 75, 60, 45, 30, 15};
    protected byte[] source = new byte[this.defaultSource.length];
    protected int[] map;

    public ColorMap() {
        this.reset();
    }

    protected int mapColor(boolean bl, int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = bl ? 8 : 0;
                break;
            }
            case 1: {
                n2 = bl ? 12 : 4;
                break;
            }
            case 2: {
                n2 = bl ? 10 : 2;
                break;
            }
            case 3: {
                n2 = bl ? 14 : 6;
                break;
            }
            case 4: {
                n2 = bl ? 9 : 1;
                break;
            }
            case 5: {
                n2 = bl ? 13 : 5;
                break;
            }
            case 6: {
                n2 = bl ? 11 : 3;
                break;
            }
            case 7: {
                n2 = bl ? 15 : 7;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    protected int mapByteToAttrib(byte by) {
        boolean bl = (by & 8) == 8;
        int n = this.mapColor(bl, by & 7);
        int n2 = this.mapColor(bl, (by & 0x70) >> 4);
        if (n == -1 || n2 == -1) {
            return 32768;
        }
        return 0x8040 | n << 16 | 0x80 | n2 << 24;
    }

    protected int[] makeMap(byte[] byArray) {
        int[] nArray = new int[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            nArray[i] = this.mapByteToAttrib(byArray[i]);
        }
        return nArray;
    }

    public void set(int n, byte[] byArray) {
        if (n < 0) {
            return;
        }
        if (n + byArray.length > this.source.length) {
            return;
        }
        System.arraycopy(byArray, 0, this.source, n, byArray.length);
        this.map = this.makeMap(this.source);
    }

    public void reset() {
        this.set(0, this.defaultSource);
    }

    public String read() {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.source.length; ++i) {
            stringBuffer.append(cArray[(this.source[i] & 0xF0) >> 4]);
            stringBuffer.append(cArray[this.source[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public int map(int n) {
        return this.map[n];
    }
}

