/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal;

import com.mindbright.terminal.TerminalClipboardHandler;
import com.mindbright.terminal.TerminalMenuHandler;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;

public class GlobalClipboard
implements TerminalClipboardHandler {
    private static GlobalClipboard globalClipboard = null;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private Vector menuHandlers = new Vector();
    private boolean selectionAvailable = false;
    private Clipboard jvmClipboard;

    private GlobalClipboard() {
    }

    public static synchronized GlobalClipboard getClipboardHandler() {
        return GlobalClipboard.getClipboardHandler(null);
    }

    public static synchronized GlobalClipboard getClipboardHandler(TerminalMenuHandler terminalMenuHandler) {
        if (globalClipboard == null) {
            globalClipboard = new GlobalClipboard();
        }
        globalClipboard.addMenuHandler(terminalMenuHandler);
        return globalClipboard;
    }

    public void addMenuHandler(TerminalMenuHandler terminalMenuHandler) {
        if (terminalMenuHandler != null && !this.menuHandlers.contains(terminalMenuHandler)) {
            this.menuHandlers.addElement(terminalMenuHandler);
        }
    }

    public void removeMenuHandler(TerminalMenuHandler terminalMenuHandler) {
        if (this.menuHandlers.contains(terminalMenuHandler)) {
            this.menuHandlers.removeElement(terminalMenuHandler);
        }
    }

    public void setSelection(String string) {
        Clipboard clipboard = this.getClipboard();
        Clipboard clipboard2 = this.getSystemSelection();
        if (string == null) {
            string = "";
        }
        StringSelection stringSelection = new StringSelection(string);
        if (clipboard != null) {
            clipboard.setContents(stringSelection, stringSelection);
        }
        if (clipboard2 != null) {
            clipboard2.setContents(stringSelection, stringSelection);
        }
        if (clipboard != null || clipboard2 != null) {
            this.selectionAvailable(true);
        }
    }

    public String getSelection() {
        String string = null;
        Clipboard clipboard = this.getSystemSelection();
        if (clipboard == null) {
            clipboard = this.getClipboard();
        }
        if (clipboard == null) {
            return string;
        }
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                try {
                    this.toolkit.beep();
                }
                catch (Throwable throwable) {}
            }
        } else {
            try {
                this.toolkit.beep();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return string;
    }

    public void clearSelection() {
        this.selectionAvailable(false);
    }

    private void selectionAvailable(boolean bl) {
        this.selectionAvailable = bl;
        Enumeration enumeration = this.menuHandlers.elements();
        while (enumeration.hasMoreElements()) {
            ((TerminalMenuHandler)enumeration.nextElement()).updateSelection(this.selectionAvailable);
        }
    }

    private synchronized Clipboard getClipboard() {
        Clipboard clipboard;
        if (this.jvmClipboard == null) {
            try {
                clipboard = this.toolkit.getSystemClipboard();
            }
            catch (Throwable throwable) {
                clipboard = this.jvmClipboard = new Clipboard("MindTerm-local-clipboard");
            }
        } else {
            clipboard = this.jvmClipboard;
        }
        return clipboard;
    }

    private synchronized Clipboard getSystemSelection() {
        Clipboard clipboard = null;
        try {
            Class<?> clazz = this.toolkit.getClass();
            Method method = clazz.getMethod("getSystemSelection", new Class[0]);
            clipboard = (Clipboard)method.invoke((Object)this.toolkit, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return clipboard;
    }
}

