/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.ssh;

import com.mindbright.ssh.SSHCompressionException;
import com.mindbright.ssh.SSHPduInputStream;
import com.mindbright.ssh.SSHPduOutputStream;

public abstract class SSHCompressor {
    public static final int COMPRESS_MODE = 1;
    public static final int UNCOMPRESS_MODE = 2;

    public static SSHCompressor getInstance(String string, int n, int n2) throws SSHCompressionException {
        if ("zlib".equals(string)) {
            try {
                Class<?> clazz = Class.forName("com.mindbright.ssh.SSHCompressorZLib");
                SSHCompressor sSHCompressor = (SSHCompressor)clazz.newInstance();
                sSHCompressor.init(n, n2);
                return sSHCompressor;
            }
            catch (Exception exception) {
                throw new SSHCompressionException(exception.getMessage());
            }
        }
        return null;
    }

    public abstract void init(int var1, int var2);

    public abstract void compress(SSHPduOutputStream var1) throws SSHCompressionException;

    public abstract void uncompress(SSHPduInputStream var1) throws SSHCompressionException;

    public abstract long numOfCompressedBytes();

    public abstract long numOfUncompressedBytes();
}

