/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.security.cipher;

import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.security.cipher.BlockCipher;

public final class Rijndael
extends BlockCipher {
    private int[][] Ke;
    private int[][] Kd;
    private int ROUNDS;
    private static final int BLOCK_SIZE = 16;
    private static final int BC = 4;
    private static final int[] alog;
    private static final int[] log;
    private static final byte[] S;
    private static final byte[] Si;
    private static final int[] T1;
    private static final int[] T2;
    private static final int[] T3;
    private static final int[] T4;
    private static final int[] T5;
    private static final int[] T6;
    private static final int[] T7;
    private static final int[] T8;
    private static final int[] U1;
    private static final int[] U2;
    private static final int[] U3;
    private static final int[] U4;
    private static final byte[] rcon;

    public int getBlockSize() {
        return 16;
    }

    public synchronized void initializeKey(byte[] byArray) throws InvalidKeyException {
        int n;
        if (byArray == null) {
            throw new InvalidKeyException("Empty key");
        }
        if (byArray.length != 16 && byArray.length != 24 && byArray.length != 32) {
            throw new InvalidKeyException("Incorrect key length");
        }
        this.ROUNDS = Rijndael.getRounds(byArray.length, 16);
        this.Ke = new int[this.ROUNDS + 1][4];
        this.Kd = new int[this.ROUNDS + 1][4];
        int n2 = (this.ROUNDS + 1) * 4;
        int n3 = byArray.length / 4;
        int[] nArray = new int[n3];
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            nArray[n4++] = (byArray[n5++] & 0xFF) << 24 | (byArray[n5++] & 0xFF) << 16 | (byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF;
        }
        int n6 = 0;
        for (n5 = 0; n5 < n3 && n6 < n2; ++n5, ++n6) {
            this.Ke[n6 / 4][n6 % 4] = nArray[n5];
            this.Kd[this.ROUNDS - n6 / 4][n6 % 4] = nArray[n5];
        }
        int n7 = 0;
        while (n6 < n2) {
            n = nArray[n3 - 1];
            nArray[0] = nArray[0] ^ ((S[n >>> 16 & 0xFF] & 0xFF) << 24 ^ (S[n >>> 8 & 0xFF] & 0xFF) << 16 ^ (S[n & 0xFF] & 0xFF) << 8 ^ S[n >>> 24 & 0xFF] & 0xFF ^ (rcon[n7++] & 0xFF) << 24);
            if (n3 != 8) {
                n4 = 1;
                n5 = 0;
                while (n4 < n3) {
                    int n8 = n4++;
                    nArray[n8] = nArray[n8] ^ nArray[n5++];
                }
            } else {
                n4 = 1;
                n5 = 0;
                while (n4 < n3 / 2) {
                    int n9 = n4++;
                    nArray[n9] = nArray[n9] ^ nArray[n5++];
                }
                n = nArray[n3 / 2 - 1];
                int n10 = n3 / 2;
                nArray[n10] = nArray[n10] ^ (S[n & 0xFF] & 0xFF ^ (S[n >>> 8 & 0xFF] & 0xFF) << 8 ^ (S[n >>> 16 & 0xFF] & 0xFF) << 16 ^ (S[n >>> 24 & 0xFF] & 0xFF) << 24);
                n5 = n3 / 2;
                n4 = n5 + 1;
                while (n4 < n3) {
                    int n11 = n4++;
                    nArray[n11] = nArray[n11] ^ nArray[n5++];
                }
            }
            for (n5 = 0; n5 < n3 && n6 < n2; ++n5, ++n6) {
                this.Ke[n6 / 4][n6 % 4] = nArray[n5];
                this.Kd[this.ROUNDS - n6 / 4][n6 % 4] = nArray[n5];
            }
        }
        for (int i = 1; i < this.ROUNDS; ++i) {
            for (n5 = 0; n5 < 4; ++n5) {
                n = this.Kd[i][n5];
                this.Kd[i][n5] = U1[n >>> 24 & 0xFF] ^ U2[n >>> 16 & 0xFF] ^ U3[n >>> 8 & 0xFF] ^ U4[n & 0xFF];
            }
        }
    }

    public void blockEncrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3;
        int[] nArray = this.Ke[0];
        int n4 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[0];
        int n5 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[1];
        int n6 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[2];
        int n7 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[3];
        for (n3 = 1; n3 < this.ROUNDS; ++n3) {
            nArray = this.Ke[n3];
            int n8 = T1[n4 >>> 24 & 0xFF] ^ T2[n5 >>> 16 & 0xFF] ^ T3[n6 >>> 8 & 0xFF] ^ T4[n7 & 0xFF] ^ nArray[0];
            int n9 = T1[n5 >>> 24 & 0xFF] ^ T2[n6 >>> 16 & 0xFF] ^ T3[n7 >>> 8 & 0xFF] ^ T4[n4 & 0xFF] ^ nArray[1];
            int n10 = T1[n6 >>> 24 & 0xFF] ^ T2[n7 >>> 16 & 0xFF] ^ T3[n4 >>> 8 & 0xFF] ^ T4[n5 & 0xFF] ^ nArray[2];
            int n11 = T1[n7 >>> 24 & 0xFF] ^ T2[n4 >>> 16 & 0xFF] ^ T3[n5 >>> 8 & 0xFF] ^ T4[n6 & 0xFF] ^ nArray[3];
            n4 = n8;
            n5 = n9;
            n6 = n10;
            n7 = n11;
        }
        nArray = this.Ke[this.ROUNDS];
        n3 = nArray[0];
        byArray2[n2 + 0] = (byte)(S[n4 >>> 24 & 0xFF] ^ n3 >>> 24);
        byArray2[n2 + 1] = (byte)(S[n5 >>> 16 & 0xFF] ^ n3 >>> 16);
        byArray2[n2 + 2] = (byte)(S[n6 >>> 8 & 0xFF] ^ n3 >>> 8);
        byArray2[n2 + 3] = (byte)(S[n7 & 0xFF] ^ n3);
        n3 = nArray[1];
        byArray2[n2 + 4] = (byte)(S[n5 >>> 24 & 0xFF] ^ n3 >>> 24);
        byArray2[n2 + 5] = (byte)(S[n6 >>> 16 & 0xFF] ^ n3 >>> 16);
        byArray2[n2 + 6] = (byte)(S[n7 >>> 8 & 0xFF] ^ n3 >>> 8);
        byArray2[n2 + 7] = (byte)(S[n4 & 0xFF] ^ n3);
        n3 = nArray[2];
        byArray2[n2 + 8] = (byte)(S[n6 >>> 24 & 0xFF] ^ n3 >>> 24);
        byArray2[n2 + 9] = (byte)(S[n7 >>> 16 & 0xFF] ^ n3 >>> 16);
        byArray2[n2 + 10] = (byte)(S[n4 >>> 8 & 0xFF] ^ n3 >>> 8);
        byArray2[n2 + 11] = (byte)(S[n5 & 0xFF] ^ n3);
        n3 = nArray[3];
        byArray2[n2 + 12] = (byte)(S[n7 >>> 24 & 0xFF] ^ n3 >>> 24);
        byArray2[n2 + 13] = (byte)(S[n4 >>> 16 & 0xFF] ^ n3 >>> 16);
        byArray2[n2 + 14] = (byte)(S[n5 >>> 8 & 0xFF] ^ n3 >>> 8);
        byArray2[n2 + 15] = (byte)(S[n6 & 0xFF] ^ n3);
    }

    public void blockDecrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3;
        int[] nArray = this.Kd[0];
        int n4 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[0];
        int n5 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[1];
        int n6 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[2];
        int n7 = ((byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[3];
        for (n3 = 1; n3 < this.ROUNDS; ++n3) {
            nArray = this.Kd[n3];
            int n8 = T5[n4 >>> 24 & 0xFF] ^ T6[n7 >>> 16 & 0xFF] ^ T7[n6 >>> 8 & 0xFF] ^ T8[n5 & 0xFF] ^ nArray[0];
            int n9 = T5[n5 >>> 24 & 0xFF] ^ T6[n4 >>> 16 & 0xFF] ^ T7[n7 >>> 8 & 0xFF] ^ T8[n6 & 0xFF] ^ nArray[1];
            int n10 = T5[n6 >>> 24 & 0xFF] ^ T6[n5 >>> 16 & 0xFF] ^ T7[n4 >>> 8 & 0xFF] ^ T8[n7 & 0xFF] ^ nArray[2];
            int n11 = T5[n7 >>> 24 & 0xFF] ^ T6[n6 >>> 16 & 0xFF] ^ T7[n5 >>> 8 & 0xFF] ^ T8[n4 & 0xFF] ^ nArray[3];
            n4 = n8;
            n5 = n9;
            n6 = n10;
            n7 = n11;
        }
        nArray = this.Kd[this.ROUNDS];
        n3 = nArray[0];
        byArray2[n2 + 0] = (byte)(Si[n4 >>> 24 & 0xFF] ^ n3 >>> 24);
        byArray2[n2 + 1] = (byte)(Si[n7 >>> 16 & 0xFF] ^ n3 >>> 16);
        byArray2[n2 + 2] = (byte)(Si[n6 >>> 8 & 0xFF] ^ n3 >>> 8);
        byArray2[n2 + 3] = (byte)(Si[n5 & 0xFF] ^ n3);
        n3 = nArray[1];
        byArray2[n2 + 4] = (byte)(Si[n5 >>> 24 & 0xFF] ^ n3 >>> 24);
        byArray2[n2 + 5] = (byte)(Si[n4 >>> 16 & 0xFF] ^ n3 >>> 16);
        byArray2[n2 + 6] = (byte)(Si[n7 >>> 8 & 0xFF] ^ n3 >>> 8);
        byArray2[n2 + 7] = (byte)(Si[n6 & 0xFF] ^ n3);
        n3 = nArray[2];
        byArray2[n2 + 8] = (byte)(Si[n6 >>> 24 & 0xFF] ^ n3 >>> 24);
        byArray2[n2 + 9] = (byte)(Si[n5 >>> 16 & 0xFF] ^ n3 >>> 16);
        byArray2[n2 + 10] = (byte)(Si[n4 >>> 8 & 0xFF] ^ n3 >>> 8);
        byArray2[n2 + 11] = (byte)(Si[n7 & 0xFF] ^ n3);
        n3 = nArray[3];
        byArray2[n2 + 12] = (byte)(Si[n7 >>> 24 & 0xFF] ^ n3 >>> 24);
        byArray2[n2 + 13] = (byte)(Si[n6 >>> 16 & 0xFF] ^ n3 >>> 16);
        byArray2[n2 + 14] = (byte)(Si[n5 >>> 8 & 0xFF] ^ n3 >>> 8);
        byArray2[n2 + 15] = (byte)(Si[n4 & 0xFF] ^ n3);
    }

    public static int getRounds(int n, int n2) {
        switch (n) {
            case 16: {
                return n2 == 16 ? 10 : (n2 == 24 ? 12 : 14);
            }
            case 24: {
                return n2 != 32 ? 12 : 14;
            }
        }
        return 14;
    }

    private static final int mul(int n, int n2) {
        return n != 0 && n2 != 0 ? alog[(log[n & 0xFF] + log[n2 & 0xFF]) % 255] : 0;
    }

    private static final int mul4(int n, byte[] byArray) {
        if (n == 0) {
            return 0;
        }
        n = log[n & 0xFF];
        int n2 = byArray[0] != 0 ? alog[(n + log[byArray[0] & 0xFF]) % 255] & 0xFF : 0;
        int n3 = byArray[1] != 0 ? alog[(n + log[byArray[1] & 0xFF]) % 255] & 0xFF : 0;
        int n4 = byArray[2] != 0 ? alog[(n + log[byArray[2] & 0xFF]) % 255] & 0xFF : 0;
        int n5 = byArray[3] != 0 ? alog[(n + log[byArray[3] & 0xFF]) % 255] & 0xFF : 0;
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    static {
        int n;
        int n2;
        alog = new int[256];
        log = new int[256];
        S = new byte[256];
        Si = new byte[256];
        T1 = new int[256];
        T2 = new int[256];
        T3 = new int[256];
        T4 = new int[256];
        T5 = new int[256];
        T6 = new int[256];
        T7 = new int[256];
        T8 = new int[256];
        U1 = new int[256];
        U2 = new int[256];
        U3 = new int[256];
        U4 = new int[256];
        rcon = new byte[30];
        int n3 = 283;
        int n4 = 0;
        Rijndael.alog[0] = 1;
        for (n2 = 1; n2 < 256; ++n2) {
            n4 = alog[n2 - 1] << 1 ^ alog[n2 - 1];
            if ((n4 & 0x100) != 0) {
                n4 ^= n3;
            }
            Rijndael.alog[n2] = n4;
        }
        for (n2 = 1; n2 < 255; ++n2) {
            Rijndael.log[Rijndael.alog[n2]] = n2;
        }
        byte[][] byArrayArray = new byte[][]{{1, 1, 1, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 1, 1, 1, 1}, {1, 1, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 0, 0, 0, 1, 1}, {1, 1, 1, 1, 0, 0, 0, 1}};
        byte[] byArray = new byte[]{0, 1, 1, 0, 0, 0, 1, 1};
        byte[][] byArray2 = new byte[256][8];
        byArray2[1][7] = 1;
        for (n2 = 2; n2 < 256; ++n2) {
            n4 = alog[255 - log[n2]];
            for (n = 0; n < 8; ++n) {
                byArray2[n2][n] = (byte)(n4 >>> 7 - n & 1);
            }
        }
        byte[][] byArray3 = new byte[256][8];
        for (n2 = 0; n2 < 256; ++n2) {
            for (n = 0; n < 8; ++n) {
                byArray3[n2][n] = byArray[n];
                for (n4 = 0; n4 < 8; ++n4) {
                    byte[] byArray4 = byArray3[n2];
                    int n5 = n;
                    byArray4[n5] = (byte)(byArray4[n5] ^ byArrayArray[n][n4] * byArray2[n2][n4]);
                }
            }
        }
        for (n2 = 0; n2 < 256; ++n2) {
            Rijndael.S[n2] = (byte)(byArray3[n2][0] << 7);
            for (n = 1; n < 8; ++n) {
                int n6 = n2;
                S[n6] = (byte)(S[n6] ^ byArray3[n2][n] << 7 - n);
            }
            Rijndael.Si[Rijndael.S[n2] & 0xFF] = (byte)n2;
        }
        byte[][] byArrayArray2 = new byte[][]{{2, 1, 1, 3}, {3, 2, 1, 1}, {1, 3, 2, 1}, {1, 1, 3, 2}};
        byte[][] byArray5 = new byte[4][8];
        for (n2 = 0; n2 < 4; ++n2) {
            for (n4 = 0; n4 < 4; ++n4) {
                byArray5[n2][n4] = byArrayArray2[n2][n4];
            }
            byArray5[n2][n2 + 4] = 1;
        }
        byte[][] byArray6 = new byte[4][4];
        for (n2 = 0; n2 < 4; ++n2) {
            byte by = byArray5[n2][n2];
            if (by == 0) {
                for (n = n2 + 1; byArray5[n][n2] == 0 && n < 4; ++n) {
                }
                if (n == 4) {
                    throw new RuntimeException("G matrix is not invertible");
                }
                for (n4 = 0; n4 < 8; ++n4) {
                    byte by2 = byArray5[n2][n4];
                    byArray5[n2][n4] = byArray5[n][n4];
                    byArray5[n][n4] = by2;
                }
                by = byArray5[n2][n2];
            }
            for (n4 = 0; n4 < 8; ++n4) {
                if (byArray5[n2][n4] == 0) continue;
                byArray5[n2][n4] = (byte)alog[(255 + log[byArray5[n2][n4] & 0xFF] - log[by & 0xFF]) % 255];
            }
            for (n = 0; n < 4; ++n) {
                if (n2 == n) continue;
                for (n4 = n2 + 1; n4 < 8; ++n4) {
                    byte[] byArray7 = byArray5[n];
                    int n7 = n4;
                    byArray7[n7] = (byte)(byArray7[n7] ^ Rijndael.mul(byArray5[n2][n4], byArray5[n][n2]));
                }
                byArray5[n][n2] = 0;
            }
        }
        for (n2 = 0; n2 < 4; ++n2) {
            for (n4 = 0; n4 < 4; ++n4) {
                byArray6[n2][n4] = byArray5[n2][n4 + 4];
            }
        }
        for (n = 0; n < 256; ++n) {
            byte by = S[n];
            Rijndael.T1[n] = Rijndael.mul4(by, byArrayArray2[0]);
            Rijndael.T2[n] = Rijndael.mul4(by, byArrayArray2[1]);
            Rijndael.T3[n] = Rijndael.mul4(by, byArrayArray2[2]);
            Rijndael.T4[n] = Rijndael.mul4(by, byArrayArray2[3]);
            by = Si[n];
            Rijndael.T5[n] = Rijndael.mul4(by, byArray6[0]);
            Rijndael.T6[n] = Rijndael.mul4(by, byArray6[1]);
            Rijndael.T7[n] = Rijndael.mul4(by, byArray6[2]);
            Rijndael.T8[n] = Rijndael.mul4(by, byArray6[3]);
            Rijndael.U1[n] = Rijndael.mul4(n, byArray6[0]);
            Rijndael.U2[n] = Rijndael.mul4(n, byArray6[1]);
            Rijndael.U3[n] = Rijndael.mul4(n, byArray6[2]);
            Rijndael.U4[n] = Rijndael.mul4(n, byArray6[3]);
        }
        Rijndael.rcon[0] = 1;
        int n8 = 1;
        n = 1;
        while (n < 30) {
            int n9 = n++;
            n8 = Rijndael.mul(2, n8);
            Rijndael.rcon[n9] = (byte)n8;
        }
    }
}

