/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.jce.crypto;

import com.mindbright.jca.security.InvalidKeyException;
import com.mindbright.jca.security.Key;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.NoSuchProviderException;
import com.mindbright.jca.security.Provider;
import com.mindbright.jca.security.ProviderLookup;
import com.mindbright.jca.security.spec.AlgorithmParameterSpec;
import com.mindbright.jce.crypto.CipherSpi;

public class Cipher {
    public static final int DECRYPT_MODE = 1;
    public static final int ENCRYPT_MODE = 2;
    CipherSpi cipherSpi;
    Provider provider;
    String transformation;
    String algorithm;

    protected Cipher(CipherSpi cipherSpi, Provider provider, String string) {
        this.cipherSpi = cipherSpi;
        this.provider = provider;
        this.transformation = string;
        int n = string.indexOf(47);
        this.algorithm = n != -1 ? string.substring(0, n) : string;
    }

    public final byte[] doFinal(byte[] byArray) {
        return this.doFinal(byArray, 0, byArray.length);
    }

    public final byte[] doFinal(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[this.getOutputSize(n2)];
        this.doFinal(byArray, n, n2, byArray2, 0);
        return byArray2;
    }

    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2) {
        return this.doFinal(byArray, n, n2, byArray2, 0);
    }

    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        return this.cipherSpi.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getBlockSize() {
        return this.cipherSpi.engineGetBlockSize();
    }

    public static final Cipher getInstance(String string) throws NoSuchAlgorithmException {
        try {
            String string2 = ProviderLookup.findImplementingProvider("Cipher", string);
            return Cipher.getInstance(string, string2);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new Error("Error in Cipher: " + noSuchProviderException);
        }
    }

    public static final Cipher getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        ProviderLookup providerLookup = ProviderLookup.getImplementation("Cipher", string, string2);
        CipherSpi cipherSpi = (CipherSpi)providerLookup.getImpl();
        int n = string.indexOf(47);
        if (n != -1) {
            int n2 = string.indexOf(47, n + 1);
            if (n2 != -1) {
                cipherSpi.engineSetPadding(string.substring(n2 + 1));
            } else {
                n2 = string.length();
            }
            cipherSpi.engineSetMode(string.substring(n + 1, n2));
        }
        return new Cipher(cipherSpi, providerLookup.getProvider(), string);
    }

    public final byte[] getIV() {
        return this.cipherSpi.engineGetIV();
    }

    public final int getOutputSize(int n) {
        return this.cipherSpi.engineGetOutputSize(n);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(int n, Key key) throws InvalidKeyException {
        this.init(n, key, null);
    }

    public final void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException {
        this.cipherSpi.engineInit(n, key, algorithmParameterSpec, null);
    }
}

