/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.jca.security;

import com.mindbright.jca.security.Key;
import com.mindbright.jca.security.KeyStoreException;
import com.mindbright.jca.security.KeyStoreSpi;
import com.mindbright.jca.security.NoSuchAlgorithmException;
import com.mindbright.jca.security.NoSuchProviderException;
import com.mindbright.jca.security.Provider;
import com.mindbright.jca.security.ProviderLookup;
import com.mindbright.jca.security.UnrecoverableKeyException;
import com.mindbright.jca.security.cert.Certificate;
import com.mindbright.jca.security.cert.CertificateException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;

public class KeyStore {
    private KeyStoreSpi keyStoreSpi;
    private Provider provider;
    private String type;

    protected KeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String string) {
        this.keyStoreSpi = keyStoreSpi;
        this.provider = provider;
        this.type = string;
    }

    public static KeyStore getInstance(String string) throws KeyStoreException {
        try {
            String string2 = ProviderLookup.findImplementingProvider("KeyStore", string);
            return KeyStore.getInstance(string, string2);
        }
        catch (Exception exception) {
            throw new KeyStoreException("KeyStore " + string + " not found");
        }
    }

    public static KeyStore getInstance(String string, String string2) throws KeyStoreException, NoSuchProviderException {
        try {
            ProviderLookup providerLookup = ProviderLookup.getImplementation("KeyStore", string, string2);
            return new KeyStore((KeyStoreSpi)providerLookup.getImpl(), providerLookup.getProvider(), string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException("KeyStore " + string + " not found in provider " + string2);
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }

    public final Key getKey(String string, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.keyStoreSpi.engineGetKey(string, cArray);
    }

    public final Certificate[] getCertificateChain(String string) throws KeyStoreException {
        return this.keyStoreSpi.engineGetCertificateChain(string);
    }

    public final Certificate getCertificate(String string) throws KeyStoreException {
        return this.keyStoreSpi.engineGetCertificate(string);
    }

    public final Date getCreationDate(String string) throws KeyStoreException {
        return this.keyStoreSpi.engineGetCreationDate(string);
    }

    public final void setKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        this.keyStoreSpi.engineSetKeyEntry(string, key, cArray, certificateArray);
    }

    public final void setKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        this.keyStoreSpi.engineSetKeyEntry(string, byArray, certificateArray);
    }

    public final void setCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        this.keyStoreSpi.engineSetCertificateEntry(string, certificate);
    }

    public final void deleteEntry(String string) throws KeyStoreException {
        this.keyStoreSpi.engineDeleteEntry(string);
    }

    public final Enumeration aliases() throws KeyStoreException {
        return this.keyStoreSpi.engineAliases();
    }

    public final boolean containsAlias(String string) throws KeyStoreException {
        return this.keyStoreSpi.engineContainsAlias(string);
    }

    public final int size() throws KeyStoreException {
        return this.keyStoreSpi.engineSize();
    }

    public final boolean isKeyEntry(String string) throws KeyStoreException {
        return this.keyStoreSpi.engineIsKeyEntry(string);
    }

    public final boolean isCertificateEntry(String string) throws KeyStoreException {
        return this.keyStoreSpi.engineIsCertificateEntry(string);
    }

    public final String getCertificateAlias(Certificate certificate) throws KeyStoreException {
        return this.keyStoreSpi.engineGetCertificateAlias(certificate);
    }

    public final void store(OutputStream outputStream, char[] cArray) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreSpi.engineStore(outputStream, cArray);
    }

    public final void load(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.keyStoreSpi.engineLoad(inputStream, cArray);
    }

    public static final String getDefaultType() {
        return "PKCS12";
    }
}

