/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core;

import com.tripwire.common.util.ArrayUtil;
import com.tripwire.common.util.ResourceManager;
import com.tripwire.common.util.StringUtil;
import com.tripwire.space.core.LocalizableString;
import com.tripwire.space.core.LoggableException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpaceException
extends Exception
implements LoggableException {
    public static boolean HIDE_TRACE = Boolean.getBoolean("com.tripwire.space.core.hidetrace");
    protected String m_addendum;
    private String m_logMessage;
    private boolean m_shouldPrintStackTrace = true;
    private boolean m_shouldDisplayStackTrace = true;
    private String m_key;

    public SpaceException(Throwable cause, String key, Object[] args) {
        super(ResourceManager.getInstance().getSafeString(key, args == null ? ArrayUtil.EMPTY_OBJECTS : args), cause);
        this.setKey(key);
    }

    public SpaceException(Throwable cause) {
        super(cause);
    }

    public SpaceException(String message, Throwable cause) {
        super(message, cause);
    }

    public SpaceException(String key, Object[] args) {
        this(key, args, true);
    }

    public SpaceException(String key, Object[] args, boolean shouldPrintStackTrace) {
        super(ResourceManager.getInstance().getSafeString(key, args == null ? ArrayUtil.EMPTY_OBJECTS : args));
        this.m_shouldPrintStackTrace = shouldPrintStackTrace;
        this.setKey(key);
    }

    public SpaceException(String key) {
        super(ResourceManager.getInstance().getSafeString(key));
        this.setKey(key);
    }

    public String getMessage() {
        if (this.m_addendum == null) {
            return super.getMessage();
        }
        return super.getMessage() + '\n' + this.getAddendum();
    }

    protected String getBasicMessage() {
        return super.getMessage();
    }

    public String getAddendum() {
        return this.m_addendum;
    }

    public void setAddendum(String addendum) {
        this.m_addendum = addendum;
    }

    public String getStackTraceAsString() {
        return SpaceException.getStackTraceAsString(this);
    }

    public void store() {
        SpaceException.store(this);
    }

    public boolean shouldPrintStackTrace() {
        return this.m_shouldPrintStackTrace;
    }

    public void setShouldPrintStackTrace(boolean shouldPrintStackTrace) {
        this.m_shouldPrintStackTrace = shouldPrintStackTrace;
    }

    public void setShouldDisplayStackTrace(boolean shouldDisplayStackTrace) {
        this.m_shouldDisplayStackTrace = shouldDisplayStackTrace;
    }

    public final String getLogMessage() {
        if (this.m_logMessage == null) {
            this.m_logMessage = this.createLogMessage();
        }
        return this.m_logMessage;
    }

    protected String createLogMessage() {
        return SpaceException.createLogMessage(this, this.m_shouldDisplayStackTrace);
    }

    public void addSummaryMessage(StringBuffer sb, Set dupeSet) {
        SpaceException.createMessageSummary(this, sb, dupeSet);
    }

    public static void createMessageSummary(Throwable t, StringBuffer sb, Set dupeSet) {
        if (t instanceof SpaceException && t.getCause() instanceof SpaceException) {
            ((SpaceException)t.getCause()).addSummaryMessage(sb, dupeSet);
        } else {
            String localizedMessage = t.getLocalizedMessage();
            String toAppend = "";
            if (localizedMessage != null) {
                String regex = "((?:^.*$\\r?\\n?)+?)(^\\s+at\\s+[^(]+\\([^:]+(\\:\\d+\\)){0,1}$\\r?\\n?)((?:^.*$\\r?\\n?)+?)";
                Pattern pattern = Pattern.compile("((?:^.*$\\r?\\n?)+?)(^\\s+at\\s+[^(]+\\([^:]+(\\:\\d+\\)){0,1}$\\r?\\n?)((?:^.*$\\r?\\n?)+?)", 8);
                Matcher matcher = pattern.matcher(localizedMessage);
                toAppend = matcher.matches() ? (matcher.group(1) != null ? matcher.group(1) : StringUtil.firstLine(localizedMessage)) : StringUtil.head(localizedMessage, 15);
            }
            if (!dupeSet.contains(toAppend)) {
                sb.append(toAppend);
                sb.append("\n");
                dupeSet.add(toAppend);
            }
        }
    }

    public static String createLogMessage(Throwable e, boolean includeStackTrace) {
        if (includeStackTrace) {
            return new LocalizableString("exception.loggedMessage", new Object[]{e.getMessage(), SpaceException.getStackTraceAsString(e)}).toString();
        }
        return e.getMessage();
    }

    public static String getStackTraceAsString(Throwable e) {
        StringWriter swriter = new StringWriter();
        PrintWriter pwriter = new PrintWriter(swriter);
        e.printStackTrace(pwriter);
        return swriter.toString();
    }

    public static void store(LoggableException e) {
        String message;
        if (e.shouldPrintStackTrace() && !HIDE_TRACE) {
            e.printStackTrace();
        }
        if ((message = e.getLogMessage()) != null) {
            System.err.println(message);
        }
    }

    public static SpaceException asSpaceException(Throwable e) {
        return e instanceof SpaceException ? (SpaceException)e : new SpaceException(e);
    }

    public String getKey() {
        return this.m_key;
    }

    public void setKey(String key) {
        this.m_key = key;
    }
}

