/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.ipdevice;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import com.mindbright.ssh.SSHConsoleClient;
import com.mindbright.ssh.SSHPropertyHandler;
import com.mindbright.ssh.SSHVersionSpySocket;
import com.mindbright.ssh2.SSH2Connection;
import com.mindbright.ssh2.SSH2ConsoleRemote;
import com.mindbright.sshcommon.SSHConsoleRemote;
import com.tripwire.common.time.Time;
import com.tripwire.common.util.Dbg;
import com.tripwire.ipdevice.ExternalChannel;
import com.tripwire.ipdevice.NetworkDeviceException;
import com.tripwire.ipdevice.ResourceLoader;
import com.tripwire.ipdevice.SSH2Connector;
import com.tripwire.ipdevice.SSHFailureReporter;
import com.tripwire.ipdevice.SSHInteractor;
import com.tripwire.ipdevice.SSHParameters;
import com.tripwire.ipdevice.SSHUtil;
import com.tripwire.ipdevice.SSHVersion;
import com.tripwire.space.core.SpaceException;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Properties;

public class SSHChannel
extends ExternalChannel {
    private static final PooledExecutor sm_pool;
    private Properties m_properties;
    private StringBuffer m_buffer;
    private ArrayList m_lineArray;
    private SSHConsoleRemote m_remoteConsole;
    private SSHVersion m_version;
    private OutputStreamWriter m_stdinWriter;
    private SSH2Connector m_connector;
    private long m_timeOut;
    private long m_lastTime;
    private int m_failureCode;
    private String m_failureMessage;
    private Socket m_socket;

    private static PooledExecutor createPool() {
        PooledExecutor pool = new PooledExecutor();
        pool.setKeepAliveTime(120000L);
        pool.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable command) {
                Thread aThread = new Thread(command);
                aThread.setDaemon(true);
                return aThread;
            }
        });
        return pool;
    }

    public SSHChannel(Properties parameters) {
        this(parameters, SSHVersion.DONT_CARE);
    }

    public SSHChannel(Properties parameters, String version) {
        this(parameters, SSHVersion.getVersion(version));
    }

    public SSHChannel(Properties parameters, SSHVersion version) {
        if (parameters == null || version == null) {
            throw new IllegalArgumentException();
        }
        this.m_version = version;
        this.m_properties = parameters;
        this.m_timeOut = 1000L;
    }

    public SSHChannel(String host, String userName, String password) {
        this(host, userName, password, SSHVersion.DONT_CARE);
    }

    public SSHChannel(String host, String userName, String password, String version) {
        this(host, userName, password, SSHVersion.getVersion(version));
    }

    public SSHChannel(String host, String userName, String password, SSHVersion version) {
        if (host == null || userName == null || password == null || version == null) {
            throw new IllegalArgumentException();
        }
        this.m_version = version;
        this.m_properties = new Properties();
        this.m_properties.setProperty("server", host);
        this.m_properties.setProperty("username", userName);
        this.m_properties.setProperty("password", password);
        this.m_timeOut = 1000L;
    }

    public SSH2Connector getConnector() {
        return this.m_connector;
    }

    public void close() throws SpaceException {
        this.closeSocket();
        try {
            if (this.m_stdinWriter != null) {
                this.m_stdinWriter.close();
            }
            if (this.m_remoteConsole != null) {
                this.m_remoteConsole.close();
            }
            if (this.m_connector != null) {
                this.m_connector.close();
            }
            this.m_remoteConsole = null;
            this.m_stdinWriter = null;
            this.m_connector = null;
        }
        catch (IOException e) {
            throw new SpaceException(e);
        }
    }

    public void connect() throws SpaceException {
        if (this.m_remoteConsole == null) {
            this.m_buffer = new StringBuffer();
            this.m_lineArray = new ArrayList();
            this.m_lastTime = 0L;
            this.m_failureCode = 0;
            if (this.m_version == SSHVersion.SSH1) {
                this.initializeSSH1();
            } else if (this.m_version == SSHVersion.SSH2) {
                this.initializeSSH2();
            } else {
                if (this.m_version != SSHVersion.DONT_CARE) {
                    throw new IllegalArgumentException();
                }
                this.initializeAnySSH();
            }
            this.m_remoteConsole.shell();
            SSHUtil.interpretError(this.m_failureCode, this.m_failureMessage, this.m_properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] read() throws SpaceException {
        this.pause();
        ArrayList arrayList = this.m_lineArray;
        synchronized (arrayList) {
            this.m_lineArray.clear();
            String line = this.extractLine();
            while (line != null) {
                this.m_lineArray.add(line);
                line = this.extractLine();
            }
            int size = this.m_lineArray.size();
            String[] lines = new String[size];
            for (int i = 0; i < size; ++i) {
                lines[i] = (String)this.m_lineArray.get(i);
                this.traceRead(lines[i]);
            }
            return lines;
        }
    }

    public String readLine() throws SpaceException {
        this.pause();
        String line = this.extractLine();
        this.traceRead(line);
        return line == null ? "" : line;
    }

    public void setReadTimeout(long milliseconds) {
        this.m_timeOut = milliseconds;
    }

    public void write(String s, boolean hideText) throws SpaceException {
        try {
            if (this.m_stdinWriter == null) {
                throw new EOFException();
            }
            this.traceWrite(hideText ? "<secret>" : s);
            this.m_stdinWriter.write(s);
            this.m_stdinWriter.flush();
        }
        catch (IOException e) {
            throw new SpaceException(e);
        }
    }

    public void writeLine(String s, boolean hideText) throws IOException {
        if (this.m_stdinWriter == null) {
            throw new EOFException();
        }
        this.traceWrite(hideText ? "<secret>" : s);
        this.m_stdinWriter.write(s);
        this.m_stdinWriter.write(10);
        this.m_stdinWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(char[] buffer, int length) {
        StringBuffer stringBuffer = this.m_buffer;
        synchronized (stringBuffer) {
            this.m_buffer.append(buffer, 0, length);
            this.m_lastTime = Time.now();
            this.m_buffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(String str) {
        StringBuffer stringBuffer = this.m_buffer;
        synchronized (stringBuffer) {
            this.m_buffer.append(str);
            this.m_lastTime = Time.now();
            this.m_buffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractLine() {
        String line = null;
        boolean complete = false;
        int lastBufferLength = -1;
        while (!complete) {
            StringBuffer stringBuffer = this.m_buffer;
            synchronized (stringBuffer) {
                int bufferLength = this.m_buffer.length();
                if (bufferLength == 0 || bufferLength == lastBufferLength) {
                    complete = true;
                }
                lastBufferLength = bufferLength;
                if (bufferLength > 0) {
                    char ch;
                    int end;
                    for (end = 0; end < bufferLength; ++end) {
                        ch = this.m_buffer.charAt(end);
                        if (ch != '\n' && ch != '\r') continue;
                        complete = true;
                        break;
                    }
                    if (complete) {
                        line = this.m_buffer.substring(0, end);
                        while (end < bufferLength && ((ch = this.m_buffer.charAt(end)) == '\n' || ch == '\r')) {
                            ++end;
                        }
                        this.m_buffer.delete(0, end);
                    }
                }
                if (!complete) {
                    try {
                        this.m_buffer.wait(this.m_timeOut);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }
        return line;
    }

    Socket getSocket() {
        return this.m_socket;
    }

    void closeSocket() {
        Socket tmp = this.m_socket;
        this.m_socket = null;
        if (tmp != null) {
            try {
                tmp.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean test(String desc, String input, String[] expected) {
        this.m_buffer = new StringBuffer();
        this.m_lineArray = new ArrayList();
        this.append(input);
        try {
            String[] actual = this.read();
            if (!SSHChannel.arrayCompare(expected, actual)) {
                int i;
                Dbg.trace(desc + " failed");
                Dbg.trace("Expected");
                for (i = 0; i < expected.length; ++i) {
                    Dbg.trace("|" + expected[i] + "|");
                }
                Dbg.trace("Actual");
                for (i = 0; i < actual.length; ++i) {
                    Dbg.trace("|" + actual[i] + "|");
                }
                return false;
            }
        }
        catch (Exception e) {
            Dbg.trace(e);
        }
        Dbg.trace(desc + " passed");
        return true;
    }

    public static boolean arrayCompare(String[] a, String[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    public static int getPort(Properties parameters) {
        int port;
        try {
            port = Integer.parseInt(parameters.getProperty("port"));
        }
        catch (NumberFormatException e) {
            port = 22;
        }
        return port;
    }

    static SSHVersionSpySocket createSpySocket(Properties parameters) throws IOException {
        int port = SSHChannel.getPort(parameters);
        Socket baseSocket = new Socket(parameters.getProperty("server"), port);
        SSHUtil.setUpSocketParams(baseSocket);
        return new SSHVersionSpySocket(baseSocket);
    }

    private void initializeAnySSH() throws SpaceException {
        int port = SSHChannel.getPort(this.m_properties);
        this.checkPrivateKeyFile(this.m_properties);
        try {
            SSHVersionSpySocket spySocket = SSHChannel.createSpySocket(this.m_properties);
            this.m_socket = spySocket;
            int majorVer = spySocket.getMajorVersion();
            if (majorVer == 2) {
                Dbg.trace("Detected SSH version 2");
                this.m_connector = new SSH2Connector(this.m_properties, spySocket);
                this.m_remoteConsole = new TWSSH2ConsoleRemote(this.m_connector.getConnection());
            } else {
                Dbg.trace("Detected SSH version 1");
                if (!this.m_properties.containsKey("ssh1-cipher")) {
                    this.m_properties.setProperty("ssh1-cipher", SSHParameters.SSH1_CIPHER_3DES);
                }
                SSHPropertyHandler sshProps = new SSHPropertyHandler(this.m_properties, false);
                SSHInteractor interactor = new SSHInteractor();
                sshProps.setInteractor(interactor);
                this.m_remoteConsole = new TWSSHConsoleClient(sshProps);
                interactor.setFailureReporter((SSHFailureReporter)((Object)this.m_remoteConsole));
            }
        }
        catch (UnknownHostException e1) {
            throw new NetworkDeviceException("ssh.error.unknownHost", new Object[]{this.m_properties.getProperty("server")});
        }
        catch (IOException e1) {
            throw new NetworkDeviceException("ssh.error.connectionRefused", new Object[]{this.m_properties.getProperty("server"), new Integer(port)});
        }
    }

    private void checkPrivateKeyFile(Properties properties) throws SpaceException {
        File f;
        String fileName = properties.getProperty("private-key");
        if (fileName != null && !(f = new File(fileName)).exists()) {
            throw new NetworkDeviceException("ssh.error.MissingKeyFile", new Object[]{fileName, properties.getProperty("server")});
        }
    }

    private void initializeSSH1() throws SpaceException {
        this.checkPrivateKeyFile(this.m_properties);
        try {
            this.m_socket = SSHChannel.createSpySocket(this.m_properties);
            if (!this.m_properties.containsKey("ssh1-cipher")) {
                this.m_properties.setProperty("ssh1-cipher", SSHParameters.SSH1_CIPHER_3DES);
            }
            SSHPropertyHandler sshProps = new SSHPropertyHandler(this.m_properties, false);
            SSHInteractor interactor = new SSHInteractor();
            sshProps.setInteractor(interactor);
            this.m_remoteConsole = new TWSSHConsoleClient(sshProps);
            interactor.setFailureReporter((SSHFailureReporter)((Object)this.m_remoteConsole));
        }
        catch (UnknownHostException e1) {
            throw new NetworkDeviceException("ssh.error.unknownHost", new Object[]{this.m_properties.getProperty("server")});
        }
        catch (IOException e1) {
            int port = SSHChannel.getPort(this.m_properties);
            throw new NetworkDeviceException("ssh.error.connectionRefused", new Object[]{this.m_properties.getProperty("server"), new Integer(port)});
        }
    }

    private void initializeSSH2() throws SpaceException {
        this.checkPrivateKeyFile(this.m_properties);
        try {
            this.m_socket = SSHChannel.createSpySocket(this.m_properties);
            this.m_connector = new SSH2Connector(this.m_properties, this.m_socket);
            this.m_remoteConsole = new TWSSH2ConsoleRemote(this.m_connector.getConnection());
        }
        catch (UnknownHostException e1) {
            throw new NetworkDeviceException("ssh.error.unknownHost", new Object[]{this.m_properties.getProperty("server")});
        }
        catch (IOException e1) {
            int port = SSHChannel.getPort(this.m_properties);
            throw new NetworkDeviceException("ssh.error.connectionRefused", new Object[]{this.m_properties.getProperty("server"), new Integer(port)});
        }
    }

    private void pause() {
        long now = Time.now();
        if (this.m_lastTime == 0L) {
            this.m_lastTime = now;
        }
        long timeToQuit = this.m_lastTime + this.m_timeOut;
        while (now < timeToQuit) {
            try {
                if (SSHUtil.DEBUG_ON) {
                    Dbg.trace("Sleeping for " + (int)(timeToQuit - now) + " milliseconds");
                }
                Thread.sleep(timeToQuit - now);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            now = Time.now();
        }
        this.m_lastTime = now;
    }

    public static void main(String[] args) {
        SSHChannel channel = new SSHChannel(new Properties());
        channel.test("test 1", "Line1\r\nLine2\rLine3\nLine4\r\n", new String[]{"Line1", "Line2", "Line3", "Line4"});
        channel.test("test 2", "Line1\r\r\nLine2\rLine3\nLine4\r\n", new String[]{"Line1", "Line2", "Line3", "Line4"});
        channel.test("test 3", "Line1\n\r\nLine2\rLine3\nLine4\r\n", new String[]{"Line1", "Line2", "Line3", "Line4"});
        channel.test("test 4", "Line1\r\n\nLine2\rLine3\nLine4\r\n", new String[]{"Line1", "Line2", "Line3", "Line4"});
        channel.test("test 5", "Line1\r\n\r\nLine2\rLine3\nLine4\r\n", new String[]{"Line1", "Line2", "Line3", "Line4"});
        channel.test("test 6", "Line1\n\r\n\rLine2\rLine3\nLine4\r\n", new String[]{"Line1", "Line2", "Line3", "Line4"});
    }

    static {
        ResourceLoader.load();
        sm_pool = SSHChannel.createPool();
    }

    private class TWSSH2ConsoleRemote
    extends SSH2ConsoleRemote {
        public TWSSH2ConsoleRemote(SSH2Connection connection) {
            super(connection);
        }

        public void close() {
            try {
                this.session.getStdErr().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.close();
        }

        public boolean shell() {
            if (!super.shell(true)) {
                return false;
            }
            try {
                SSHChannel.this.m_stdinWriter = new OutputStreamWriter(this.session.getStdIn(), "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                if (SSHUtil.DEBUG_ON) {
                    Dbg.trace(e);
                }
                return false;
            }
            this.session.enableStdErr();
            try {
                sm_pool.execute(new InputThread("stdout", this.session.getStdOut()));
                sm_pool.execute(new InputThread("stderr", this.session.getStdErr()));
            }
            catch (InterruptedException e) {
                Dbg.trace(e);
            }
            return true;
        }
    }

    class TWSSHConsoleClient
    extends SSHConsoleClient
    implements SSHFailureReporter {
        public TWSSHConsoleClient(SSHPropertyHandler props) throws IOException {
            super(props.getProperty("server"), 22, props, props.getInteractor());
            try {
                this.sshPort = Integer.parseInt(props.getProperty("port"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void close() {
            super.close();
            this.client.waitForExit(0L);
        }

        public void reportFailure(int failureCode, String msg) {
            if (failureCode < 0 || failureCode > 5) {
                throw new IllegalArgumentException();
            }
            SSHChannel.this.m_failureCode = failureCode;
            SSHChannel.this.m_failureMessage = msg;
        }

        public boolean shell() {
            try {
                if (!super.shell()) {
                    return false;
                }
            }
            catch (NullPointerException npe) {
                this.reportFailure(2, "Fatal error in mindterm.");
            }
            try {
                SSHChannel.this.m_stdinWriter = new OutputStreamWriter(this.getStdIn(), "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                if (SSHUtil.DEBUG_ON) {
                    Dbg.trace(e);
                }
                return false;
            }
            try {
                sm_pool.execute(new InputThread("stdout", SSHChannel.this.m_remoteConsole.getStdOut()));
            }
            catch (InterruptedException e) {
                Dbg.trace(e);
            }
            return true;
        }

        public void stderrWriteString(byte[] str) {
            try {
                String msg = new String(str, "US-ASCII");
                SSHChannel.this.append(msg);
                SSHChannel.this.traceRead(msg);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            super.stderrWriteString(str);
        }

        public Socket getProxyConnection() throws IOException {
            return SSHChannel.this.getSocket();
        }

        public boolean wantPTY() {
            return true;
        }
    }

    private class InputThread
    implements Runnable {
        private static final int BUFFER_SIZE = 1024;
        private InputStreamReader m_reader;
        private String m_name;

        public InputThread(String name, InputStream stream) {
            this.setName(name);
            if (stream == null) {
                throw new IllegalArgumentException();
            }
            try {
                this.m_reader = new InputStreamReader(stream, "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Careful with the character encoding!");
            }
        }

        public void run() {
            block5: {
                if (SSHUtil.DEBUG_ON) {
                    Dbg.trace("Input thread " + this.getName() + " is starting.");
                }
                try {
                    int numRead = 0;
                    char[] buffer = new char[1024];
                    while ((numRead = this.m_reader.read(buffer, 0, 1024)) != -1) {
                        SSHChannel.this.append(buffer, numRead);
                        if (!SSHUtil.DEBUG_ON) continue;
                        Dbg.trace("Received " + numRead + " characters from " + this.getName() + ": |" + new String(buffer, 0, numRead) + "|");
                    }
                }
                catch (Exception e) {
                    if (!SSHUtil.DEBUG_ON) break block5;
                    Dbg.trace(e);
                }
            }
            if (SSHUtil.DEBUG_ON) {
                Dbg.trace("Input thread " + this.getName() + " is exiting.");
            }
        }

        public String getName() {
            return this.m_name;
        }

        public void setName(String name) {
            this.m_name = name;
        }
    }
}

