/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor.soap;

import com.tripwire.checker.accessor.soap.AbstractVmwareCollector;
import com.vmware.vim25.PhysicalNic;
import com.vmware.vim25.PhysicalNicLinkInfo;
import com.vmware.vim25.PhysicalNicSpec;

public class PhysicalNicCollector
extends AbstractVmwareCollector {
    public PhysicalNicCollector() {
        super(PhysicalNic.class);
    }

    public void collect(Object o, String parentKey) {
        String curKey = parentKey + ".PhysicalNic";
        if (o instanceof PhysicalNic) {
            String pci;
            String key;
            String driver;
            PhysicalNic physicalNic = (PhysicalNic)o;
            String device = physicalNic.getDevice();
            if (null != device) {
                this.doPut(curKey + ".Device", device);
            }
            if (null != (driver = physicalNic.getDriver())) {
                this.doPut(curKey + ".Driver", driver);
            }
            if (null != (key = physicalNic.getKey())) {
                this.doPut(curKey + ".Key", key);
            }
            PhysicalNicLinkInfo linkSpeed = physicalNic.getLinkSpeed();
            this.doCollect(linkSpeed, curKey);
            String mac = physicalNic.getMac();
            if (null != mac) {
                this.doPut(curKey + ".Mac", mac);
            }
            if (null != (pci = physicalNic.getPci())) {
                this.doPut(curKey + ".Pci", pci);
            }
            PhysicalNicSpec spec = physicalNic.getSpec();
            this.doCollect(spec, curKey);
            PhysicalNicLinkInfo[] validLinkSpecifications = physicalNic.getValidLinkSpecification();
            if (null != validLinkSpecifications) {
                for (int ii = 0; ii < validLinkSpecifications.length; ++ii) {
                    if (null == validLinkSpecifications[ii]) continue;
                    this.doCollect(validLinkSpecifications[ii], curKey + ".ValidLinkSpecification" + ii);
                }
            }
            boolean wakeOnLanSupported = physicalNic.isWakeOnLanSupported();
            this.doPut(curKey + ".WakeOnLanSupported", "" + wakeOnLanSupported);
        }
    }
}

