/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor.soap;

import com.tripwire.checker.accessor.soap.AbstractVmwareCollector;
import com.vmware.vim25.HostVirtualSwitch;
import com.vmware.vim25.HostVirtualSwitchSpec;

public class HostVirtualSwitchCollector
extends AbstractVmwareCollector {
    public HostVirtualSwitchCollector() {
        super(HostVirtualSwitch.class);
    }

    public void collect(Object o, String parentKey) {
        String curKey = parentKey + ".HostVirtualSwitch";
        if (o instanceof HostVirtualSwitch) {
            String[] portgroups;
            String name;
            Integer mtu;
            HostVirtualSwitch hostVirtualSwitch = (HostVirtualSwitch)o;
            String key = hostVirtualSwitch.getKey();
            if (null != key) {
                this.doPut(curKey + ".Key", key);
            }
            if (null != (mtu = hostVirtualSwitch.getMtu())) {
                this.doPut(curKey + ".Mtu", "" + mtu);
            }
            if (null != (name = hostVirtualSwitch.getName())) {
                this.doPut(curKey + ".Name", name);
            }
            int numPorts = hostVirtualSwitch.getNumPorts();
            this.doPut(curKey + ".NumPorts", "" + numPorts);
            int numPortsAvailable = hostVirtualSwitch.getNumPortsAvailable();
            this.doPut(curKey + ".NumPortsAvailable", "" + numPortsAvailable);
            String[] pnics = hostVirtualSwitch.getPnic();
            if (null != pnics) {
                for (int ii = 0; ii < pnics.length; ++ii) {
                    if (null == pnics[ii]) continue;
                    this.doPut(curKey + ".Pnics" + ii, "" + pnics[ii]);
                }
            }
            if (null != (portgroups = hostVirtualSwitch.getPortgroup())) {
                for (int ii = 0; ii < portgroups.length; ++ii) {
                    if (null == portgroups[ii]) continue;
                    this.doPut(curKey + ".Portgroup" + ii, "" + portgroups[ii]);
                }
            }
            HostVirtualSwitchSpec spec = hostVirtualSwitch.getSpec();
            this.doCollect(spec, curKey);
        }
    }
}

