/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.checker.accessor;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementCache {
    final ConcurrentHashMap<String, String> m_cache = new ConcurrentHashMap();
    private static final ElementCache sm_singleton = new ElementCache();

    private ElementCache() {
    }

    public void clear() {
        this.m_cache.clear();
    }

    public Set<String> keySet() {
        return this.m_cache.keySet();
    }

    public boolean containsKey(String key) {
        return this.m_cache.containsKey(key);
    }

    public String get(String key) {
        return this.m_cache.get(key);
    }

    public void put(String key, String value) {
        String prev = this.m_cache.putIfAbsent(key, value);
        if (null != prev && value.length() > prev.length()) {
            this.m_cache.put(key, value);
        }
    }

    public String getInfo(boolean detail, boolean content) {
        StringBuffer buf = new StringBuffer();
        TreeSet sortedKeys = new TreeSet();
        sortedKeys.addAll(this.m_cache.keySet());
        Iterator iterator = sortedKeys.iterator();
        long totCount = 0L;
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = this.m_cache.get(key);
            if (detail) {
                buf.append(null == value ? -1 : value.length());
                buf.append("\t");
                buf.append(key);
                buf.append("\n");
            }
            if (content) {
                buf.append("Content:\n");
                buf.append(value);
                buf.append("\n\n\n");
            }
            totCount += null == value ? 0L : (long)value.length();
        }
        buf.append(this.m_cache.size());
        buf.append(" keys, total length=");
        buf.append(totCount);
        buf.append("\n");
        return buf.toString();
    }

    public static ElementCache getInstance() {
        return sm_singleton;
    }
}

