/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.tandem6530;

import com.mindbright.terminal.DisplayView;
import com.mindbright.terminal.tandem6530.DataType;
import com.mindbright.terminal.tandem6530.FieldAttributes;
import com.mindbright.terminal.tandem6530.FixedFieldAttributeTable;
import com.mindbright.terminal.tandem6530.ModeBase;
import com.mindbright.terminal.tandem6530.Position;
import com.mindbright.terminal.tandem6530.ProtectedScreen;
import com.mindbright.terminal.tandem6530.Terminal6530Callback;
import com.mindbright.terminal.tandem6530.VariableFieldAttributeTable;

public class ProtectBlockMode
extends ModeBase {
    protected static final int ROWS = 24;
    protected static final int COLS = 80;
    protected Terminal6530Callback termCallback;
    protected ProtectedScreen[] pages;
    protected int displayPage;
    protected int selectedPage;
    protected DataType dataTypeTable;
    protected VariableFieldAttributeTable varTable;
    protected FixedFieldAttributeTable fixedTable;
    protected DisplayView display;
    protected boolean insertMode = false;
    protected int MAX_PAGES;
    protected int selectTopRow;
    protected int selectTopCol;
    protected int selectBottomRow;
    protected int selectBottomCol;
    protected boolean hasSelection;
    protected int selectClickRow = -1;
    protected boolean selectClickState;

    public ProtectBlockMode(Terminal6530Callback terminal6530Callback, int n) {
        this.termCallback = terminal6530Callback;
        this.MAX_PAGES = n;
        this.dataTypeTable = new DataType();
        this.varTable = new VariableFieldAttributeTable();
        this.fixedTable = new FixedFieldAttributeTable();
        this.pages = new ProtectedScreen[this.MAX_PAGES];
        for (int i = 0; i < this.MAX_PAGES; ++i) {
            this.pages[i] = new ProtectedScreen(this, 24, 80, this.dataTypeTable);
        }
        this.displayPage = 0;
        this.selectedPage = 0;
    }

    public void updateCursorPosition(ProtectedScreen protectedScreen, Position position) {
        if (this.display != null && protectedScreen == this.pages[this.displayPage]) {
            this.display.setCursorPosition(position.getRow(), position.getCol());
        }
    }

    public void updateDirty() {
        if (this.display != null) {
            this.display.updateDirtyArea(0, 0, 23, 79);
        }
    }

    public void updateDirty(ProtectedScreen protectedScreen, Position position, Position position2) {
        if (this.display != null && protectedScreen == this.pages[this.displayPage]) {
            this.display.updateDirtyArea(position.getRow(), position.getCol(), position2.getRow() + 1, position2.getCol() + 1);
        }
    }

    public void keyHandler(char c, int n, int n2) {
        boolean bl = false;
        switch (n) {
            case 8: {
                if (n2 != 0) break;
                this.pages[this.displayPage].doBackspace();
                if (this.insertMode) {
                    this.pages[this.displayPage].doDeleteCharacter(true);
                }
                bl = true;
                break;
            }
            case 9: {
                if ((n2 & 1) == 1) {
                    this.pages[this.displayPage].doBackTab();
                    bl = true;
                    break;
                }
                this.pages[this.displayPage].doHTab();
                bl = true;
                break;
            }
            case 10: {
                if ((n2 & 1) == 1) {
                    this.pages[this.displayPage].doHTab();
                    bl = true;
                    break;
                }
                if ((n2 & 2) == 2) {
                    this.pages[this.displayPage].cursorToLastCharInField();
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                this.pages[this.displayPage].cursorToNextUnprotected(1);
                bl = true;
                break;
            }
            case 36: {
                if ((n2 & 2) == 2) {
                    this.pages[this.displayPage].doCursorHomeDown();
                    this.pages[this.displayPage].cursorToLastCharInField();
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                this.pages[this.displayPage].doCursorHome();
                bl = true;
                break;
            }
            case 35: {
                if (n2 != 0) break;
                this.pages[this.displayPage].doCursorHomeDown();
                bl = true;
                break;
            }
            case 155: {
                if ((n2 & 8) == 8) {
                    this.insertMode = true;
                    bl = true;
                    break;
                }
                if (n2 != 0) break;
                if (this.insertMode) {
                    this.insertMode = false;
                } else {
                    this.pages[this.displayPage].doInsertCharacter(true);
                }
                bl = true;
                break;
            }
            case 127: {
                if (n2 != 0) break;
                this.pages[this.displayPage].doDeleteCharacter(true);
                bl = true;
                break;
            }
            case 39: {
                if (n2 != 0) break;
                this.pages[this.displayPage].doCursorRight();
                bl = true;
                break;
            }
            case 37: {
                if (n2 != 0) break;
                this.doBackspace();
                bl = true;
                break;
            }
            case 38: {
                if (n2 != 0) break;
                this.pages[this.displayPage].doCursorUp();
                bl = true;
                break;
            }
            case 40: {
                if (n2 != 0) break;
                this.pages[this.displayPage].doCursorDown();
                bl = true;
                break;
            }
            case 50: {
                if ((n2 & 9) == 9) {
                    this.pages[this.displayPage].doEraseToEndOfPageOrMemory(true);
                    bl = true;
                    break;
                }
                if ((n2 & 8) != 8) break;
                this.pages[this.displayPage].doEraseToEndOfLineOrField(true);
                bl = true;
                break;
            }
        }
        if (bl) {
            this.repaint();
            return;
        }
        if (c == '\uffff') {
            return;
        }
        if (!this.pages[this.displayPage].cursorWrite(c)) {
            this.termCallback.error("INVALID DATA");
            return;
        }
        this.repaint();
    }

    public void hostChar(char c) {
        this.pages[this.selectedPage].bufferWrite(c);
        this.repaint();
    }

    public int getBufferRows() {
        return 24;
    }

    public void setDisplay(DisplayView displayView) {
        this.display = displayView;
        if (displayView != null) {
            displayView.setVisTop(0);
            displayView.updateScrollbarValues();
        }
        this.repaint();
    }

    public void switchReset() {
        for (int i = 0; i < this.MAX_PAGES; ++i) {
            this.pages[i].reset();
        }
        this.insertMode = false;
        this.dataTypeTable.reset();
        this.doSelectPage(1);
        this.doDisplayPage(1);
        this.repaint();
    }

    public void doBackspace() {
        this.pages[this.selectedPage].doBackspace();
        this.repaint();
    }

    public void doHTab() {
        this.pages[this.selectedPage].doHTab();
        this.repaint();
    }

    public void doLineFeed() {
        this.pages[this.selectedPage].doLineFeed();
        this.repaint();
    }

    public void doCarriageReturn() {
        this.pages[this.selectedPage].doCarriageReturn();
        this.repaint();
    }

    public void doSetBufferAddress(int n, int n2) {
        this.pages[this.selectedPage].setBufferAddress(n - 1, n2 - 1);
    }

    public void doSetCursorAddress(boolean bl, int n, int n2) {
        if (n >= 24 || n2 >= 80) {
            return;
        }
        int n3 = bl ? this.displayPage : this.selectedPage;
        this.pages[n3].setCursorAddress(n - 1, n2 - 1);
        this.repaint();
    }

    public void doDefineFieldAttribute(int n, int n2, boolean bl, int n3) {
        FieldAttributes fieldAttributes = bl ? this.fixedTable.get(n3) : this.varTable.get(n3);
        if (fieldAttributes == null) {
            this.termCallback.error("Table index " + n3 + " was bad");
            return;
        }
        this.pages[this.selectedPage].setBufferAddress(n - 1, n2 - 1);
        this.pages[this.selectedPage].addField(fieldAttributes);
        this.pages[this.selectedPage].updateCursorPosition();
        this.repaint();
    }

    public void doStartField(FieldAttributes fieldAttributes) {
        this.pages[this.selectedPage].addField(fieldAttributes);
        this.pages[this.selectedPage].updateCursorPosition();
        this.repaint();
    }

    public void doStartFieldExtended(FieldAttributes fieldAttributes) {
        this.pages[this.selectedPage].addField(fieldAttributes);
        this.pages[this.selectedPage].updateCursorPosition();
        this.repaint();
    }

    public void doBackTab() {
        this.pages[this.selectedPage].doBackTab();
        this.repaint();
    }

    public void doSetMaxPageNumber(int n) {
    }

    public void doDefineDataTypeTable(int n, byte[] byArray) {
        this.dataTypeTable.set(n, byArray);
    }

    public void doResetVariableTable() {
        this.varTable.reset();
    }

    public void doDefineVariableTable(int n, FieldAttributes[] fieldAttributesArray) {
        this.varTable.set(n, fieldAttributesArray);
    }

    public void doCursorUp() {
        this.pages[this.selectedPage].doCursorUp();
        this.repaint();
    }

    public void doCursorRight() {
        this.pages[this.selectedPage].doCursorRight();
        this.repaint();
    }

    public void doCursorHomeDown() {
        this.pages[this.selectedPage].doCursorHomeDown();
        this.repaint();
    }

    public void doCursorHome() {
        this.pages[this.selectedPage].doCursorHome();
        this.repaint();
    }

    public void doClearMemoryToSpaces(int n, int n2, int n3, int n4) {
        this.pages[this.selectedPage].doClearMemoryToSpaces(n2 - 1, n2 - 1, n3 - 1, n4 - 1);
        this.repaint();
    }

    public void doEraseToEndOfPageOrMemory() {
        this.pages[this.selectedPage].doEraseToEndOfPageOrMemory(false);
        this.repaint();
    }

    public void doEraseToEndOfLineOrField() {
        this.pages[this.selectedPage].doEraseToEndOfLineOrField(false);
        this.repaint();
    }

    public String doReadWithAddress(int n, int n2, int n3, int n4) {
        Position position = new Position(n - 1, n2 - 1);
        Position position2 = new Position(n3 - 1, n4 - 1);
        return this.pages[this.selectedPage].readWithAddress(position, position2);
    }

    public String doReadWithAddressAll(int n, int n2, int n3, int n4) {
        Position position = new Position(n - 1, n2 - 1);
        Position position2 = new Position(n3 - 1, n4 - 1);
        return this.pages[this.selectedPage].readWithAddressAll(position, position2);
    }

    public void doInsertLine() {
        this.pages[this.selectedPage].doInsertLine();
        this.repaint();
    }

    public void doDeleteLine() {
        this.pages[this.selectedPage].doDeleteLine();
        this.repaint();
    }

    public void doInsertCharacter() {
        this.pages[this.selectedPage].doInsertCharacter(false);
        this.repaint();
    }

    public void doDeleteCharacter() {
        this.pages[this.selectedPage].doDeleteCharacter(false);
        this.repaint();
    }

    public void doResetMoifiedDataTags() {
        this.pages[this.selectedPage].doResetMoifiedDataTags();
    }

    public String doReadWholePageOrBuffer() {
        return this.pages[this.selectedPage].readWholePageOrBuffer();
    }

    public void doDisplayPage(int n) {
        if (n >= 1 && n <= this.MAX_PAGES) {
            this.displayPage = n - 1;
            this.pages[this.displayPage].updateCursorPosition();
            this.updateDirty();
            this.repaint();
        }
    }

    public void doSelectPage(int n) {
        if (n >= 1 && n <= this.MAX_PAGES) {
            this.selectedPage = n - 1;
        }
    }

    public int getRow() {
        return this.pages[this.selectedPage].getCursorAddress().getRow() + 1;
    }

    public int getCol() {
        return this.pages[this.selectedPage].getCursorAddress().getCol() + 1;
    }

    public int getPage() {
        return this.selectedPage + 1;
    }

    protected void repaint() {
        if (this.display != null) {
            this.display.repaint();
        }
    }

    public char[] getChars(int n, int n2) {
        return this.pages[this.displayPage].getChars(n + n2);
    }

    public int[] getAttribs(int n, int n2) {
        return this.pages[this.displayPage].getAttribs(n + n2);
    }

    public void doClickSelect(int n, int n2, String string) {
        int n3;
        int n4;
        if (this.selectClickRow == n && this.selectClickState) {
            n4 = 0;
            n3 = 79;
        } else {
            int n5;
            char[] cArray = this.pages[this.displayPage].getChars(n);
            for (n5 = n2; n5 >= 0 && string.indexOf(cArray[n5]) == -1; --n5) {
            }
            n4 = n5 + 1;
            for (n5 = n2; n5 < 80 && string.indexOf(cArray[n5]) == -1; ++n5) {
            }
            n3 = n5 - 1;
            n4 = n4 > n2 ? n2 : n4;
            n3 = n3 < n2 ? n2 : n3;
        }
        this.selectClickState = !this.selectClickState;
        this.selectClickRow = n;
        this.setSelection(n, n4, n, n3);
    }

    public void resetClickSelect() {
        this.selectClickRow = -1;
        this.selectClickState = false;
    }

    public void setSelection(int n, int n2, int n3, int n4) {
        if (n < n3) {
            this.selectTopRow = n;
            this.selectTopCol = n2;
            this.selectBottomRow = n3;
            this.selectBottomCol = n4;
        } else if (n == n3) {
            this.selectTopRow = this.selectBottomRow = n;
            if (n2 < n4) {
                this.selectTopCol = n2;
                this.selectBottomCol = n4;
            } else {
                this.selectTopCol = n4;
                this.selectBottomCol = n2;
            }
        } else {
            this.selectTopRow = n3;
            this.selectTopCol = n4;
            this.selectBottomRow = n;
            this.selectBottomCol = n2;
        }
        this.hasSelection = true;
        if (this.display != null) {
            this.display.resetSelection();
            this.display.setSelection(this.selectTopRow, this.selectTopCol, this.selectBottomRow, this.selectBottomCol);
        }
    }

    public void selectAll() {
        this.setSelection(0, 0, 23, 79);
    }

    public void resetSelection() {
        this.hasSelection = false;
        if (this.display != null) {
            this.display.resetSelection();
        }
    }

    public String getSelection(String string) {
        if (!this.hasSelection) {
            return null;
        }
        if (string == null) {
            string = "\r";
        }
        String string2 = this.getContents(this.selectTopRow, this.selectTopCol, this.selectBottomRow, this.selectBottomCol, string);
        return string2;
    }

    protected void getLine(StringBuffer stringBuffer, int n, int n2, int n3, String string) {
        char[] cArray = this.pages[this.displayPage].getChars(n);
        for (int i = n2; i < n3; ++i) {
            stringBuffer.append(cArray[i]);
        }
        stringBuffer.append(string);
    }

    protected String getContents(int n, int n2, int n3, int n4, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n == n3) {
            this.getLine(stringBuffer, n, n2, n4 + 1, string);
        } else {
            this.getLine(stringBuffer, n, n2, 80, string);
            for (int i = n + 1; i < n3; ++i) {
                this.getLine(stringBuffer, i, 0, 80, string);
            }
            this.getLine(stringBuffer, n3, 0, n4, string);
        }
        return stringBuffer.toString();
    }
}

