/*
 * Decompiled with CFR 0.152.
 */
package com.mindbright.terminal.tandem6530;

import com.mindbright.terminal.tandem6530.ParseException;

public class FieldAttributes {
    public static final char DEFAULT_VIDEO = ' ';
    public static final char DEFAULT_DATA_ATTRIB = 'P';
    public static final char DEFAULT_EXT_DATA_ATTRIB = '@';
    private char videoAttrib;
    private boolean mdt;
    private boolean autoTab;
    private boolean protect;
    private int dataType;
    private boolean upshift;
    private boolean keyboard;
    private boolean aid;

    public FieldAttributes() {
        try {
            this.setAttribs(' ', 'P', '@');
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public FieldAttributes(char c, char c2) throws ParseException {
        this.setAttribs(c, c2, '@');
    }

    public FieldAttributes(char c, char c2, char c3) throws ParseException {
        this.setAttribs(c, c2, c3);
    }

    protected void setAttribs(char c, char c2, char c3) throws ParseException {
        if (' ' > c || '?' < c) {
            throw new ParseException("Invalid video attribute");
        }
        this.videoAttrib = c;
        this.protect = (c2 & 0x20) != 0;
        this.autoTab = (c2 & 0x10) == 0;
        this.mdt = (c2 & '\u0001') != 0;
        this.dataType = c2 >> 1 & 7;
        this.upshift = (c3 & '\u0001') != 0;
        this.keyboard = false;
        this.aid = false;
        switch (c3 >> 1 & 3) {
            case 0: {
                this.keyboard = true;
                break;
            }
            case 1: {
                this.aid = true;
                break;
            }
            case 2: {
                this.keyboard = true;
                this.aid = true;
                break;
            }
            default: {
                throw new ParseException("Invalid extended data attribute");
            }
        }
    }

    public char getVideoAttrib() {
        return this.videoAttrib;
    }

    public void setVideoAttrib(char c) {
        this.videoAttrib = c;
    }

    public boolean getMdt() {
        return this.mdt;
    }

    public void setMdt(boolean bl) {
        this.mdt = bl;
    }

    public boolean getAutoTab() {
        return this.autoTab;
    }

    public void setAutoTab(boolean bl) {
        this.autoTab = bl;
    }

    public boolean getProtect() {
        return this.protect;
    }

    public void setProtect(boolean bl) {
        this.protect = bl;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int n) {
        this.dataType = n;
    }

    public boolean getUpShift() {
        return this.upshift;
    }

    public void setUpShift(boolean bl) {
        this.upshift = bl;
    }

    public boolean getKeyboard() {
        return this.keyboard;
    }

    public boolean getAid() {
        return this.aid;
    }

    public int hashCode() {
        return this.getVideoAttrib() + this.getDataType() * 100 + (this.getMdt() ? 200 : 0) + (this.getAutoTab() ? 400 : 0) + (this.getProtect() ? 800 : 0) + (this.getUpShift() ? 1000 : 0) + (this.getKeyboard() ? 2000 : 0) + (this.getAid() ? 4000 : 0);
    }

    public boolean equals(Object object) {
        FieldAttributes fieldAttributes = (FieldAttributes)object;
        if (fieldAttributes == null) {
            return false;
        }
        return this.getVideoAttrib() == fieldAttributes.getVideoAttrib() && this.getAutoTab() == fieldAttributes.getAutoTab() && this.getMdt() == fieldAttributes.getMdt() && this.getProtect() == fieldAttributes.getProtect() && this.getDataType() == fieldAttributes.getDataType() && this.getUpShift() == fieldAttributes.getUpShift() && this.getKeyboard() == fieldAttributes.getKeyboard() && this.getAid() == fieldAttributes.getAid();
    }

    public String toString() {
        return "vid='" + this.getVideoAttrib() + "'" + " datatype=" + this.getDataType() + " autotab=" + (this.getAutoTab() ? "1" : "0") + " mdt=" + (this.getMdt() ? "1" : "0") + " protect=" + (this.getProtect() ? "1" : "0") + " upshift=" + (this.getUpShift() ? "1" : "0") + " keyboard=" + (this.getKeyboard() ? "1" : "0") + " aid=" + (this.getAid() ? "1" : "0");
    }
}

