/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TLongFunction;
import gnu.trove.TLongProcedure;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectLongIterator;
import gnu.trove.TObjectLongProcedure;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TObjectLongHashMap
extends TObjectHash
implements Serializable {
    protected transient long[] _values;

    public TObjectLongHashMap() {
    }

    public TObjectLongHashMap(int n) {
        super(n);
    }

    public TObjectLongHashMap(int n, float f) {
        super(n, f);
    }

    public TObjectLongHashMap(TObjectHashingStrategy tObjectHashingStrategy) {
        super(tObjectHashingStrategy);
    }

    public TObjectLongHashMap(int n, TObjectHashingStrategy tObjectHashingStrategy) {
        super(n, tObjectHashingStrategy);
    }

    public TObjectLongHashMap(int n, float f, TObjectHashingStrategy tObjectHashingStrategy) {
        super(n, f, tObjectHashingStrategy);
    }

    public TObjectLongIterator iterator() {
        return new TObjectLongIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new long[n2];
        return n2;
    }

    public long put(Object object, long l) {
        long l2 = 0L;
        int n = this.insertionIndex(object);
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            l2 = this._values[n];
            bl = false;
        }
        Object object2 = this._set[n];
        this._set[n] = object;
        this._values[n] = l;
        if (bl) {
            this.postInsertHook(object2 == null);
        }
        return l2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        Object[] objectArray = this._set;
        long[] lArray = this._values;
        this._set = new Object[n];
        this._values = new long[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (objectArray[n3] == null || objectArray[n3] == REMOVED) continue;
            Object object = objectArray[n3];
            int n4 = this.insertionIndex(object);
            if (n4 < 0) {
                this.throwObjectContractViolation(this._set[-n4 - 1], object);
            }
            this._set[n4] = object;
            this._values[n4] = lArray[n3];
        }
    }

    public long get(Object object) {
        int n = this.index(object);
        return n < 0 ? 0L : this._values[n];
    }

    public void clear() {
        super.clear();
        Object[] objectArray = this._set;
        long[] lArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            objectArray[n] = null;
            lArray[n] = 0L;
        }
    }

    public long remove(Object object) {
        long l = 0L;
        int n = this.index(object);
        if (n >= 0) {
            l = this._values[n];
            this.removeAt(n);
        }
        return l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TObjectLongHashMap)) {
            return false;
        }
        TObjectLongHashMap tObjectLongHashMap = (TObjectLongHashMap)object;
        if (tObjectLongHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tObjectLongHashMap));
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0L;
    }

    public long[] getValues() {
        long[] lArray = new long[this.size()];
        long[] lArray2 = this._values;
        Object[] objectArray = this._set;
        int n = lArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED) continue;
            lArray[n2++] = lArray2[n];
        }
        return lArray;
    }

    public Object[] keys() {
        Object[] objectArray = new Object[this.size()];
        Object[] objectArray2 = this._set;
        int n = objectArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (objectArray2[n] == null || objectArray2[n] == REMOVED) continue;
            objectArray[n2++] = objectArray2[n];
        }
        return objectArray;
    }

    public boolean containsValue(long l) {
        Object[] objectArray = this._set;
        long[] lArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED || l != lArray[n]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object object) {
        return this.contains(object);
    }

    public boolean forEachKey(TObjectProcedure tObjectProcedure) {
        return this.forEach(tObjectProcedure);
    }

    public boolean forEachValue(TLongProcedure tLongProcedure) {
        Object[] objectArray = this._set;
        long[] lArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED || tLongProcedure.execute(lArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectLongProcedure tObjectLongProcedure) {
        Object[] objectArray = this._set;
        long[] lArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED || tObjectLongProcedure.execute(objectArray[n], lArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TObjectLongProcedure tObjectLongProcedure) {
        boolean bl = false;
        Object[] objectArray = this._set;
        long[] lArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED || tObjectLongProcedure.execute(objectArray[n], lArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TLongFunction tLongFunction) {
        Object[] objectArray = this._set;
        long[] lArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED) continue;
            lArray[n] = tLongFunction.execute(lArray[n]);
        }
    }

    public boolean increment(Object object) {
        return this.adjustValue(object, 1L);
    }

    public boolean adjustValue(Object object, long l) {
        int n = this.index(object);
        if (n < 0) {
            return false;
        }
        int n2 = n;
        this._values[n2] = this._values[n2] + l;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            Object object = objectInputStream.readObject();
            long l = objectInputStream.readLong();
            this.put(object, l);
        }
    }

    private static final class EqProcedure
    implements TObjectLongProcedure {
        private final TObjectLongHashMap _otherMap;

        EqProcedure(TObjectLongHashMap tObjectLongHashMap) {
            this._otherMap = tObjectLongHashMap;
        }

        public final boolean execute(Object object, long l) {
            int n = this._otherMap.index(object);
            return n >= 0 && this.eq(l, this._otherMap.get(object));
        }

        private final boolean eq(long l, long l2) {
            return l == l2;
        }
    }
}

