/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TIterator;
import gnu.trove.TObjectDoubleHashMap;
import gnu.trove.TObjectHash;
import java.util.ConcurrentModificationException;

public class TObjectDoubleIterator
extends TIterator {
    private final TObjectDoubleHashMap _map;

    public TObjectDoubleIterator(TObjectDoubleHashMap tObjectDoubleHashMap) {
        super(tObjectDoubleHashMap);
        this._map = tObjectDoubleHashMap;
    }

    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] objectArray = this._map._set;
        int n = this._index;
        while (n-- > 0 && (objectArray[n] == null || objectArray[n] == TObjectHash.REMOVED)) {
        }
        return n;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public Object key() {
        return this._map._set[this._index];
    }

    public double value() {
        return this._map._values[this._index];
    }

    public double setValue(double d) {
        double d2 = this.value();
        this._map._values[this._index] = d;
        return d2;
    }
}

