/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TDoubleFunction;
import gnu.trove.TDoubleProcedure;
import gnu.trove.TObjectDoubleIterator;
import gnu.trove.TObjectDoubleProcedure;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TObjectDoubleHashMap
extends TObjectHash
implements Serializable {
    protected transient double[] _values;

    public TObjectDoubleHashMap() {
    }

    public TObjectDoubleHashMap(int n) {
        super(n);
    }

    public TObjectDoubleHashMap(int n, float f) {
        super(n, f);
    }

    public TObjectDoubleHashMap(TObjectHashingStrategy tObjectHashingStrategy) {
        super(tObjectHashingStrategy);
    }

    public TObjectDoubleHashMap(int n, TObjectHashingStrategy tObjectHashingStrategy) {
        super(n, tObjectHashingStrategy);
    }

    public TObjectDoubleHashMap(int n, float f, TObjectHashingStrategy tObjectHashingStrategy) {
        super(n, f, tObjectHashingStrategy);
    }

    public TObjectDoubleIterator iterator() {
        return new TObjectDoubleIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new double[n2];
        return n2;
    }

    public double put(Object object, double d) {
        double d2 = 0.0;
        int n = this.insertionIndex(object);
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            d2 = this._values[n];
            bl = false;
        }
        Object object2 = this._set[n];
        this._set[n] = object;
        this._values[n] = d;
        if (bl) {
            this.postInsertHook(object2 == null);
        }
        return d2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        Object[] objectArray = this._set;
        double[] dArray = this._values;
        this._set = new Object[n];
        this._values = new double[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (objectArray[n3] == null || objectArray[n3] == REMOVED) continue;
            Object object = objectArray[n3];
            int n4 = this.insertionIndex(object);
            if (n4 < 0) {
                this.throwObjectContractViolation(this._set[-n4 - 1], object);
            }
            this._set[n4] = object;
            this._values[n4] = dArray[n3];
        }
    }

    public double get(Object object) {
        int n = this.index(object);
        return n < 0 ? 0.0 : this._values[n];
    }

    public void clear() {
        super.clear();
        Object[] objectArray = this._set;
        double[] dArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            objectArray[n] = null;
            dArray[n] = 0.0;
        }
    }

    public double remove(Object object) {
        double d = 0.0;
        int n = this.index(object);
        if (n >= 0) {
            d = this._values[n];
            this.removeAt(n);
        }
        return d;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TObjectDoubleHashMap)) {
            return false;
        }
        TObjectDoubleHashMap tObjectDoubleHashMap = (TObjectDoubleHashMap)object;
        if (tObjectDoubleHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tObjectDoubleHashMap));
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0.0;
    }

    public double[] getValues() {
        double[] dArray = new double[this.size()];
        double[] dArray2 = this._values;
        Object[] objectArray = this._set;
        int n = dArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED) continue;
            dArray[n2++] = dArray2[n];
        }
        return dArray;
    }

    public Object[] keys() {
        Object[] objectArray = new Object[this.size()];
        Object[] objectArray2 = this._set;
        int n = objectArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (objectArray2[n] == null || objectArray2[n] == REMOVED) continue;
            objectArray[n2++] = objectArray2[n];
        }
        return objectArray;
    }

    public boolean containsValue(double d) {
        Object[] objectArray = this._set;
        double[] dArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED || d != dArray[n]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object object) {
        return this.contains(object);
    }

    public boolean forEachKey(TObjectProcedure tObjectProcedure) {
        return this.forEach(tObjectProcedure);
    }

    public boolean forEachValue(TDoubleProcedure tDoubleProcedure) {
        Object[] objectArray = this._set;
        double[] dArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED || tDoubleProcedure.execute(dArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectDoubleProcedure tObjectDoubleProcedure) {
        Object[] objectArray = this._set;
        double[] dArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED || tObjectDoubleProcedure.execute(objectArray[n], dArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TObjectDoubleProcedure tObjectDoubleProcedure) {
        boolean bl = false;
        Object[] objectArray = this._set;
        double[] dArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED || tObjectDoubleProcedure.execute(objectArray[n], dArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TDoubleFunction tDoubleFunction) {
        Object[] objectArray = this._set;
        double[] dArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (objectArray[n] == null || objectArray[n] == REMOVED) continue;
            dArray[n] = tDoubleFunction.execute(dArray[n]);
        }
    }

    public boolean increment(Object object) {
        return this.adjustValue(object, 1.0);
    }

    public boolean adjustValue(Object object, double d) {
        int n = this.index(object);
        if (n < 0) {
            return false;
        }
        int n2 = n;
        this._values[n2] = this._values[n2] + d;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            Object object = objectInputStream.readObject();
            double d = objectInputStream.readDouble();
            this.put(object, d);
        }
    }

    private static final class EqProcedure
    implements TObjectDoubleProcedure {
        private final TObjectDoubleHashMap _otherMap;

        EqProcedure(TObjectDoubleHashMap tObjectDoubleHashMap) {
            this._otherMap = tObjectDoubleHashMap;
        }

        public final boolean execute(Object object, double d) {
            int n = this._otherMap.index(object);
            return n >= 0 && this.eq(d, this._otherMap.get(object));
        }

        private final boolean eq(double d, double d2) {
            return d == d2;
        }
    }
}

