/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TLongFunction;
import gnu.trove.TLongHash;
import gnu.trove.TLongHashingStrategy;
import gnu.trove.TLongLongIterator;
import gnu.trove.TLongLongProcedure;
import gnu.trove.TLongProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TLongLongHashMap
extends TLongHash
implements Serializable {
    protected transient long[] _values;

    public TLongLongHashMap() {
    }

    public TLongLongHashMap(int n) {
        super(n);
    }

    public TLongLongHashMap(int n, float f) {
        super(n, f);
    }

    public TLongLongHashMap(TLongHashingStrategy tLongHashingStrategy) {
        super(tLongHashingStrategy);
    }

    public TLongLongHashMap(int n, TLongHashingStrategy tLongHashingStrategy) {
        super(n, tLongHashingStrategy);
    }

    public TLongLongHashMap(int n, float f, TLongHashingStrategy tLongHashingStrategy) {
        super(n, f, tLongHashingStrategy);
    }

    public Object clone() {
        TLongLongHashMap tLongLongHashMap = (TLongLongHashMap)super.clone();
        tLongLongHashMap._values = (long[])this._values.clone();
        return tLongLongHashMap;
    }

    public TLongLongIterator iterator() {
        return new TLongLongIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new long[n2];
        return n2;
    }

    public long put(long l, long l2) {
        long l3 = 0L;
        int n = this.insertionIndex(l);
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            l3 = this._values[n];
            bl = false;
        }
        byte by = this._states[n];
        this._set[n] = l;
        this._states[n] = 1;
        this._values[n] = l2;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return l3;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        long[] lArray = this._set;
        long[] lArray2 = this._values;
        byte[] byArray = this._states;
        this._set = new long[n];
        this._values = new long[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            long l = lArray[n3];
            int n4 = this.insertionIndex(l);
            this._set[n4] = l;
            this._values[n4] = lArray2[n3];
            this._states[n4] = 1;
        }
    }

    public long get(long l) {
        int n = this.index(l);
        return n < 0 ? 0L : this._values[n];
    }

    public void clear() {
        super.clear();
        long[] lArray = this._set;
        long[] lArray2 = this._values;
        byte[] byArray = this._states;
        int n = lArray.length;
        while (n-- > 0) {
            lArray[n] = 0L;
            lArray2[n] = 0L;
            byArray[n] = 0;
        }
    }

    public long remove(long l) {
        long l2 = 0L;
        int n = this.index(l);
        if (n >= 0) {
            l2 = this._values[n];
            this.removeAt(n);
        }
        return l2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLongLongHashMap)) {
            return false;
        }
        TLongLongHashMap tLongLongHashMap = (TLongLongHashMap)object;
        if (tLongLongHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tLongLongHashMap));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0L;
    }

    public long[] getValues() {
        long[] lArray = new long[this.size()];
        long[] lArray2 = this._values;
        byte[] byArray = this._states;
        int n = lArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            lArray[n2++] = lArray2[n];
        }
        return lArray;
    }

    public long[] keys() {
        long[] lArray = new long[this.size()];
        long[] lArray2 = this._set;
        byte[] byArray = this._states;
        int n = lArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            lArray[n2++] = lArray2[n];
        }
        return lArray;
    }

    public boolean containsValue(long l) {
        byte[] byArray = this._states;
        long[] lArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || l != lArray[n]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(long l) {
        return this.contains(l);
    }

    public boolean forEachKey(TLongProcedure tLongProcedure) {
        return this.forEach(tLongProcedure);
    }

    public boolean forEachValue(TLongProcedure tLongProcedure) {
        byte[] byArray = this._states;
        long[] lArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tLongProcedure.execute(lArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TLongLongProcedure tLongLongProcedure) {
        byte[] byArray = this._states;
        long[] lArray = this._set;
        long[] lArray2 = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tLongLongProcedure.execute(lArray[n], lArray2[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TLongLongProcedure tLongLongProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        long[] lArray = this._set;
        long[] lArray2 = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tLongLongProcedure.execute(lArray[n], lArray2[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TLongFunction tLongFunction) {
        byte[] byArray = this._states;
        long[] lArray = this._values;
        int n = lArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            lArray[n] = tLongFunction.execute(lArray[n]);
        }
    }

    public boolean increment(long l) {
        return this.adjustValue(l, 1L);
    }

    public boolean adjustValue(long l, long l2) {
        int n = this.index(l);
        if (n < 0) {
            return false;
        }
        int n2 = n;
        this._values[n2] = this._values[n2] + l2;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            long l = objectInputStream.readLong();
            long l2 = objectInputStream.readLong();
            this.put(l, l2);
        }
    }

    private static final class EqProcedure
    implements TLongLongProcedure {
        private final TLongLongHashMap _otherMap;

        EqProcedure(TLongLongHashMap tLongLongHashMap) {
            this._otherMap = tLongLongHashMap;
        }

        public final boolean execute(long l, long l2) {
            int n = this._otherMap.index(l);
            return n >= 0 && this.eq(l2, this._otherMap.get(l));
        }

        private final boolean eq(long l, long l2) {
            return l == l2;
        }
    }

    private final class HashProcedure
    implements TLongLongProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(long l, long l2) {
            this.h += TLongLongHashMap.this._hashingStrategy.computeHashCode(l) ^ HashFunctions.hash(l2);
            return true;
        }
    }
}

