/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TLongHash;
import gnu.trove.TLongHashingStrategy;
import gnu.trove.TLongIterator;
import gnu.trove.TLongProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class TLongHashSet
extends TLongHash
implements Serializable {
    public TLongHashSet() {
    }

    public TLongHashSet(int n) {
        super(n);
    }

    public TLongHashSet(int n, float f) {
        super(n, f);
    }

    public TLongHashSet(long[] lArray) {
        this(lArray.length);
        this.addAll(lArray);
    }

    public TLongHashSet(TLongHashingStrategy tLongHashingStrategy) {
        super(tLongHashingStrategy);
    }

    public TLongHashSet(int n, TLongHashingStrategy tLongHashingStrategy) {
        super(n, tLongHashingStrategy);
    }

    public TLongHashSet(int n, float f, TLongHashingStrategy tLongHashingStrategy) {
        super(n, f, tLongHashingStrategy);
    }

    public TLongHashSet(long[] lArray, TLongHashingStrategy tLongHashingStrategy) {
        this(lArray.length, tLongHashingStrategy);
        this.addAll(lArray);
    }

    public TLongIterator iterator() {
        return new TLongIterator(this);
    }

    public boolean add(long l) {
        int n = this.insertionIndex(l);
        if (n < 0) {
            return false;
        }
        byte by = this._states[n];
        this._set[n] = l;
        this._states[n] = 1;
        this.postInsertHook(by == 0);
        return true;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        long[] lArray = this._set;
        byte[] byArray = this._states;
        this._set = new long[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            long l = lArray[n3];
            int n4 = this.insertionIndex(l);
            this._set[n4] = l;
            this._states[n4] = 1;
        }
    }

    public long[] toArray() {
        long[] lArray = new long[this.size()];
        long[] lArray2 = this._set;
        byte[] byArray = this._states;
        int n = byArray.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            lArray[n2++] = lArray2[n];
        }
        return lArray;
    }

    public void clear() {
        super.clear();
        long[] lArray = this._set;
        byte[] byArray = this._states;
        int n = lArray.length;
        while (n-- > 0) {
            lArray[n] = 0L;
            byArray[n] = 0;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLongHashSet)) {
            return false;
        }
        final TLongHashSet tLongHashSet = (TLongHashSet)object;
        if (tLongHashSet.size() != this.size()) {
            return false;
        }
        return this.forEach(new TLongProcedure(){

            public final boolean execute(long l) {
                return tLongHashSet.contains(l);
            }
        });
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEach(hashProcedure);
        return hashProcedure.getHashCode();
    }

    public boolean remove(long l) {
        int n = this.index(l);
        if (n >= 0) {
            this.removeAt(n);
            return true;
        }
        return false;
    }

    public boolean containsAll(long[] lArray) {
        int n = lArray.length;
        while (n-- > 0) {
            if (this.contains(lArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(long[] lArray) {
        boolean bl = false;
        int n = lArray.length;
        while (n-- > 0) {
            if (!this.add(lArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(long[] lArray) {
        boolean bl = false;
        int n = lArray.length;
        while (n-- > 0) {
            if (!this.remove(lArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(long[] lArray) {
        boolean bl = false;
        Arrays.sort(lArray);
        long[] lArray2 = this._set;
        byte[] byArray = this._states;
        int n = lArray2.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || Arrays.binarySearch(lArray, lArray2[n]) >= 0) continue;
            this.remove(lArray2[n]);
            bl = true;
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEach(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            long l = objectInputStream.readLong();
            this.add(l);
        }
    }

    private final class HashProcedure
    implements TLongProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(long l) {
            this.h += TLongHashSet.this._hashingStrategy.computeHashCode(l);
            return true;
        }
    }
}

