/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TDoubleHash;
import gnu.trove.TDoubleHashingStrategy;
import gnu.trove.TDoubleObjectIterator;
import gnu.trove.TDoubleObjectProcedure;
import gnu.trove.TDoubleProcedure;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TDoubleObjectHashMap
extends TDoubleHash
implements Serializable {
    protected transient Object[] _values;

    public TDoubleObjectHashMap() {
    }

    public TDoubleObjectHashMap(int n) {
        super(n);
    }

    public TDoubleObjectHashMap(int n, float f) {
        super(n, f);
    }

    public TDoubleObjectHashMap(TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(tDoubleHashingStrategy);
    }

    public TDoubleObjectHashMap(int n, TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(n, tDoubleHashingStrategy);
    }

    public TDoubleObjectHashMap(int n, float f, TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(n, f, tDoubleHashingStrategy);
    }

    public Object clone() {
        TDoubleObjectHashMap tDoubleObjectHashMap = (TDoubleObjectHashMap)super.clone();
        tDoubleObjectHashMap._values = (Object[])this._values.clone();
        return tDoubleObjectHashMap;
    }

    public TDoubleObjectIterator iterator() {
        return new TDoubleObjectIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new Object[n2];
        return n2;
    }

    public Object put(double d, Object object) {
        Object object2 = null;
        int n = this.insertionIndex(d);
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            object2 = this._values[n];
            bl = false;
        }
        byte by = this._states[n];
        this._set[n] = d;
        this._states[n] = 1;
        this._values[n] = object;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return object2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        double[] dArray = this._set;
        Object[] objectArray = this._values;
        byte[] byArray = this._states;
        this._set = new double[n];
        this._values = new Object[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            double d = dArray[n3];
            int n4 = this.insertionIndex(d);
            this._set[n4] = d;
            this._values[n4] = objectArray[n3];
            this._states[n4] = 1;
        }
    }

    public Object get(double d) {
        int n = this.index(d);
        return n < 0 ? null : this._values[n];
    }

    public void clear() {
        super.clear();
        double[] dArray = this._set;
        Object[] objectArray = this._values;
        byte[] byArray = this._states;
        int n = dArray.length;
        while (n-- > 0) {
            dArray[n] = 0.0;
            objectArray[n] = null;
            byArray[n] = 0;
        }
    }

    public Object remove(double d) {
        Object object = null;
        int n = this.index(d);
        if (n >= 0) {
            object = this._values[n];
            this.removeAt(n);
        }
        return object;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TDoubleObjectHashMap)) {
            return false;
        }
        TDoubleObjectHashMap tDoubleObjectHashMap = (TDoubleObjectHashMap)object;
        if (tDoubleObjectHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tDoubleObjectHashMap));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = null;
    }

    public Object[] getValues() {
        Object[] objectArray = new Object[this.size()];
        Object[] objectArray2 = this._values;
        byte[] byArray = this._states;
        int n = objectArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            objectArray[n2++] = objectArray2[n];
        }
        return objectArray;
    }

    public double[] keys() {
        double[] dArray = new double[this.size()];
        double[] dArray2 = this._set;
        byte[] byArray = this._states;
        int n = dArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            dArray[n2++] = dArray2[n];
        }
        return dArray;
    }

    public boolean containsValue(Object object) {
        byte[] byArray = this._states;
        Object[] objectArray = this._values;
        if (null == object) {
            int n = objectArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || object != objectArray[n]) continue;
                return true;
            }
        } else {
            int n = objectArray.length;
            while (n-- > 0) {
                if (byArray[n] != 1 || object != objectArray[n] && !object.equals(objectArray[n])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(double d) {
        return this.contains(d);
    }

    public boolean forEachKey(TDoubleProcedure tDoubleProcedure) {
        return this.forEach(tDoubleProcedure);
    }

    public boolean forEachValue(TObjectProcedure tObjectProcedure) {
        byte[] byArray = this._states;
        Object[] objectArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tObjectProcedure.execute(objectArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TDoubleObjectProcedure tDoubleObjectProcedure) {
        byte[] byArray = this._states;
        double[] dArray = this._set;
        Object[] objectArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tDoubleObjectProcedure.execute(dArray[n], objectArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TDoubleObjectProcedure tDoubleObjectProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        double[] dArray = this._set;
        Object[] objectArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tDoubleObjectProcedure.execute(dArray[n], objectArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TObjectFunction tObjectFunction) {
        byte[] byArray = this._states;
        Object[] objectArray = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            objectArray[n] = tObjectFunction.execute(objectArray[n]);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            double d = objectInputStream.readDouble();
            Object object = objectInputStream.readObject();
            this.put(d, object);
        }
    }

    private static final class EqProcedure
    implements TDoubleObjectProcedure {
        private final TDoubleObjectHashMap _otherMap;

        EqProcedure(TDoubleObjectHashMap tDoubleObjectHashMap) {
            this._otherMap = tDoubleObjectHashMap;
        }

        public final boolean execute(double d, Object object) {
            int n = this._otherMap.index(d);
            return n >= 0 && this.eq(object, this._otherMap.get(d));
        }

        private final boolean eq(Object object, Object object2) {
            return object == object2 || object != null && object.equals(object2);
        }
    }

    private final class HashProcedure
    implements TDoubleObjectProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(double d, Object object) {
            this.h += TDoubleObjectHashMap.this._hashingStrategy.computeHashCode(d) ^ HashFunctions.hash(object);
            return true;
        }
    }
}

