/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.TDoubleHashingStrategy;
import gnu.trove.TDoubleProcedure;
import gnu.trove.TPrimitiveHash;
import java.io.Serializable;

public abstract class TDoubleHash
extends TPrimitiveHash
implements Serializable,
TDoubleHashingStrategy {
    protected transient double[] _set;
    protected TDoubleHashingStrategy _hashingStrategy;

    public TDoubleHash() {
        this._hashingStrategy = this;
    }

    public TDoubleHash(int n) {
        super(n);
        this._hashingStrategy = this;
    }

    public TDoubleHash(int n, float f) {
        super(n, f);
        this._hashingStrategy = this;
    }

    public TDoubleHash(TDoubleHashingStrategy tDoubleHashingStrategy) {
        this._hashingStrategy = tDoubleHashingStrategy;
    }

    public TDoubleHash(int n, TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(n);
        this._hashingStrategy = tDoubleHashingStrategy;
    }

    public TDoubleHash(int n, float f, TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(n, f);
        this._hashingStrategy = tDoubleHashingStrategy;
    }

    public Object clone() {
        TDoubleHash tDoubleHash = (TDoubleHash)super.clone();
        tDoubleHash._set = (double[])this._set.clone();
        return tDoubleHash;
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._set = new double[n2];
        return n2;
    }

    public boolean contains(double d) {
        return this.index(d) >= 0;
    }

    public boolean forEach(TDoubleProcedure tDoubleProcedure) {
        byte[] byArray = this._states;
        double[] dArray = this._set;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tDoubleProcedure.execute(dArray[n])) continue;
            return false;
        }
        return true;
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._set[n] = 0.0;
    }

    protected int index(double d) {
        byte[] byArray = this._states;
        double[] dArray = this._set;
        int n = byArray.length;
        int n2 = this._hashingStrategy.computeHashCode(d) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        if (byArray[n3] != 0 && (byArray[n3] == 2 || dArray[n3] != d)) {
            int n4 = 1 + n2 % (n - 2);
            do {
                if ((n3 -= n4) >= 0) continue;
                n3 += n;
            } while (byArray[n3] != 0 && (byArray[n3] == 2 || dArray[n3] != d));
        }
        return byArray[n3] == 0 ? -1 : n3;
    }

    protected int insertionIndex(double d) {
        byte[] byArray = this._states;
        double[] dArray = this._set;
        int n = byArray.length;
        int n2 = this._hashingStrategy.computeHashCode(d) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        if (byArray[n3] == 0) {
            return n3;
        }
        if (byArray[n3] == 1 && dArray[n3] == d) {
            return -n3 - 1;
        }
        int n4 = 1 + n2 % (n - 2);
        if (byArray[n3] != 2) {
            do {
                if ((n3 -= n4) >= 0) continue;
                n3 += n;
            } while (byArray[n3] == 1 && dArray[n3] != d);
        }
        if (byArray[n3] == 2) {
            int n5 = n3;
            while (byArray[n3] != 0 && (byArray[n3] == 2 || dArray[n3] != d)) {
                if ((n3 -= n4) >= 0) continue;
                n3 += n;
            }
            return byArray[n3] == 1 ? -n3 - 1 : n5;
        }
        return byArray[n3] == 1 ? -n3 - 1 : n3;
    }

    public final int computeHashCode(double d) {
        return HashFunctions.hash(d);
    }
}

