/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TDoubleFloatIterator;
import gnu.trove.TDoubleFloatProcedure;
import gnu.trove.TDoubleHash;
import gnu.trove.TDoubleHashingStrategy;
import gnu.trove.TDoubleProcedure;
import gnu.trove.TFloatFunction;
import gnu.trove.TFloatProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TDoubleFloatHashMap
extends TDoubleHash
implements Serializable {
    protected transient float[] _values;

    public TDoubleFloatHashMap() {
    }

    public TDoubleFloatHashMap(int n) {
        super(n);
    }

    public TDoubleFloatHashMap(int n, float f) {
        super(n, f);
    }

    public TDoubleFloatHashMap(TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(tDoubleHashingStrategy);
    }

    public TDoubleFloatHashMap(int n, TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(n, tDoubleHashingStrategy);
    }

    public TDoubleFloatHashMap(int n, float f, TDoubleHashingStrategy tDoubleHashingStrategy) {
        super(n, f, tDoubleHashingStrategy);
    }

    public Object clone() {
        TDoubleFloatHashMap tDoubleFloatHashMap = (TDoubleFloatHashMap)super.clone();
        tDoubleFloatHashMap._values = (float[])this._values.clone();
        return tDoubleFloatHashMap;
    }

    public TDoubleFloatIterator iterator() {
        return new TDoubleFloatIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new float[n2];
        return n2;
    }

    public float put(double d, float f) {
        float f2 = 0.0f;
        int n = this.insertionIndex(d);
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            f2 = this._values[n];
            bl = false;
        }
        byte by = this._states[n];
        this._set[n] = d;
        this._states[n] = 1;
        this._values[n] = f;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return f2;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        double[] dArray = this._set;
        float[] fArray = this._values;
        byte[] byArray = this._states;
        this._set = new double[n];
        this._values = new float[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            double d = dArray[n3];
            int n4 = this.insertionIndex(d);
            this._set[n4] = d;
            this._values[n4] = fArray[n3];
            this._states[n4] = 1;
        }
    }

    public float get(double d) {
        int n = this.index(d);
        return n < 0 ? 0.0f : this._values[n];
    }

    public void clear() {
        super.clear();
        double[] dArray = this._set;
        float[] fArray = this._values;
        byte[] byArray = this._states;
        int n = dArray.length;
        while (n-- > 0) {
            dArray[n] = 0.0;
            fArray[n] = 0.0f;
            byArray[n] = 0;
        }
    }

    public float remove(double d) {
        float f = 0.0f;
        int n = this.index(d);
        if (n >= 0) {
            f = this._values[n];
            this.removeAt(n);
        }
        return f;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TDoubleFloatHashMap)) {
            return false;
        }
        TDoubleFloatHashMap tDoubleFloatHashMap = (TDoubleFloatHashMap)object;
        if (tDoubleFloatHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(tDoubleFloatHashMap));
    }

    public int hashCode() {
        HashProcedure hashProcedure = new HashProcedure();
        this.forEachEntry(hashProcedure);
        return hashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0.0f;
    }

    public float[] getValues() {
        float[] fArray = new float[this.size()];
        float[] fArray2 = this._values;
        byte[] byArray = this._states;
        int n = fArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            fArray[n2++] = fArray2[n];
        }
        return fArray;
    }

    public double[] keys() {
        double[] dArray = new double[this.size()];
        double[] dArray2 = this._set;
        byte[] byArray = this._states;
        int n = dArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            dArray[n2++] = dArray2[n];
        }
        return dArray;
    }

    public boolean containsValue(float f) {
        byte[] byArray = this._states;
        float[] fArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || f != fArray[n]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(double d) {
        return this.contains(d);
    }

    public boolean forEachKey(TDoubleProcedure tDoubleProcedure) {
        return this.forEach(tDoubleProcedure);
    }

    public boolean forEachValue(TFloatProcedure tFloatProcedure) {
        byte[] byArray = this._states;
        float[] fArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tFloatProcedure.execute(fArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TDoubleFloatProcedure tDoubleFloatProcedure) {
        byte[] byArray = this._states;
        double[] dArray = this._set;
        float[] fArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tDoubleFloatProcedure.execute(dArray[n], fArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TDoubleFloatProcedure tDoubleFloatProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        double[] dArray = this._set;
        float[] fArray = this._values;
        int n = dArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tDoubleFloatProcedure.execute(dArray[n], fArray[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TFloatFunction tFloatFunction) {
        byte[] byArray = this._states;
        float[] fArray = this._values;
        int n = fArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            fArray[n] = tFloatFunction.execute(fArray[n]);
        }
    }

    public boolean increment(double d) {
        return this.adjustValue(d, 1.0f);
    }

    public boolean adjustValue(double d, float f) {
        int n = this.index(d);
        if (n < 0) {
            return false;
        }
        int n2 = n;
        this._values[n2] = this._values[n2] + f;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            double d = objectInputStream.readDouble();
            float f = objectInputStream.readFloat();
            this.put(d, f);
        }
    }

    private static final class EqProcedure
    implements TDoubleFloatProcedure {
        private final TDoubleFloatHashMap _otherMap;

        EqProcedure(TDoubleFloatHashMap tDoubleFloatHashMap) {
            this._otherMap = tDoubleFloatHashMap;
        }

        public final boolean execute(double d, float f) {
            int n = this._otherMap.index(d);
            return n >= 0 && this.eq(f, this._otherMap.get(d));
        }

        private final boolean eq(float f, float f2) {
            return f == f2;
        }
    }

    private final class HashProcedure
    implements TDoubleFloatProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(double d, float f) {
            this.h += TDoubleFloatHashMap.this._hashingStrategy.computeHashCode(d) ^ HashFunctions.hash(f);
            return true;
        }
    }
}

