/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional.xml;

import com.tripwire.common.util.ResourceManager;
import com.tripwire.common.util.xml.AbstractXmlElementParser;
import com.tripwire.common.util.xml.XmlException;
import com.tripwire.common.util.xml.XmlInputContext;
import com.tripwire.space.core.conditional.ConditionalPredicate;
import com.tripwire.space.core.conditional.OperandExtractor;
import com.tripwire.space.core.conditional.xml.ConditionalPredicateXmlConstants;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Locale;

public class ConditionalPredicateXmlElementParser
extends AbstractXmlElementParser
implements ConditionalPredicateXmlConstants {
    private static final DateFormat OLD_DATE_FORMAT = DateFormat.getDateTimeInstance(3, 3, Locale.US);

    public ConditionalPredicateXmlElementParser() {
        super(CONDITIONAL_PREDICATE_ELEMENT, ConditionalPredicate.class);
    }

    protected void readBody(XmlInputContext in, Object obj) throws XmlException, IOException {
        TemporaryConditionalPredicate tcp = (TemporaryConditionalPredicate)obj;
        tcp.m_negate = in.parseBooleanElement(NEGATE_ELEMENT);
        tcp.m_operatorId = in.parseIntegerElement(OPERATOR_ID_ELEMENT);
        if (!in.detectElementStart(OPERANDS_ELEMENT)) {
            throw new XmlException(ResourceManager.getInstance().getSafeString("com.tripwire.space.core.conditional.predicateConditional.noOperandError"));
        }
        int count = in.getIntegerAttribute(OPERAND_COUNT, 1, 2);
        tcp.m_operands = new Object[count];
        in.skipElementStart(OPERANDS_ELEMENT);
        if (!in.detectElementStart(OPERAND_ELEMENT)) {
            throw new XmlException(ResourceManager.getInstance().getSafeString("com.tripwire.space.core.conditional.predicateConditional.missingOperandError"));
        }
        for (int i = 0; i < count && in.detectElementStart(OPERAND_ELEMENT); ++i) {
            String type = in.getStringAttribute(OPERAND_TYPE);
            in.skipElementStart(OPERAND_ELEMENT);
            tcp.m_operands[i] = this.readOperand(in, type);
            in.skipElementEnd(OPERAND_ELEMENT);
        }
        in.skipElementEnd(OPERANDS_ELEMENT);
    }

    protected Object createInstance(XmlInputContext in) throws XmlException {
        return new TemporaryConditionalPredicate();
    }

    protected Object finishObject(XmlInputContext in, Object obj) throws XmlException {
        TemporaryConditionalPredicate tcp = (TemporaryConditionalPredicate)obj;
        ConditionalPredicate cPred = null;
        cPred = tcp.m_operands.length == 1 ? new ConditionalPredicate(tcp.m_operatorId, (OperandExtractor)tcp.m_operands[0]) : new ConditionalPredicate(tcp.m_operatorId, (OperandExtractor)tcp.m_operands[0], tcp.m_operands[1]);
        cPred.negate(tcp.m_negate);
        return cPred;
    }

    private Object readOperand(XmlInputContext in, String type) throws XmlException, IOException {
        if (type.equals("Array")) {
            ArrayList<Object> operands = new ArrayList<Object>();
            while (in.detectElementStart(ARRAY_OPERAND_ELEMENT)) {
                String operandType = in.getStringAttribute(OPERAND_TYPE);
                in.skipElementStart(ARRAY_OPERAND_ELEMENT);
                operands.add(this.readSingleOperand(in, operandType));
                in.skipElementEnd(ARRAY_OPERAND_ELEMENT);
            }
            return operands.toArray();
        }
        return this.readSingleOperand(in, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readSingleOperand(XmlInputContext in, String type) throws XmlException, IOException {
        if (type.equals("Extractor") || type.equals("Object")) {
            return in.maybeParseObjectElement();
        }
        if (type.equals("Boolean")) {
            return Boolean.valueOf(in.parseStringContentBody());
        }
        if (type.equals("Integer")) {
            return Integer.valueOf(in.parseStringContentBody());
        }
        if (type.equals("Long")) {
            return Long.valueOf(in.parseStringContentBody());
        }
        if (type.equals("String")) {
            return in.parseStringContentBody();
        }
        if (type.equals("Date")) {
            String dateString = in.parseStringContentBody();
            try {
                DateFormat dateFormat = DATE_FORMAT;
                synchronized (dateFormat) {
                    return DATE_FORMAT.parse(dateString);
                }
            }
            catch (ParseException e) {
                try {
                    DateFormat dateFormat = OLD_DATE_FORMAT;
                    synchronized (dateFormat) {
                        return OLD_DATE_FORMAT.parse(dateString);
                    }
                }
                catch (ParseException ex) {
                    throw XmlException.asXmlException(ex);
                }
            }
        }
        throw new XmlException(ResourceManager.getInstance().getSafeString("com.tripwire.space.core.conditional.xml.missingOperandType", new Object[]{new Integer(in.getLineNumber())}));
    }

    static {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(6, 1);
        cal.set(1, 1980);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        ((SimpleDateFormat)OLD_DATE_FORMAT).set2DigitYearStart(cal.getTime());
    }

    private class TemporaryConditionalPredicate {
        public boolean m_negate = false;
        public int m_operatorId = 0;
        public Object[] m_operands;

        TemporaryConditionalPredicate() {
        }
    }
}

