/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional;

import com.tripwire.common.util.Hashes;
import com.tripwire.common.util.Objects;
import com.tripwire.space.core.SpaceException;
import com.tripwire.space.core.conditional.ConditionTrace;
import com.tripwire.space.core.conditional.Conditional;
import com.tripwire.space.core.conditional.ContentConditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextContentConditions
extends ContentConditions {
    private static final long serialVersionUID = -7005338858109312281L;
    protected Pattern m_regex;

    public TextContentConditions() {
    }

    public TextContentConditions(Conditional condition, Pattern regex) {
        super(condition, 2);
        this.setRegularExpression(regex);
    }

    public Pattern getRegularExpression() {
        return this.m_regex;
    }

    public void setRegularExpression(Pattern regex) {
        assert (regex != null);
        this.m_regex = regex;
    }

    public boolean eval(String content) throws Exception {
        Matcher matcher = this.m_regex.matcher(content);
        ConditionTrace.writeProperty("Pattern", this.m_regex);
        try {
            matcher.find();
        }
        catch (StackOverflowError e) {
            throw new SpaceException(e, "com.tripwire.space.core.conditional.stackOverflowError", new Object[]{matcher.pattern().pattern()});
        }
        return this.getCondition().evaluate(matcher);
    }

    protected boolean doEquals(Object o) {
        if (!super.doEquals(o)) {
            return false;
        }
        TextContentConditions that = (TextContentConditions)o;
        return TextContentConditions.patternEquals(this.m_regex, that.m_regex);
    }

    private static boolean patternEquals(Pattern lhs, Pattern rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        return lhs.flags() == rhs.flags() && Objects.equals(rhs.pattern(), lhs.pattern());
    }

    public int hashCode() {
        int result = super.hashCode();
        if (this.m_regex != null) {
            result = 31 * result + Hashes.hashCode(this.m_regex);
        }
        result = 31 * result + this.m_type;
        return result;
    }
}

