/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional;

import com.tripwire.space.core.conditional.ActualCollectable;
import com.tripwire.space.core.conditional.CachedOperandExtractor;
import com.tripwire.space.core.conditional.Conditional;
import com.tripwire.space.core.conditional.ConditionalList;
import com.tripwire.space.core.conditional.ConditionalPredicate;
import com.tripwire.space.core.conditional.OperandExtractor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConditionalTreePromotion {
    private PromotePredicateHandler m_handler;
    private Map m_observedValues;
    static PromotePredicateHandler sm_expander = new PromotePredicateHandler(){

        public Conditional promote(Map observed, ConditionalPredicate source) {
            ActualCollectable extractor;
            Object key;
            OperandExtractor lhs = source.getLhsOperandExtractor();
            if (lhs instanceof ActualCollectable && observed.containsKey(key = (extractor = (ActualCollectable)((Object)lhs)).getCollectableKey())) {
                ConditionalList expansion = this.createFromObservedList(source, (Set)observed.get(key));
                if (expansion instanceof ConditionalList) {
                    expansion.getConditions().add(0, ConditionalTreePromotion.duplicatePredicate(source));
                }
                return expansion;
            }
            return ConditionalTreePromotion.duplicatePredicate(source);
        }

        boolean coversObserved(ConditionalPredicate source, Object observedValue) {
            boolean opEvaluation = source.getOperator().evaluate(observedValue, source.getRhsOperand());
            return source.isNegated() ? !opEvaluation : opEvaluation;
        }
    };
    static PromotePredicateHandler sm_narrower = new PromotePredicateHandler(){

        public Conditional promote(Map observed, ConditionalPredicate source) {
            ActualCollectable collectable;
            Object key;
            OperandExtractor lhsExtractor = source.getLhsOperandExtractor();
            if (lhsExtractor instanceof ActualCollectable && observed.containsKey(key = (collectable = (ActualCollectable)((Object)lhsExtractor)).getCollectableKey())) {
                Set observedValues = (Set)observed.get(key);
                ConditionalList narrowing = this.createFromObservedList(source, observedValues);
                if (narrowing instanceof ConditionalList && observedValues.contains(CachedOperandExtractor.NOT_EXTRACTED)) {
                    narrowing.getConditions().add(0, ConditionalTreePromotion.duplicatePredicate(source));
                }
                return narrowing;
            }
            return ConditionalTreePromotion.duplicatePredicate(source);
        }

        boolean coversObserved(ConditionalPredicate source, Object observedValue) {
            return false;
        }
    };

    ConditionalTreePromotion(Map observedValues, PromotePredicateHandler predicateHandler) {
        this.m_handler = predicateHandler;
        this.m_observedValues = observedValues;
    }

    Conditional promote(Conditional source, ConditionalList parent) {
        if (source instanceof ConditionalList) {
            return this.promoteList((ConditionalList)source, parent);
        }
        return this.m_handler.promote(this.m_observedValues, (ConditionalPredicate)source);
    }

    Conditional promoteList(ConditionalList sourceList, ConditionalList parent) {
        Conditional singleChild;
        ConditionalList currentParent = parent == null || sourceList.getClass() != parent.getClass() ? (sourceList.isAndList() ? ConditionalList.createAndList() : ConditionalList.createOrList()) : parent;
        for (Conditional sourceChild : sourceList.getConditions()) {
            Conditional newChild = this.promote(sourceChild, currentParent);
            if (newChild == currentParent) continue;
            HashSet<Conditional> priorSiblings = new HashSet<Conditional>(currentParent.getConditions());
            if (currentParent.getClass() == newChild.getClass() || newChild instanceof ConditionalList && ((ConditionalList)newChild).size() <= 1) {
                ConditionalList newList = (ConditionalList)newChild;
                for (Conditional aChild : newList.getConditions()) {
                    if (priorSiblings.contains(aChild)) continue;
                    currentParent.add(aChild);
                }
                continue;
            }
            if (priorSiblings.contains(newChild)) continue;
            currentParent.add(newChild);
        }
        if (currentParent.size() == 1 && (singleChild = currentParent.getConditions().get(0)) instanceof ConditionalList) {
            return singleChild;
        }
        return currentParent;
    }

    public static Conditional expand(Conditional condition, Map observedValues) {
        ConditionalTreePromotion ctp = new ConditionalTreePromotion(observedValues, sm_expander);
        return ctp.promote(condition, null);
    }

    public static Conditional narrow(Conditional condition, Map observedValues) {
        ConditionalTreePromotion ctp = new ConditionalTreePromotion(observedValues, sm_narrower);
        return ctp.promote(condition, null);
    }

    static ConditionalPredicate duplicatePredicate(ConditionalPredicate source) {
        ConditionalPredicate duplicate = source.getOperator().isUnary() ? new ConditionalPredicate(source.getOperator().getId(), source.getLhsOperandExtractor()) : new ConditionalPredicate(source.getOperator().getId(), source.getLhsOperandExtractor(), source.getRhsOperand());
        duplicate.negate(source.isNegated());
        return duplicate;
    }

    static abstract class PromotePredicateHandler {
        PromotePredicateHandler() {
        }

        abstract Conditional promote(Map var1, ConditionalPredicate var2);

        abstract boolean coversObserved(ConditionalPredicate var1, Object var2);

        ConditionalList createFromObservedList(ConditionalPredicate source, Set values) {
            ConditionalList expansionList = ConditionalList.createOrList();
            for (Object value : values) {
                ConditionalPredicate newCond;
                boolean extractedNull;
                if (CachedOperandExtractor.NOT_EXTRACTED.equals(value) || this.coversObserved(source, (extractedNull = CachedOperandExtractor.EXTRACTED_NULL.equals(value)) ? null : value)) continue;
                if (extractedNull) {
                    newCond = new ConditionalPredicate(6, source.getLhsOperandExtractor());
                    newCond.negate(true);
                } else {
                    newCond = new ConditionalPredicate(0, source.getLhsOperandExtractor(), value);
                }
                expansionList.add(newCond);
            }
            return expansionList;
        }
    }
}

