/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional;

import com.tripwire.space.core.LocalizableString;
import com.tripwire.space.core.SpaceException;
import com.tripwire.space.core.conditional.AbstractOperandExtractor;
import java.util.Map;

public abstract class CachedOperandExtractor
extends AbstractOperandExtractor {
    private static final long serialVersionUID = -2016130940780167187L;
    private transient Object m_cachedValue = null;
    private transient Object m_lastSource = null;
    private transient boolean m_extracted = false;
    private static final String EXTRACTED_NULL_KEY = "actualCollectible.extractedNull.text";
    private static final String NOT_EXTRACTED_KEY = "actualCollectible.notExtracted.text";
    public static final LocalizableString EXTRACTED_NULL = new LocalizableString("actualCollectible.extractedNull.text");
    public static final LocalizableString NOT_EXTRACTED = new LocalizableString("actualCollectible.notExtracted.text");

    public final Object extractFrom(Object source) throws SpaceException {
        if (this.m_lastSource != source) {
            this.reset();
            this.m_lastSource = source;
            this.m_cachedValue = this.extractValue(source);
            this.m_extracted = true;
        }
        return this.m_cachedValue;
    }

    protected abstract Object extractValue(Object var1) throws SpaceException;

    protected Object getExtractedForDisplay() {
        if (this.m_cachedValue == null) {
            if (this.m_extracted) {
                return EXTRACTED_NULL;
            }
            return NOT_EXTRACTED;
        }
        return this.m_cachedValue.toString();
    }

    protected Object getCacheValue() {
        return this.m_cachedValue;
    }

    public void reset() {
        this.m_cachedValue = null;
        this.m_lastSource = null;
        this.m_extracted = false;
    }

    protected void mapActual(Map map, Object key, Object value) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
    }
}

