/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.space.core.conditional;

import com.tripwire.common.util.PropertyStream;
import com.tripwire.space.core.SpaceException;
import com.tripwire.space.core.conditional.ConditionTrace;
import com.tripwire.space.core.conditional.OperandExtractor;
import com.tripwire.space.core.conditional.operator.Operator;

public abstract class AbstractOperandExtractor
implements OperandExtractor {
    private static final long serialVersionUID = 7488147483999270354L;

    public boolean evaluate(Operator op, Object source, Object rhs) throws SpaceException {
        PropertyStream trace = ConditionTrace.getPropertyStream();
        Object lhs = this.extractFrom(source);
        this.validate(op, lhs, rhs);
        boolean result = op.evaluate(lhs, rhs);
        if (trace != null) {
            trace.property("Actual", lhs);
            trace.property("Expected", rhs);
            trace.property("Result", result);
        }
        return result;
    }

    protected void validate(Operator op, Object lhs, Object rhs) throws SpaceException {
    }

    protected abstract Object extractFrom(Object var1) throws SpaceException;
}

