/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.ipdevice;

import java.io.IOException;
import java.io.StringWriter;

public class TraceWriter
extends StringWriter {
    static int m_index = 0;
    int m_id = m_index++;
    public static final boolean TRACE = Boolean.getBoolean("com.tripwire.scripting.debug");

    public void write(char[] cbuf, int off, int len) {
        super.write(cbuf, off, len);
        if (TRACE) {
            System.out.print(new String(cbuf, off, len));
        }
    }

    public void write(int c) {
        super.write(c);
        if (TRACE) {
            System.out.print(c);
        }
    }

    public void write(char[] cbuf) throws IOException {
        super.write(cbuf);
        if (TRACE) {
            System.out.print(cbuf);
        }
    }

    public void write(String str) {
        super.write(str);
        if (TRACE) {
            System.out.print(str);
        }
    }

    public void writeStart(String str) {
        super.write(str);
        if (TRACE) {
            System.out.print("" + this.m_id + ": " + str);
        }
    }

    public void write(String str, int off, int len) {
        super.write(str, off, len);
        if (TRACE) {
            System.out.print(str.substring(off, off + len));
        }
    }
}

