/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.honeybee.ui.model.testrunner;

import com.tripwire.checker.app.xml.Child;
import com.tripwire.checker.app.xml.Children;
import com.tripwire.checker.app.xml.PolicyTest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyTree {
    private PolicyTreeNode m_root;

    public PolicyTree(HashMap<String, PolicyTest> tests) {
        if (null == tests) {
            return;
        }
        PolicyTest newPolicyTest = tests.get("ID0");
        if (null != newPolicyTest) {
            this.m_root = this.buildPolicyStructure(tests, newPolicyTest, 0);
        }
    }

    protected PolicyTreeNode buildPolicyStructure(HashMap<String, PolicyTest> allTestsById, PolicyTest root, int depthLevel) {
        List<Child> childs;
        Children children = root.getChildren();
        PolicyTreeNode rootNode = new PolicyTreeNode(depthLevel, root.getAttribId(), root.getAttribName(), root.getDescription(), children == null);
        if (null != children && null != (childs = children.getChildren())) {
            for (Child child : childs) {
                PolicyTest newPolicyTest = allTestsById.get(child.getAttribRefid());
                if (null == newPolicyTest) continue;
                rootNode.addChild(this.buildPolicyStructure(allTestsById, newPolicyTest, depthLevel + 1));
            }
        }
        return rootNode;
    }

    public void walkTree(TreeProcessor cb) {
        this.doWalkTree(this.m_root, cb);
    }

    protected void doWalkTree(PolicyTreeNode node, TreeProcessor cb) {
        cb.onReceiveNode(node);
        for (PolicyTreeNode child : node.getChildren()) {
            this.doWalkTree(child, cb);
        }
    }

    public static interface TreeProcessor {
        public void onReceiveNode(PolicyTreeNode var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PolicyTreeNode {
        public int level;
        public String name;
        public String desc;
        public boolean leaf;
        public String id;
        public List<PolicyTreeNode> m_children = new ArrayList<PolicyTreeNode>();
        public PolicyTreeNode m_parent = null;

        public PolicyTreeNode(int level, String id, String name, String desc, boolean leaf) {
            this.level = level;
            this.id = id;
            this.name = name;
            this.desc = desc;
            this.leaf = leaf;
        }

        public List<PolicyTreeNode> getChildren() {
            return this.m_children;
        }

        public void addChild(PolicyTreeNode node) {
            if (this.m_children == null) {
                this.m_children = new ArrayList<PolicyTreeNode>();
            }
            this.m_children.add(node);
            node.setParent(this);
        }

        public void setParent(PolicyTreeNode parent) {
            this.m_parent = parent;
        }

        public PolicyTreeNode getParent() {
            return this.m_parent;
        }
    }
}

