/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util;

public class Stopwatch {
    protected long startTime;
    protected boolean paused = false;
    protected long pauseTime;

    public Stopwatch() {
        this.startTime = System.currentTimeMillis();
    }

    public Stopwatch(long _startTime) {
        this.startTime = _startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public long getElapsed() {
        if (this.paused) {
            return this.pauseTime - this.startTime;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    public double getElapsedDouble() {
        return (double)this.getElapsed() / 1000.0;
    }

    public void pause() {
        if (!this.paused) {
            this.pauseTime = System.currentTimeMillis();
            this.paused = true;
        }
    }

    public void restart() {
        if (this.paused) {
            this.startTime += System.currentTimeMillis() - this.pauseTime;
            this.paused = false;
        }
    }

    public void reset() {
        this.startTime = System.currentTimeMillis();
        this.paused = false;
    }
}

