/*
 * Decompiled with CFR 0.152.
 */
package com.tripwire.common.util;

import com.tripwire.common.collections.CollectionTools;
import com.tripwire.common.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class ResourceManager {
    private static final boolean TRACE = Boolean.getBoolean("tw.resourceManager.trace");
    private static final boolean VERBOSE = TRACE && Boolean.getBoolean("tw.resourceManager.verbose");
    private static final boolean DEBUG_LOCALE = Boolean.getBoolean("tw.resourceManager.debugLocale");
    private static final boolean DEBUG_JA_LOCALE = Boolean.getBoolean("tw.resourceManager.debugJALocale");
    private static final ResourceManager sm_instance = new ResourceManager();
    private final Map m_loadableResources = CollectionTools.createMap();
    private final Map m_loadedStrings = CollectionTools.createMap();
    private LocaleCallback m_localeCallback = null;
    private static final String sm_NBSP_JA;

    public static ResourceManager getInstance() {
        return sm_instance;
    }

    private ResourceManager() {
    }

    public void setLocaleCallback(LocaleCallback callback) {
        this.m_localeCallback = callback;
    }

    public LocaleCallback getLocaleCallback() {
        return this.m_localeCallback;
    }

    public void addStandardResources(String packageName, ClassLoader loader) {
        this.addResource(packageName + ".resource", loader);
        this.addResource(packageName + ".data", loader);
    }

    public void addStandardResources(Class theClass) {
        this.addStandardResources(theClass.getPackage().getName(), theClass.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResource(String resourceName, ClassLoader loader) {
        ResourceManager resourceManager = this;
        synchronized (resourceManager) {
            if (TRACE) {
                ResourceManager.trace("Adding resource '" + resourceName + "'");
            }
            if (!this.m_loadableResources.containsKey(resourceName)) {
                this.m_loadableResources.put(resourceName, loader);
                this.loadResourceForAllLocales(resourceName, loader);
            }
        }
    }

    public void addResourcesFromList(String resourceList, ClassLoader loader) {
        ResourceBundle bundle = ResourceBundle.getBundle(resourceList, this.getLocale(), loader);
        Enumeration<String> keysEnum = bundle.getKeys();
        while (keysEnum.hasMoreElements()) {
            String sKeyName = keysEnum.nextElement();
            String sResourceName = bundle.getString(sKeyName);
            this.addStandardResources(sResourceName, loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResource(String resourceName) {
        ResourceManager resourceManager = this;
        synchronized (resourceManager) {
            this.m_loadableResources.remove(resourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ResourceManager resourceManager = this;
        synchronized (resourceManager) {
            this.m_loadedStrings.clear();
        }
    }

    public String getString(String resourceKey) throws MissingResourceException {
        String value = this.getString(resourceKey, null, this.getLocale());
        if (value != null) {
            return value;
        }
        throw new MissingResourceException(ResourceManager.getErrorMessage(resourceKey), this.toString(), resourceKey);
    }

    public String getString(String resourceKey, Locale locale) throws MissingResourceException {
        String value = this.getString(resourceKey, null, locale);
        if (value != null) {
            return value;
        }
        throw new MissingResourceException(ResourceManager.getErrorMessage(resourceKey), this.toString(), resourceKey);
    }

    public String getString(String resourceKey, String defaultValue) {
        return this.getString(resourceKey, defaultValue, this.getLocale());
    }

    public String getString(String resourceKey, String defaultValue, Locale locale) {
        Map map = this.getStringsForLocale(locale);
        String value = (String)map.get(resourceKey);
        if (VERBOSE) {
            if (value != null) {
                ResourceManager.trace("Got string '" + resourceKey + "' = '" + value + "'");
            } else {
                ResourceManager.trace("Failed to load string '" + resourceKey + "' from locale '" + locale + "'");
            }
        }
        return value == null ? defaultValue : value;
    }

    public String getString(String resourceKey, Object[] args) throws MissingResourceException {
        return new MessageFormat(this.getString(resourceKey), this.getLocale()).format(args);
    }

    public String getString(String resourceKey, Object[] args, String defaultValue) {
        String value = this.getString(resourceKey, (String)null);
        if (value == null) {
            return defaultValue;
        }
        return new MessageFormat(value, this.getLocale()).format(args);
    }

    public String getSafeString(String resourceKey) {
        try {
            return this.getString(resourceKey);
        }
        catch (MissingResourceException e) {
            try {
                return MessageFormat.format(this.getString("error.resource.missing"), resourceKey);
            }
            catch (MissingResourceException e2) {
                return e.toString();
            }
        }
    }

    public String getSafeString(String resourceKey, Object[] args) {
        try {
            return this.getString(resourceKey, args);
        }
        catch (MissingResourceException e) {
            try {
                return MessageFormat.format(this.getString("error.resource.missing"), resourceKey);
            }
            catch (MissingResourceException e2) {
                return e.toString();
            }
        }
    }

    public int getInt(String resourceKey, int defaultValue) {
        try {
            return this.getInt(resourceKey);
        }
        catch (MissingResourceException e) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    public int getInt(String resourceKey) throws MissingResourceException, NumberFormatException {
        return Integer.parseInt(this.getString(resourceKey));
    }

    public Locale getLocale() {
        return this.m_localeCallback == null ? Locale.getDefault() : this.m_localeCallback.getLocale();
    }

    private void loadResourceForAllLocales(String resourceName, ClassLoader loader) {
        for (Map.Entry entry : this.m_loadedStrings.entrySet()) {
            Locale locale = (Locale)entry.getKey();
            Map strings = (Map)entry.getValue();
            try {
                this.loadResourceForLocale(resourceName, loader, locale, strings);
            }
            catch (Exception e) {
                if (!TRACE) continue;
                ResourceManager.trace("Failed to load resource '" + resourceName + "' for locale '" + locale + "'");
            }
        }
    }

    private void loadResourceForLocale(String resourceName, ClassLoader loader, Locale locale, Map strings) {
        Properties properties = this.getResourceAsProperties(resourceName, locale, loader);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (VERBOSE) {
                ResourceManager.trace("Loading '" + key + "' = '" + value + "'");
            }
            strings.put(key, value);
        }
    }

    private String alternateCase(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            c = i % 2 == 0 ? Character.toLowerCase(c) : Character.toUpperCase(c);
            sb.append(c);
        }
        return sb.toString();
    }

    private static String japaneseASCII(String s) {
        if (s.startsWith("#") && s.length() == 7) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        boolean hasAmpersand = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                case '&': {
                    hasAmpersand = true;
                }
                default: {
                    if (c <= ' ' || c >= '\u007f') break;
                    c = (char)(c + 65248);
                }
            }
            sb.append(c);
        }
        String japanese = sb.toString();
        if (hasAmpersand && sm_NBSP_JA != null) {
            japanese = japanese.replaceAll(sm_NBSP_JA, "&nbsp;");
        }
        return japanese;
    }

    private void loadAllResourcesForLocale(Locale locale, Map strings) {
        for (Map.Entry entry : this.m_loadableResources.entrySet()) {
            String resourceName = (String)entry.getKey();
            ClassLoader loader = (ClassLoader)entry.getValue();
            try {
                this.loadResourceForLocale(resourceName, loader, locale, strings);
            }
            catch (Exception e) {
                if (!TRACE) continue;
                ResourceManager.trace("Failed to load resource '" + resourceName + "' for locale '" + locale + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getStringsForLocale(Locale locale) {
        ResourceManager resourceManager = this;
        synchronized (resourceManager) {
            Map strings = (Map)this.m_loadedStrings.get(locale);
            if (strings == null) {
                strings = CollectionTools.createMap();
                this.m_loadedStrings.put(locale, strings);
                this.loadAllResourcesForLocale(locale, strings);
            }
            return strings;
        }
    }

    private static String getErrorMessage(String resourceKey) {
        return "Could not find string " + resourceKey;
    }

    private static void trace(String message) {
        System.out.println("ResourceManager: " + message);
    }

    private boolean isNotTranslatable(String value) {
        if (value.startsWith("/")) {
            return true;
        }
        return value.indexOf(" ") == -1 && value.indexOf(".") != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getResourceAsProperties(String resourceName, Locale locale, ClassLoader loader) throws MissingResourceException {
        List resourceNames = this.calculateResourceNames(resourceName, locale);
        Collections.reverse(resourceNames);
        Properties properties = new Properties();
        for (String name : resourceNames) {
            String propertyName = name.replace('.', '/') + ".properties";
            InputStream in = loader.getResourceAsStream(propertyName);
            if (in == null) continue;
            try {
                if (DEBUG_LOCALE && propertyName.indexOf("_en") != -1) {
                    Properties tempProperties = new Properties();
                    tempProperties.load(new BufferedInputStream(in));
                    if (TRACE) {
                        ResourceManager.trace("Loading resource '" + resourceName + "' for locale '" + locale + "'");
                        ResourceManager.trace("    '" + propertyName + "' : " + properties.size() + " alternate case entries");
                    }
                    Enumeration<Object> e = tempProperties.keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        String value = tempProperties.getProperty(key);
                        if (this.isNotTranslatable(value)) {
                            properties.put(key, value);
                            continue;
                        }
                        properties.put(key, this.alternateCase(value));
                    }
                    continue;
                }
                if (DEBUG_JA_LOCALE && propertyName.indexOf("_ja") != -1) {
                    String newPropertyName = propertyName.replaceAll("_ja", "_en");
                    InputStream in2 = loader.getResourceAsStream(newPropertyName);
                    if (in2 == null) {
                        properties.load(new BufferedInputStream(in));
                        if (!TRACE) continue;
                        ResourceManager.trace("Loading resource '" + resourceName + "' for locale '" + locale + "'");
                        ResourceManager.trace("    '" + propertyName + "' : " + properties.size() + " entries");
                        continue;
                    }
                    Properties tempProperties = new Properties();
                    tempProperties.load(new BufferedInputStream(in2));
                    if (TRACE) {
                        ResourceManager.trace("Loading resource '" + resourceName + "' for locale '" + locale + "'");
                        ResourceManager.trace("    '" + propertyName + "' : " + properties.size() + " Japanese ASCII entries");
                    }
                    Enumeration<Object> e = tempProperties.keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        String value = tempProperties.getProperty(key);
                        if (this.isNotTranslatable(value)) {
                            properties.put(key, value);
                            continue;
                        }
                        properties.put(key, ResourceManager.japaneseASCII(value));
                    }
                    continue;
                }
                properties.load(new BufferedInputStream(in));
                if (!TRACE) continue;
                ResourceManager.trace("Loading resource '" + resourceName + "' for locale '" + locale + "'");
                ResourceManager.trace("    '" + propertyName + "' : " + properties.size() + " entries");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                StreamUtil.close(in);
            }
        }
        if (properties.size() > 0) {
            return properties;
        }
        throw new MissingResourceException("Can't find bundle for base name '" + resourceName + "', locale '" + locale + "'", resourceName + "_" + locale, "");
    }

    private List calculateResourceNames(String baseName, Locale currentLocale) {
        ArrayList<String> names = new ArrayList<String>();
        ResourceManager.calculateResourceNamesForLocale(names, baseName, currentLocale);
        if (!currentLocale.getLanguage().equals("en")) {
            ResourceManager.calculateResourceNamesForLocale(names, baseName, Locale.ENGLISH);
        }
        names.add(baseName);
        if (TRACE) {
            for (String name : names) {
                ResourceManager.trace("          " + name);
            }
        }
        return names;
    }

    private static void calculateResourceNamesForLocale(List allNames, String baseName, Locale locale) {
        ArrayList<String> names = new ArrayList<String>();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (language.length() > 0) {
            StringBuffer name = new StringBuffer(baseName);
            name.append('_').append(language);
            names.add(name.toString());
            if (country.length() > 0) {
                name.append('_').append(country);
                names.add(name.toString());
                if (variant.length() > 0) {
                    name.append('_').append(variant);
                    names.add(name.toString());
                }
            }
        }
        for (int at = names.size() - 1; at >= 0; --at) {
            allNames.add(names.get(at));
        }
    }

    static {
        sm_instance.addStandardResources(ResourceManager.class);
        sm_NBSP_JA = ResourceManager.japaneseASCII("&nbsp;");
    }

    public static interface LocaleCallback {
        public Locale getLocale();
    }
}

